/* Rozdzia 10. multiPCav.c.				*/
/* ZADANIE DLA CIEBIE: to program oparty na wtkach Pthreads program. Przekszta dla systemu Windows.	*/
/* Obecna wersja nie zbuduje si jako projekt systemu Windows. */
/* Zarzdzaj producentem i kilka konsumentami.			*/
/* Producent tworzy bufory mData z sum kontroln  	*/
/* (bloki komunikatu), ktre konsument przetwarza, generujc 	*/
/* statystyki. Konsument wczytuje NASTPNY kompletny bufor		*/
/* mData i sprawdza jego poprawno przed wywietleniem.		*/
/* Producent nie tworzy nowych danych do czasu wykorzystania poprzedniego	*/
/* bufora (jest on wykorzystywany przez jeden wtek konsumenta).	*/
/* Wtek gwny tworzy nowych konsumentw na danie.	*/
/* Wymaga pamici specyficznej dla wtku i jednokrotnego inicjowania.	*/

#include "pthread.h"
/* Zmie definicj MSG_BLOCK w pliku messages.h przez zastpienie uchwytw HANDLE odpowiednim typem. */
#include "messages.h"
#include "pcstats.h"
#include "errors.h"
#include <stdio.h>

#define MAX_CONSUMER 128

/* Niezmiennik i predykaty zmiennej warunkowej:		*/
/*	Niezmiennik - speniony jest jeden z warunkw: 	*/
/*	  1)	f_consumed 					*/
/*			 nie mona niczego zakada na temat danych	*/
/*	  2)	(fStop || f_ready) && dane s prawidowe			*/
/*	   && checksum i timestamp s prawidowe			*/ 
/*	Predykaty zmiennej warunkowej:				*/
/*	  1)	mconsumed tylko jeli f_consumed || fStop	*/
/*	  2)	mReady tylko jeli f_ready			*/


/* Pojedynczy blok komunikatu gotowy do uzupenienia nowymi danymi. 	*/
struct MSG_BLOCK mBlock = { PTHREAD_MUTEX_INITIALIZER, 
	PTHREAD_COND_INITIALIZER, PTHREAD_COND_INITIALIZER, 
	1, 0, 0, 0 }; 

void * Produce (void *), * Consume (void *);
void MessaeFill (MSG_BLOCK *);

void accumulate_statistics ();
void report_statistics();
void once_init_function (void);

int main (int argc, char * argv[])
{
	int tstatus, nc = 0, ic;
	pthread_t produce_t, consume_t;
	char command, extra;
	pthread_t consumer_thread [MAX_CONSUMER];
		
	/* Tworzenie wtku producenta. */
	tstatus = pthread_create (&produce_t, NULL, Produce, NULL);
	if (tstatus != 0) 
		err_abort (tstatus, "Nie mozna utworzyc watku producenta.");
		
	/* Pytanie uytkownika o to, czy utworzy wtek konsumenta, czy zamkn program. */
	while (!mBlock.fStop) { /* Jedyny wtek z dostpem do urzdze stdin i stdout. */
		printf ("\n**Wpisz 's', aby skonsumowac, lub 'z', aby zatrzymac: ");
		scanf ("%c%c", &command, &extra);
		if (command == 'z') {
			pthread_mutex_lock (&mBlock.nGuard);
			mBlock.fStop = 1;
			pthread_cond_signal (&mBlock.mReady);
			pthread_mutex_unlock (&mBlock.nGuard);
		} else if (command == 's' && nc < MAX_CONSUMER-1) { 
			tstatus = pthread_create 
				(&consumer_thread[nc++], NULL, Consume, &mBlock);
			if (tstatus != 0) 
				err_abort (tstatus, "Nie mozna utworzyc watku konsumenta.");
		} else {
			printf ("Niedozwolone polecenie lub zbyt wielu konsumentow.\n");
		}
	}
		
	printf ("\nKonsumenci zwroca wyniki i zakoncza dzialanie.\n\n");
	
	/* Oczekiwanie na zakonczenie pracy przez producenta. */
	tstatus = pthread_join (produce_t, NULL);
	if (tstatus != 0) 
		err_abort (tstatus, "Nie mozna dolaczyc watku producenta.\n");

	/* Oczekiwanie na zakonczenie pracy przez konsumenta. */
	for (ic = 0; ic < nc; ic++) {
		tstatus = pthread_join (consumer_thread[ic], NULL);
		if (tstatus != 0) 
			err_abort (tstatus, "Nie mozna dolaczyc watku konsumenta.");
	}
	
	printf ("Watki producenta i konsumenta zakonczyly prace.\n");
	return 0;
}

void * Produce (void *arg)
/* Wtek producenta - tworzy nowe komunikaty, kiedy konsument jest gotowy. */
{
	int nproduced = 0;
	
	while (!mBlock.fStop) {
		
		/* Pobieranie bufora, oczekiwanie na moment, kiedy mona bezpiecznie go
		   zapeni, zapenianie go i informowanie konsumenta. */		
		pthread_mutex_lock (&mBlock.nGuard);
		while (!mBlock.f_consumed && !mBlock.fStop)
			pthread_cond_wait (&mBlock.mconsumed, &mBlock.nGuard);
		if (!mBlock.fStop) {
			MessaeFill (&mBlock);
			mBlock.sequence++;
			mBlock.f_consumed = 0;
			mBlock.f_ready = 1;
			nproduced++;
		}
		pthread_cond_signal (&mBlock.mReady);
		pthread_mutex_unlock (&mBlock.nGuard);
	}
	printf ("Zamykanie producenta po wygenerowaniu %d komunikatow\n", nproduced);
	return NULL;
}

void MessageFill (msg_block_t *mBlock)
{
	/* Zapenianie bufora na komunikat oraz tworzenie sumy kontrolnej i znacznika czasu.	*/
	/* Ta funkcja jest wywoywana w wtku producenta, kiedy zajmuje on 	*/
	/* muteks bloku komunikatu.					*/
	
	int i;
	
	mBlock->checksum = 0;	
	for (i = 0; i < DATA_SIZE; i++) {
		mBlock->data[i] = rand();
		mBlock->checksum ^= mBlock->data[i];
	}
	mBlock->timestamp = time(NULL);
	return;
}

void *Consume (void *arg)
/* Funkcja wtku konsumenta. */
{
	msg_block_t *pmb;
	statistics_t * ps;
	int my_number, tstatus;
	struct timespec timeout, delta;
	
	delta.tv_sec = 2;
	delta.tv_nsec = 0;
		
	/* Tworzenie klucza dla pamici specyficznej dla wtku. */
	tstatus = pthread_once (&once_control, once_init_function);
	if (tstatus != 0) err_abort (tstatus, "Nieudane jednokrotne inicjowanie.");

	pmb = (msg_block_t *)arg;

	/* Alokowanie pamici na statystyki specyficzne dla wtku. */
	ps = calloc (sizeof(statistics_t), 1);
	if (ps == NULL) errno_abort ("Nie mozna zaalokowac pamieci.");
	tstatus = pthread_setspecific (ts_key, ps);
	if (tstatus != 0) err_abort (tstatus, "Blad ustawiania pamieci.");
	ps->pmblock = pmb;
	/* Przydzielanie wtkowi niepowtarzalnej liczby. */
	/* Warto zauway, e muteks jest "przeciony" w celu ochrony	*/
	/* danych poza struktur bloku komunikatu.			*/
	tstatus = pthread_mutex_lock (&pmb->nGuard);
	if (tstatus != 0) err_abort (tstatus, "Blad blokowania.");
	ps->th_number = thread_number++;
	tstatus = pthread_mutex_unlock (&pmb->nGuard);
	if (tstatus != 0) err_abort (tstatus, "Blad odblokowywania.");
	
	/* Konsumowanie NASTPNEGO komunikatu na danie uytkownika. */
	while (!pmb->fStop) { /* Jedyny wtek z dostpem do urzdze stdin i stdout. */
		tstatus = pthread_mutex_lock (&pmb->nGuard);
		if (tstatus != 0) err_abort (tstatus, "Blad blokowania.");
		/* Pobieranie nastpnego komunikatu. Uywanie oczekiwania z limitem czasu, aby mona	*/
		/* okresowo sprawdza flag zatrzymania.				*/
		do { 
			pthread_get_expiration_np (&delta, &timeout);
			tstatus = pthread_cond_timedwait 
				(&pmb->mReady, &pmb->nGuard, &timeout);
			if (tstatus != 0 && tstatus != ETIMEDOUT) 
				err_abort (tstatus, "Blad oczekiwania na zmienna warunkowa.");
		} while (!pmb->f_ready && !pmb->fStop);
		if (!pmb->fStop) {
			accumulate_statistics ();
			pmb->f_consumed = 1;
			pmb->f_ready = 0;
		}
		tstatus = pthread_cond_signal (&pmb->mconsumed);
		if (tstatus != 0) err_abort (tstatus, "Blad zglaszania.");
		tstatus = pthread_mutex_unlock (&pmb->nGuard);
		if (tstatus != 0) err_abort (tstatus, "Blad odblokowywania.");
	}
	
	/* Zamykanie. Wywietlanie statystyk. */
	tstatus = pthread_mutex_lock (&pmb->nGuard);
	if (tstatus != 0) err_abort (tstatus, "Blad blokowania.");
	report_statistics ();	
	tstatus = pthread_mutex_unlock (&pmb->nGuard);
	if (tstatus != 0) err_abort (tstatus, "Blad odblokowywania.");

	/* Zamknicie wtku konsumenta. Destruktor 	*/
	/* zwalnia pami zaalokowan na statystyki.	*/
	return NULL;		
}

