/* ThbObjectsX.c. Listing 10.2.		WERSJA Z BDAMI							*/
/* Biblioteka zoonych obiektw synchronizacji (barier z progiem).		*/

#include "Everything.h"
#include "synchobj.h"

/*******************************/
/*  OBIEKTY BARIERY Z PROGIEM. */
/*******************************/

DWORD CreateThresholdBarrier (THB_HANDLE *pthb, DWORD b_value)
{
	THB_HANDLE hthb;
	/* Inicjowanie obiektu bariery. */
	hthb = malloc (sizeof(THRESHOLD_BARRIER));
	*pthb = hthb;
	if (hthb == NULL) return 1;

	hthb->b_guard = CreateMutex (NULL, TRUE, NULL);
	if (hthb->b_guard == NULL) return 2;
	
	hthb->b_broadcast = CreateEvent (NULL, TRUE, FALSE, NULL);
	if (hthb->b_broadcast == NULL) return 3;
	
	hthb->b_threshold = b_value;
	hthb->b_count = 0;
	return 0;
}


DWORD WaitThresholdBarrier (THB_HANDLE thb)
{
	/* Oczekiwanie na dojcie do bariery okrelonej liczby wtkw */
    /* i rozpowszechnianie zgoszenia za pomoc zmiennej warunkowej. */
	
	WaitForSingleObject (thb->b_guard, INFINITE);
	thb->b_count++;  /* Dotar nowy wtek. */
		
	while (thb->b_count < thb->b_threshold) {
		ReleaseMutex (thb->b_guard);
		WaitForSingleObject (thb->b_broadcast, CV_TIMEOUT);
		WaitForSingleObject (thb->b_guard, INFINITE);
	}
	PulseEvent (thb->b_broadcast); /* Rozpowszechnianie zgoszenia wrd wszystkich czekajcych wtkw. */
	ReleaseMutex (thb->b_guard);	
	return 0;
}


DWORD CloseThresholdBarrier (THB_HANDLE thb)
{
	/* Usuwanie muteksu i zdarzenia komponentu, kiedy jest to bezpieczne. */
	CloseHandle (thb->b_guard);
	CloseHandle (thb->b_broadcast);
	free (thb);
	return 0;

}
