/* ThbObject.c. Listing 10.2.							*/
/* Biblioteka zoonych obiektw synchronizacji (barier z progiem).		*/

#include "Everything.h"
#include "synchobj.h"

/*******************************/
/*  OBIEKTY BARIERY Z PROGIEM. */
/*******************************/

DWORD CreateThresholdBarrier (THB_OBJECT *pThb, DWORD bValue)
{
	THB_OBJECT objThb;
	/* Inicjowanie obiektu bariery. */
	objThb = malloc (sizeof(THRESHOLD_BARRIER));
	if (objThb == NULL) return SYNCH_OBJ_NOMEM;

	objThb->bGuard = CreateMutex (NULL, FALSE, NULL);
	if (objThb->bGuard == NULL) return SYNCH_OBJ_CREATE_FAILURE;
	
	/* Zdarzenie z rcznym zerowaniem. */
	objThb->bEvent = CreateEvent (NULL, TRUE, FALSE, NULL);
	if (objThb->bEvent == NULL) return SYNCH_OBJ_CREATE_FAILURE;
	
	objThb->bThreshold = bValue;
	objThb->bCount = 0;

	*pThb = objThb;

	return 0;
}

DWORD WaitThresholdBarrier (THB_OBJECT thb)
{
	/* Oczekiwanie na dojcie do bariery okrelonej liczby wtkw */
    /* i rozpowszechnianie zgoszenia za pomoc zmiennej warunkowej. */

	WaitForSingleObject (thb->bGuard, INFINITE);
	thb->bCount++;  /* Dotar nowy wtek. */
	while (thb->bCount < thb->bThreshold) {
		SignalObjectAndWait (thb->bGuard, thb->bEvent, INFINITE, FALSE);
		WaitForSingleObject (thb->bGuard, INFINITE);
	}
	SetEvent (thb->bEvent); /* Rozpowszechnianie zgoszenia wrd wszystkich czekajcych wtkw. */
    /* UWAGA: program rozpowszechnia zgoszenie wrd wszystkich czekajcych wtkw,
     * JEDNAK mona uy funkcji SetEvent, poniewa warunek jest stay i
     * nie trzeba zerowa zdarzenia. */
	ReleaseMutex (thb->bGuard);	
	return 0;
}

DWORD CloseThresholdBarrier (THB_OBJECT thb)
{
	/* Usuwanie muteksu i zdarzenia komponentu, kiedy jest to bezpieczne. */
	/* Nie jest to idealne rozwizanie, ale zgodne z usuniciem uchwytu */
	/* muteksu w czasie oczekiwania na niego przez inny wtek. */
	WaitForSingleObject (thb->bGuard, INFINITE);
	/* Naley si upewni, e aden wtek nie czeka na obiekt. */
	if (thb->bCount < thb->bThreshold) {
		ReleaseMutex (thb->bGuard);
		return SYNCH_OBJ_BUSY;
	}

	/* Teraz mona zwolni muteks i zamkn uchwyt. */
	ReleaseMutex (thb->bGuard);
	CloseHandle (thb->bEvent);
	CloseHandle (thb->bGuard);
	free (thb);
	return 0;
}
