/*	Testowanie zoonego obiektu synchronizacji - semafora
    z moliwoci oczekiwania na wiele jednostek. */


#include "Everything.h"
#include "Synchronize.h"

static DWORD WINAPI ProducerTh (LPVOID);
static DWORD WINAPI ConsumerTh (LPVOID);
static DWORD WINAPI MonitorTh (LPVOID);
static BOOL WINAPI CtrlcHandler (DWORD);

static SYNCHHANDLE hSemMW;
static LONG SemMax, SemInitial, NumProducers, NumConsumers, TotalExcess = 0;
static HANDLE hTestMutex;
static volatile BOOL Debug = FALSE;

static volatile BOOL Exit = FALSE;

static volatile DWORD NumSuccess = 0, NumFailures = 0, NumProduced = 0,
				FailureCount = 0, NumConsumed = 0;
static LPDWORD ProducerCount, ConsumerCount;


int _tmain (int argc, LPTSTR argv[])
	/*	Testowanie semaforw zbudowanych za pomoc muteksu, licznika i
		zdarzenia z automatycznym zerowaniem. */

{

	HANDLE * Producer, * Consumer;
	LONG_PTR iThread;
	DWORD ThreadId;
	HANDLE hMonitor;
	BOOL FirstCFS;		/*  Pierwszy przyszed-pierwszy obsuony czy pierwszy dostpny? */
	TCHAR Name [MAX_PATH] = _T("");

	FILETIME FileTime;	/* Inicjowanie generatora liczb losowych. */
	SYSTEMTIME SysTi;

	if (!WindowsVersionOK (4, 0)) 
		ReportError (_T("Ten program wymaga systemu Windows NT 4.0 lub nowszego."), 1, FALSE);


	GetSystemTime (&SysTi);
	SystemTimeToFileTime (&SysTi, &FileTime);
	srand (FileTime.dwLowDateTime);

	if (!SetConsoleCtrlHandler (CtrlcHandler, TRUE))
		ReportError (_T("Nie mozna ustawic procedury sterujacej konsoli."), 1, TRUE);

	_tprintf (_T("\nPodaj parametry SemMax, SemInitial, NumConsumers, NumProducers, FirstCFS i Debug "));
	_tscanf (_T("%d %d %d %d %d %d"), &SemMax, &SemInitial, &NumConsumers, 
		&NumProducers, &FirstCFS, &Debug);
	_tprintf (_T("\nWpisz nazwe - NULL oznacza brak: "));
	_tscanf (_T("%s"), Name);
	if (_tcscmp (Name, _T("NULL")) == 0) _tcscpy (Name, _T(""));	

	/* if (Debug) */ _tprintf (_T("Wprowadzone dane: %d %d %d %d %d %s\n"), 
		SemMax, SemInitial, NumConsumers, NumProducers, FirstCFS, Name);

	/*	Tworzenie muteksu do synchronizacji rnych aspektw testu, na przykad
		aktualizowania statystyk. Obiekt CS nie zadziaa, poniewa potrzebne jest wywoanie funkcji
		WaitForMultipleObjects dla tego muteksu w wtku monitorujcym. */
	hTestMutex = CreateMutex (NULL, FALSE, NULL);
	if (hTestMutex == NULL) ReportError (_T("Nie mozna utworzyc testowego muteksu."), 2, TRUE);

	NumProduced = SemInitial; /* Inicjowanie statystk uzytkowania semafora. */


	hSemMW = CreateSemaphoreMW (NULL, SemInitial, SemMax, FirstCFS, Name); 
	if (hSemMW == NULL) {
		_tprintf (_T("LastError: %x\n"), GetLastError());	
		ReportError (_T("Nieudane tworzenie semafora."), 3, TRUE);
	}
	if (Debug) _tprintf (_T("Udane tworzenie semafora.\n"));

	/*  Tworzenie wszystkich wtkw do zajmowania i zwalniania semafora. */
	/*	Tworzenie tablicy na uchwyt wtkw i tablic liczb cakowitych na
		liczb iteracji kadego wtku. Przez obserwacj tych licznikw mona
		si upewni, e nie wystpio zakleszczenie. */

	if (NumConsumers > 0) {
		Consumer = malloc (NumConsumers*sizeof(HANDLE));
		if (Consumer == NULL)
			ReportError (_T("Nie mozna zaalokowac uchwytow konsumenta."), 5, FALSE);
		ConsumerCount = HeapAlloc (GetProcessHeap(), HEAP_ZERO_MEMORY, NumConsumers*sizeof(DWORD));
		if (ConsumerCount == NULL)
			ReportError (_T("Nie mozna zaalokowac uchwytow konsumenta."), 5, FALSE);
	}
	
	if (NumProducers > 0) {
		Producer = malloc (NumProducers*sizeof(HANDLE));
		if (Producer == NULL)
			ReportError (_T("Nie mozna zaalokowac uchwytow producenta."), 4, FALSE);
		ProducerCount = HeapAlloc (GetProcessHeap(), HEAP_ZERO_MEMORY, NumProducers*sizeof(DWORD));
		if (ProducerCount == NULL) 
			ReportError (_T("Nie mozna zaalokowac uchwytow producenta."), 4, FALSE);
	}



	hMonitor = (HANDLE)_beginthreadex (NULL, 0, MonitorTh, (LPVOID)5000, CREATE_SUSPENDED, &ThreadId);
	if (hMonitor == NULL) ReportError (_T("Nie mozna utworzyc watku monitorujacego."), 6, TRUE);
	SetThreadPriority (hMonitor, THREAD_PRIORITY_HIGHEST);

	for (iThread = 0; iThread < NumConsumers; iThread++) {
		Consumer [iThread] = (HANDLE)_beginthreadex (NULL, 0, ConsumerTh, (LPVOID)iThread, CREATE_SUSPENDED, &ThreadId);
		if (Consumer[iThread] == NULL) ReportError (_T("Nie mozna utworzyc watku konsumenta."), 3, TRUE);
	}
	for (iThread = 0; iThread < NumProducers; iThread++) {
		Producer [iThread] = (HANDLE)_beginthreadex (NULL, 0, ProducerTh, (LPVOID)iThread, CREATE_SUSPENDED, &ThreadId);
		if (Producer[iThread] == NULL) ReportError (_T("Nie mozna utworzyc watku producenta."), 3, TRUE);
	}

	WaitForSingleObject (hTestMutex, INFINITE);
	_tprintf (_T("Tworzenie wszystkich watkow zakonczylo sie powodzeniem.\n"));
	ReleaseMutex (hTestMutex);
	for (iThread = 0; iThread < NumConsumers; iThread++) ResumeThread (Consumer [iThread]);
	for (iThread = 0; iThread < NumProducers; iThread++) ResumeThread (Producer [iThread]);

	ResumeThread (hMonitor);

	if (NumConsumers > 0) WaitForMultipleObjects (NumConsumers, Consumer, TRUE, INFINITE);
	if (NumProducers > 0) WaitForMultipleObjects (NumProducers, Producer, TRUE, INFINITE);
	WaitForSingleObject (hMonitor, INFINITE);

	for (iThread = 0; iThread < NumConsumers; iThread++) CloseHandle (Consumer [iThread]);
	for (iThread = 0; iThread < NumProducers; iThread++) CloseHandle (Producer [iThread]);


	HeapFree (GetProcessHeap(), 0, Producer); HeapFree (GetProcessHeap(), 0, Consumer);
	HeapFree (GetProcessHeap(), 0, ProducerCount); 
	HeapFree (GetProcessHeap(), 0, ConsumerCount);
	
	CloseHandle (hMonitor);
	if (!CloseSynchHandle (hSemMW))
		ReportError (_T("Nieudane zamykanie uchwytu synchronizacji."), 0, TRUE);

	_tprintf (_T("Wszystkie watki zakonczyly dzialanie.\n"));
	return 0;
}


static DWORD WINAPI ProducerTh (LPVOID ThNumber)
/*	Wtek producenta:
	1.	Wykonuje obliczenia przez losowy czas.
	2.	Generuje losow liczb jednostek z przedziau [1, SemMax].
		Jednostki nie s produkowane, jeli powoduje to przekroczenie maksymalnej
		wartoci licznika semafora (jest to spjne z dziaaniem semaforw
		w systemach Win32).
	3.	Liczba generowanych jednostek jest dwukrotnie wiksza ni liczba 
	    konsumowanych jednostek. Dzieje si tak, poniewa proces produkcji czsto
		koczy si niepowodzeniem z uwagi na zbyt du liczb gotowych jednostek.
*/
{
	DWORD_PTR Id = (DWORD_PTR)ThNumber;
	DWORD Delay, i, k;
	LONG PrevCount = 0, RelCount = 0;

	WaitForSingleObject (hTestMutex, INFINITE);
	if (Debug) _tprintf (_T("Uruchamianie producenta numer %d.\n"), Id);
	ReleaseMutex (hTestMutex);

	while (!Exit) {
		/* Opnienie, ktre niekoniecznie oznacza udostpnienie procesora. Warto zauway,
			e tempo produkcji i konsumpcji jest takie samo, aby zrwnoway system. */
		Delay = rand() / 2; 
		for (i = 0; i < Delay; i++) k = rand()*rand() / 2; /* "Marnowany" czas. */
		if (rand() % 3 == 0) Sleep (rand()/(RAND_MAX/500)); /* Udostpnianie procesora przez 1/3 czasu,
									aby interakcja midzy wtkami bya ciekawsza. */

		RelCount = (long)(((float)rand()/RAND_MAX) * SemMax)+1;

		if (!ReleaseSemaphoreMW (hSemMW, RelCount, &PrevCount)) {
			WaitForSingleObject (hTestMutex, INFINITE);
			if (Debug) _tprintf (_T("Awaria producenta numer %d. PrevCount = %d RelCount = %d\n"),
				Id, PrevCount, RelCount);
			NumFailures++;				/* Zachowywanie statystyk na temat producenta. */
			FailureCount += RelCount;
			ReleaseMutex (hTestMutex);
		} else {
			WaitForSingleObject (hTestMutex, INFINITE);
			if (Debug) _tprintf (_T("Producent numer %d poprawnie zakonczyl prace. PrevCount = %d, RelCount = %d\n"),
				Id, PrevCount, RelCount);
			NumSuccess++;
			NumProduced += RelCount;
			ReleaseMutex (hTestMutex);
		}
		ProducerCount[Id]++;	/*	Liczba iteracji producenta. */
	}


	_endthreadex (0);
	return 0;
}

static DWORD WINAPI ConsumerTh (LPVOID ThNumber)
{
	DWORD_PTR Id = (DWORD_PTR)ThNumber;
	DWORD Delay, i, k;
	LONG SeizeCount;

	WaitForSingleObject (hTestMutex, INFINITE);
	if (Debug) _tprintf (_T("Uruchamianie konsumenta numer %d.\n"), Id);
	ReleaseMutex (hTestMutex);

	while (!Exit) {
		/* Opnienie, ktre niekoniecznie oznacza udostpnienie procesora. */
		Delay = rand();
		for (i = 0; i < Delay; i++) k = rand()*rand(); /* "Marnowany" czas. */;
		if (rand() % 3 == 0) Sleep (rand()/(RAND_MAX/1000)); 
				/*	Udostpnianie procesora przez 1/3 czasu,
									aby interakcja midzy wtkami bya ciekawsza. */

		/*	danie losowej wielkoci. */
		SeizeCount = (long)(((float)rand()/RAND_MAX) * SemMax)+1;

		if (WaitForSemaphoreMW (hSemMW, SeizeCount, rand()) != WAIT_OBJECT_0) {
			if (Debug) {
				WaitForSingleObject (hTestMutex, INFINITE);
				if (Debug) _tprintf (_T("Konsument numer %d przekroczyl limit czasu, oczekujac na %d jednostek.\n"), 
					Id, SeizeCount);
				ReleaseMutex (hTestMutex);
			}
		} else { /*  Wtek otrzyma jednostki semafora - naley zaktualizowa statystyki. */
			WaitForSingleObject (hTestMutex, INFINITE);
			if (Debug) _tprintf (_T("Konsument numer %d otrzymal %d jednostek.\n"), Id, SeizeCount);
			NumConsumed += SeizeCount;
			ReleaseMutex (hTestMutex);
		}
		ConsumerCount[Id]++;	/* Liczba iteracji konsumenta. */
	}

	_endthreadex (0);
	return 0;
}


static DWORD WINAPI MonitorTh (LPVOID Delay)
/*	Wtek monitorujcy - okresowo sprawdza statystyki pod ktem spjnoci. */
{
	LONG CurCount = 0, Max = 0, ExcessCount, i;
	SYNCHHANDLE hState;

	HANDLE hBoth[2] = {hTestMutex, hSemMW->hMutex}; 
		/*	Zagldanie do nieprzezroczystego uchwytu to "oszustwo", jednak potrzebny jest 
			jednoczesny dostp do stanu semafora i statystyk w celu sprawdzenia spjnoci.
			Moe jednak wystpi brak spjnoci, poniewa statystyki s aktualizowane
			niezalenie od zmiany stanu semafora, dlatego semafor moe zosta zmodyfikowany
			przez inny wtek, zanim producent lub konsument zdy zaktualizowa globalne
			statystyki. Dlatego moe brakowa bezwzgldnej spjnoci midzy stanem semafora i
			globalnymi statystykami przechowywanymi przez program testowy. Zapewnienie 
			takiej spjnoci wymaga umieszczenia cia ptli producenta i konsumenta w 
			sekcji krytycznej, co jest niezgodne z asynchronicznoci potrzebn w testach.
			Jednak oglnie mona sprawdzi stan semafora, a take upewni si, e nie 
			zosta on uszkodzony. */

	/*	Pobieranie uchwytu do stanu semafora - nastpne "oszustwo". */
	hState = (hSemMW->SharedHandle == NULL) ? hSemMW : hSemMW->SharedHandle;

	while (!Exit) {
		WaitForMultipleObjects (2, hBoth, TRUE, INFINITE);
		CurCount = hState->CurCount;
		Max = hState->MaxCount;

		ExcessCount = NumProduced - (NumConsumed + CurCount); 
		/*  Nadmiar produkcji nad konsumpcj powinien rednio wynosi 0.
			Warto zauway, e przy wspuytkowanym semaforze mog wystpi niezgodnoci
			w kadym procesie, poniewa liczniki uywane w tecie s lokalne dla
			kadego procesu.  */
		_tprintf (_T("**Monitorowanie - statystyki:\nWygenerowano: %d\nSkonsumowano: %d\nObecnie:  %d\nMaksimum:  %d\n"), 
			NumProduced,  NumConsumed, CurCount, Max);
		/*  Aby poprawno bya zachowana, musi zachodzi warunek Produced == Consumed + CurCount */
		if (ExcessCount != 0 || CurCount < 0 || CurCount > SemMax || SemMax != Max) {
			 _tprintf (_T("****Niezgodnosc: %d\n"), ExcessCount);
			 		TotalExcess += ExcessCount;
		}
		else _tprintf (_T("****Test spojnosci zakonczony powodzeniem. TotalExcess: %d\n"), TotalExcess);
		
		_tprintf (_T("Udane zwolnienia: %d\nNieudane zwolnienia:     %d\n"), NumSuccess, NumFailures);
		_tprintf (_T("Niezwolnione jednostki:       %d\n"), FailureCount);
		_tprintf (_T("Liczba iteracji konsumenta wedlug watkow.\n"));
		for (i = 0; i < NumConsumers; i++) _tprintf (_T("%6d"), ConsumerCount[i]);
		_tprintf (_T("\nLiczba iteracji konsumenta wedlug watkow.\n"));
		for (i = 0; i < NumProducers; i++) _tprintf (_T("%6d"), ProducerCount[i]);

		_tprintf (_T("\n**************\n"));

		ReleaseMutex (hTestMutex);
		ReleaseMutex (hSemMW->hMutex);

		/* Ignorowanie ostrzee dotyczcych przycicia wskanika w systemach Win64. */
		Sleep ((DWORD)Delay);
	}

	_endthreadex(0);
	return 0;
}

static BOOL WINAPI CtrlcHandler (DWORD CtrlEvent)
{
	DWORD PrevCount;
	LONG i, c;

	if (CtrlEvent == CTRL_C_EVENT) {
		WaitForSingleObject (hTestMutex, INFINITE);
		_tprintf (_T("Otrzymano kombinacje Ctrl+C. Zamykanie.\n"));
		ReleaseMutex (hTestMutex);
	}

	else if (CtrlEvent == CTRL_CLOSE_EVENT) {
		WaitForSingleObject (hTestMutex, INFINITE);
		_tprintf (_T("Zgloszono zdarzenie zamkniecia. Zamykanie.\n"));
		ReleaseMutex (hTestMutex);
	}


	else if (CtrlEvent == CTRL_SHUTDOWN_EVENT) {
		WaitForSingleObject (hTestMutex, INFINITE);
		_tprintf (_T("Zgloszono zdarzenie zamkniecia. Wpisz OK, aby kontynuowac.\n"));
		_tscanf (_T("%d"), &c);
		_tprintf (_T("OK\n"));
		ReleaseMutex (hTestMutex);
	}

	else return FALSE;

	Exit = TRUE;

	/*	Zapewnianie, e wtki konsumenta nie zostay zablokowane w oczekiwaniu
		na semafor i mog zosta zamknite. */
	for (i = 0; i < NumConsumers; i++) {
		ReleaseSemaphoreMW (hSemMW, 1, &PrevCount);	
		/*  Zwalnianie procesora, aby mona zaszeregowa konsumenta. */
		Sleep (0);
	}

	return TRUE;

}

