/* Rozdzia 10. QueueObj_Sig.c.	Wersja z funkcj SingalObjectAndWait.		*/
/* Funkcje kolejki. 													*/
/* "Model ze zgaszaniem" (SetEvent i automatyczne zerowanie).			*/
/*	Dokadnie jeden oczekujcy wtek jest zwalniany, kiedy kolejka		*/
/*	staje si niepusta lub niepena. Jest to moliwe, jeli funkcje 	*/
/*	kolejki (QueueGet i QueuePut) modyfikuj j tylko po 				*/
/*	jednym komunikacie. Przy jednorazowym dodawaniu i/lub pobieraniu	*/
/*	wielu komunikatw trzeba zastosowa model z rozpowszechnianiem		*/
/*	(PulseEvent i rczne zerowanie), dlatego wszystkie oczekujce		*/
/*	wtki zostan zwolnione i bd mogy sprawdzi stan kolejki.		*/
/*	Jak opisano w tekcie, przy oczekiwaniu na zdarzenie obowizuje 	*/
/*	nieskoczony limit czasu, poniewa w modelu ze zgaszaniem nie trzeba	*/
/*	przejmowa si utrat zgosze.											*/

#include "Everything.h"
#include "SynchObj.h"

/* Funkcje do zarzdzania skoczon kolejk. */

DWORD QueueGet (QUEUE_OBJECT *q, PVOID msg, DWORD msize, DWORD MaxWait)
{
	WaitForSingleObject (q->qGuard, INFINITE);
	if (q->msgArray == NULL) return 1;  /* Kolejk usunito. */

	while (QueueEmpty (q)) {
		SignalObjectAndWait (q->qGuard, q->qNe, INFINITE, FALSE);
//		ReleaseMutex (q->qGuard);
//		WaitForSingleObject (q->qNe, CV_TIMEOUT);
		WaitForSingleObject (q->qGuard, INFINITE);
	}
	/* Usuwanie komunikatu z kolejki. */
	QueueRemove (q, msg, msize);
	/* Zgaszanie, e kolejka nie jest pena, poniewa usunito komunikat. */
	SetEvent (q->qNf);
	ReleaseMutex (q->qGuard);

	return 0;
}

DWORD QueuePut (QUEUE_OBJECT *q, PVOID msg, DWORD msize, DWORD MaxWait)
{
	WaitForSingleObject (q->qGuard, INFINITE);
	if (q->msgArray == NULL) return 1;  /* Kolejk usunito. */

	while (QueueFull (q)) {
		SignalObjectAndWait (q->qGuard, q->qNf, INFINITE, FALSE);
//		ReleaseMutex (q->qGuard);
//		WaitForSingleObject (q->qNf, CV_TIMEOUT);
		WaitForSingleObject (q->qGuard, INFINITE);
	}
	/* Umieszczanie komunikatu w kolejce. */
	QueueInsert (q, msg, msize);	
	/* Zgaszanie, e kolejka jest niepusta (po wstawieniu komunikatu). */
	SetEvent (q->qNe);
	ReleaseMutex (q->qGuard);
 
	return 0;
}

DWORD QueueInitialize (QUEUE_OBJECT *q, DWORD msize, DWORD nmsgs)
{
	/* Inicjowanie kolejki (w tym muteksu i zdarze). */
    /* Alokowanie pamici na wszystkie komunikaty. */
	
	if ((q->msgArray = calloc (nmsgs, msize)) == NULL) return 1;
	q->qFirst = q->qLast = 0;
	q->qSize = nmsgs;

	q->qGuard = CreateMutex (NULL, FALSE, NULL);
	q->qNe = CreateEvent (NULL, FALSE, FALSE, NULL);  /* Zdarzenia z rcznym zerowaniem. */
	q->qNf = CreateEvent (NULL, FALSE, FALSE, NULL);
	return 0; /* Bez bdw. */
}

DWORD QueueDestroy (QUEUE_OBJECT *q)
{
	/* Zwalnianie wszystkie zasobw utworzonych za pomoc funkcji QueueInitialize. */
	WaitForSingleObject (q->qGuard, INFINITE);
	free (q->msgArray);
	q->msgArray = NULL;
	CloseHandle (q->qNe);
	CloseHandle (q->qNf);
	ReleaseMutex (q->qGuard);
	CloseHandle (q->qGuard);

	return 0;
}


DWORD QueueEmpty (QUEUE_OBJECT *q)
{
	return (q->qFirst == q->qLast);
}

DWORD QueueFull (QUEUE_OBJECT *q)
{
	return ((q->qFirst - q->qLast) == 1 ||
		    (q->qLast == q->qSize-1 && q->qFirst == 0));
}

DWORD QueueRemove (QUEUE_OBJECT *q, PVOID msg, DWORD msize)
{
	char *pm;

	if (QueueEmpty(q)) return 1; /* Bd - kolejka jest pusta. */
	pm = q->msgArray;
	/* Usuwanie najstarszego ("pierwszego") komunikatu. */
	memcpy (msg, pm + (q->qFirst * msize), msize);
	q->qFirst = ((q->qFirst + 1) % q->qSize);
	return 0; /* Bez bdw. */
}

DWORD QueueInsert (QUEUE_OBJECT *q, PVOID msg, DWORD msize)
{
	char *pm;

	if (QueueFull(q)) return 1; /* Bd - kolejka jest pena. */
	pm = q->msgArray;
	/* Dodawanie najnowszego ("ostatniego") komunikatu. */
	memcpy (pm + (q->qLast * msize), msg, msize);
	q->qLast = ((q->qLast + 1) % q->qSize);
	return 0;
}

