/* Rozdzia 10. QueueObjx.c		WERSJA Z BDAMI		*/
/* Funkcje kolejki										*/

#include "Everything.h"
#include "SynchObj.h"

/* Funkcje do zarzdzania skoczon kolejk. */

DWORD QueueGet (QUEUE_OBJECT *q, PVOID msg, DWORD msize, DWORD MaxWait)
{
	DWORD TotalWaitTime = 0;
	BOOL TimedOut = FALSE;

	WaitForSingleObject (q->qGuard, INFINITE);
	while (QueueEmpty (q) && !TimedOut) {
		ReleaseMutex (q->qGuard);
		WaitForSingleObject (q->qNe, INFINITE);
		if (MaxWait != INFINITE) {
			TotalWaitTime += CV_TIMEOUT;
			TimedOut = (TotalWaitTime > MaxWait);
		}
		WaitForSingleObject (q->qGuard, INFINITE);
	}
	/* Usuwanie komunikatu z kolejki. */
	if (!TimedOut) QueueRemove (q, msg, msize);
	/* Zgaszanie, e kolejka nie jest pena, poniewa usunito komunikat. */
	PulseEvent (q->qNe);
	ReleaseMutex (q->qGuard);

	return TimedOut ? WAIT_TIMEOUT : 0;
}

DWORD QueuePut (QUEUE_OBJECT *q, PVOID msg, DWORD msize, DWORD MaxWait)
{
	DWORD TotalWaitTime = 0;
	BOOL TimedOut = FALSE;

	while (QueueFull (q)) {
		WaitForSingleObject (q->qNf, CV_TIMEOUT);
		if (MaxWait != INFINITE) {
			TotalWaitTime += CV_TIMEOUT;
			TimedOut = (TotalWaitTime > MaxWait);
		}
		WaitForSingleObject (q->qGuard, INFINITE);
	}
	/* Umieszczanie komunikatu w kolejce. */
	if (!TimedOut) QueueInsert (q, msg, msize);	
	/* Zgaszanie, e kolejka jest niepusta (po wstawieniu komunikatu). */
	PulseEvent (q->qNf);
	ReleaseMutex (q->qGuard);
 
	return TimedOut ? WAIT_TIMEOUT : 0;
}

DWORD QueueInitialize (QUEUE_OBJECT *q, DWORD msize, DWORD nmsgs)
{
	/* Inicjowanie kolejki (w tym muteksu i zdarze). */
    /* Alokowanie pamici na wszystkie komunikaty. */
	
	q->qFirst = q->qLast = 0;
	q->qSize = nmsgs;
	q->QueueDestroyed = 0;

	q->qGuard = CreateMutex (NULL, FALSE, NULL);
	q->qNe = CreateEvent (NULL, FALSE, TRUE, NULL);
	q->qNf = CreateEvent (NULL, FALSE, TRUE, NULL);

	if ((q->msgArray = calloc (nmsgs, msize)) == NULL) return 1;
	return 0; /* Bez bdw. */
}

DWORD QueueDestroy (QUEUE_OBJECT *q)
{
	/* Zwalnianie wszystkie zasobw utworzonych za pomoc funkcji QueueInitialize. */
	q->QueueDestroyed = 1;
	free (q->msgArray);
	CloseHandle (q->qGuard);
	CloseHandle (q->qNe);
	CloseHandle (q->qNf);
	return 0;
}

DWORD QueueDestroyed (QUEUE_OBJECT *q)
{
	return (q->QueueDestroyed);
}

DWORD QueueEmpty (QUEUE_OBJECT *q)
{
	return (q->qFirst == q->qLast);
}

DWORD QueueFull (QUEUE_OBJECT *q)
{
	return ((q->qFirst - q->qLast) == 1 ||
		    (q->qLast == q->qSize-1 && q->qFirst == 0));
}


DWORD QueueRemove (QUEUE_OBJECT *q, PVOID msg, DWORD msize)
{
	char *pm;

	if (QueueEmpty(q)) return 1; /* Bd - kolejka jest pusta. */
	pm = q->msgArray;
	/* Usuwanie najstarszego ("pierwszego") komunikatu. */
	memcpy (msg, pm + (q->qFirst * msize), msize);
	q->qFirst = ((q->qFirst + 1) % q->qSize);
	return 0; /* no error */
}

DWORD QueueInsert (QUEUE_OBJECT *q, PVOID msg, DWORD msize)
{
	char *pm;

	if (QueueFull(q)) return 1; /* Bd - kolejka jest pena. */
	pm = q->msgArray;
	/* Dodawanie najnowszego ("ostatniego") komunikatu. */
	memcpy (pm + (q->qLast * msize), msg, msize);
	q->qLast = ((q->qLast + 1) % q->qSize);
	return 0;
}
