/* Rozdzia 10. QueueObjCancel.c - anulowanie z wykorzystaniem oczekiwania z obsug alertw. */
/* Funkcje kolejki. Model ze zgaszaniem.												*/

#include "Everything.h"
#include "SynchObj.h"

/* Funkcje do zarzdzania skoczon kolejk. */
static BOOL shutDownGet = FALSE;
static BOOL ShutDownPut = FALSE;

DWORD QueueGet (QUEUE_OBJECT *q, PVOID msg, DWORD mSize, DWORD maxWait)
{
	if (q->msgArray == NULL) return 1;  /* Kolejk usunito. */
	WaitForSingleObject (q->qGuard, INFINITE);

	while (!shutDownGet && QueueEmpty (q)) {
		if (SignalObjectAndWait (q->qGuard, q->qNe, INFINITE, TRUE) == WAIT_IO_COMPLETION
			&& shutDownGet) {
			continue;
		}
		WaitForSingleObject (q->qGuard, INFINITE);
	}
	/* Usuwanie komunikatu z kolejki. */
	if (!shutDownGet) {
		QueueRemove (q, msg, mSize);
		/* Zgaszanie, e kolejka nie jest pena, poniewa usunito komunikat. */
		SetEvent (q->qNf);
		ReleaseMutex (q->qGuard);
	}
	return shutDownGet ? WAIT_TIMEOUT : 0;
}

DWORD QueuePut (QUEUE_OBJECT *q, PVOID msg, DWORD mSize, DWORD maxWait)
{
	if (q->msgArray == NULL) return 1;  /* Kolejk usunito. */
	WaitForSingleObject (q->qGuard, INFINITE);

	while (!ShutDownPut && QueueFull (q)) {
		if (SignalObjectAndWait(q->qGuard, q->qNf, INFINITE, TRUE) == WAIT_IO_COMPLETION 
			&& ShutDownPut) {
			continue;
		}
		WaitForSingleObject (q->qGuard, INFINITE);
	}
	/* Umieszczanie komunikatu w kolejce. */
	if (!ShutDownPut) {
		QueueInsert (q, msg, mSize);	
		/* Zgaszanie, e kolejka jest niepusta (po wstawieniu komunikatu). */
		SetEvent (q->qNe);
		ReleaseMutex (q->qGuard);
	}
	return ShutDownPut ? WAIT_TIMEOUT : 0;
}

DWORD QueueInitialize (QUEUE_OBJECT *q, DWORD mSize, DWORD nMsgs)
{
	/* Inicjowanie kolejki (w tym muteksu i zdarze). */
    /* Alokowanie pamici na wszystkie komunikaty. */
	
	if ((q->msgArray = calloc (nMsgs, mSize)) == NULL) return 1;
	q->qFirst = q->qLast = 0;
	q->qSize = nMsgs;

	q->qGuard = CreateMutex (NULL, FALSE, NULL);
	/* Zdarzenia z automatycznym zerowaniem; to model ze zgaszaniem. */
	q->qNe = CreateEvent (NULL, FALSE, FALSE, NULL);
	q->qNf = CreateEvent (NULL, FALSE, FALSE, NULL);
	return 0; /* Bez bdw. */
}

DWORD QueueDestroy (QUEUE_OBJECT *q)
{
	/* Zwalnianie wszystkie zasobw utworzonych za pomoc funkcji QueueInitialize. */
	WaitForSingleObject (q->qGuard, INFINITE);
	free (q->msgArray);
	q->msgArray = NULL;
	CloseHandle (q->qNe);
	CloseHandle (q->qNf);
	ReleaseMutex (q->qGuard);
	CloseHandle (q->qGuard);

	return 0;
}


DWORD QueueEmpty (QUEUE_OBJECT *q)
{
	return (q->qFirst == q->qLast);
}

DWORD QueueFull (QUEUE_OBJECT *q)
{
	return ((q->qFirst - q->qLast) == 1 ||
		    (q->qLast == q->qSize-1 && q->qFirst == 0));
}

DWORD QueueRemove (QUEUE_OBJECT *q, PVOID msg, DWORD mSize)
{
	char *pm;

	if (QueueEmpty(q)) return 1; /* Bd - kolejka jest pusta. */
	pm = q->msgArray;
	/* Usuwanie najstarszego ("pierwszego") komunikatu. */
	memcpy (msg, pm + (q->qFirst * mSize), mSize);
	q->qFirst = ((q->qFirst + 1) % q->qSize);
	return 0; /* Bez bdw. */
}

DWORD QueueInsert (QUEUE_OBJECT *q, PVOID msg, DWORD mSize)
{
	char *pm;

	if (QueueFull(q)) return 1; /* Bd - kolejka jest pena. */
	pm = q->msgArray;
	/* Dodawanie najnowszego ("ostatniego") komunikatu. */
	memcpy (pm + (q->qLast * mSize), msg, mSize);
	q->qLast = ((q->qLast + 1) % q->qSize);
	return 0;
}

void CALLBACK QueueShutDown (ULONG_PTR pn)
{
	DWORD n = (DWORD)pn;   /* To rzutowanie jest bezpieczne, poniewa warto jest maa. */
	_tprintf (_T("W funkcji zwrotnej QueueDownShut. %d\n"), n);
	if (n%2 != 0) shutDownGet = TRUE;
	if ( (n/2) % 2 != 0) ShutDownPut = TRUE;
	/* Zwalnianie zasobw (w tym przykadzie ich nie ma). */
	return;
}
