/* Rozdzia 10. QueueObjCV */
/* Wersja ze zmiennymi warunkowymi wprowadzonymi w systemach NT6.         */
/* Funkcje kolejki												*/

#include "Everything.h"
#include "SynchObj.h"

/* Funkcje do zarzdzania skoczon kolejk. */

DWORD QueueGet (QUEUE_OBJECT *q, PVOID msg, DWORD msize, DWORD MaxWait)
{
	AcquireSRWLockExclusive (&q->qGuard);
	if (q->msgArray == NULL) return 1;  /* Kolejk usunito. */

	while (QueueEmpty (q)) {
		if (!SleepConditionVariableSRW (&q->qNe, &q->qGuard, INFINITE, 0))
			ReportError(_T("Blad funkcji QueueGet. SleepConditionVariableCS."), 1, TRUE);
	}

	/* Usuwanie komunikatu z kolejki. */
	QueueRemove (q, msg, msize);
	/* Zgaszanie, e kolejka nie jest pena, poniewa usunito komunikat. */
	WakeConditionVariable (&q->qNf);
	ReleaseSRWLockExclusive (&q->qGuard);
	return 0;
}

DWORD QueuePut (QUEUE_OBJECT *q, PVOID msg, DWORD msize, DWORD MaxWait)
{
	AcquireSRWLockExclusive (&q->qGuard);
	if (q->msgArray == NULL) return 1;  /* Kolejk usunito. */

	while (QueueFull (q)) {
		if (!SleepConditionVariableSRW(&q->qNf, &q->qGuard, INFINITE, 0))
			ReportError(_T("Blad funkcji QueuePut. SleepConditionVariableCS."), 1, TRUE);
	}
	/* Umieszczanie komunikatu w kolejce. */
	QueueInsert (q, msg, msize);	
	/* Zgaszanie, e kolejka jest niepusta (po wstawieniu komunikatu). */
	WakeConditionVariable (&q->qNe);
	ReleaseSRWLockExclusive (&q->qGuard);
	return 0;
}

DWORD QueueInitialize (QUEUE_OBJECT *q, DWORD msize, DWORD nmsgs)
{
	/* Inicjowanie kolejki (w tym muteksu i zdarze). */
    /* Alokowanie pamici na wszystkie komunikaty. */
	
	if ((q->msgArray = calloc (nmsgs, msize)) == NULL) return 1;
	q->qFirst = q->qLast = 0;
	q->qSize = nmsgs;

	InitializeSRWLock(&q->qGuard);
	InitializeConditionVariable(&q->qNe);
	InitializeConditionVariable(&q->qNf);
	return 0; /* Bez bdw. */
}

DWORD QueueDestroy (QUEUE_OBJECT *q)
{
	/* Zwalnianie wszystkie zasobw utworzonych za pomoc funkcji QueueInitialize. */
	AcquireSRWLockExclusive (&q->qGuard);
	free (q->msgArray);
	q->msgArray = NULL;
	ReleaseSRWLockExclusive (&(q->qGuard));

	return 0;
}


DWORD QueueEmpty (QUEUE_OBJECT *q)
{
	return (q->qFirst == q->qLast);
}

DWORD QueueFull (QUEUE_OBJECT *q)
{
	return ((q->qFirst - q->qLast) == 1 ||
		    (q->qLast == q->qSize-1 && q->qFirst == 0));
}

DWORD QueueRemove (QUEUE_OBJECT *q, PVOID msg, DWORD msize)
{
	char *pm;

	if (QueueEmpty(q)) return 1; /* Bd - kolejka jest pusta. */
	pm = q->msgArray;
	/* Usuwanie najstarszego ("pierwszego") komunikatu. */
	memcpy (msg, pm + (q->qFirst * msize), msize);
	q->qFirst = ((q->qFirst + 1) % q->qSize);
	return 0; /* Bez bdw. */
}

DWORD QueueInsert (QUEUE_OBJECT *q, PVOID msg, DWORD msize)
{
	char *pm;

	if (QueueFull(q)) return 1; /* Bd - kolejka jest pena. */
	pm = q->msgArray;
	/* Dodawanie najnowszego ("ostatniego") komunikatu. */
	memcpy (pm + (q->qLast * msize), msg, msize);
	q->qLast = ((q->qLast + 1) % q->qSize);
	return 0;
}

