/* Rozdzia 10. QueueObjCS.c. Wersja z obiektem CRITICAL_SECTION.			*/
/* Funkcje kolejki.												*/

#include "Everything.h"
#include "SynchObjCS.h"

/* Funkcje do zarzdzania skoczon kolejk. */

DWORD QueueGet (QUEUE_OBJECT *q, PVOID msg, DWORD msize, DWORD MaxWait)
{
	DWORD TotalWaitTime = 0;
	BOOL TimedOut = FALSE;

	EnterCriticalSection (&q->qGuard);
	if (q->msgArray == NULL) return 1;  /* Kolejk usunito. */

	while (QueueEmpty (q) && !TimedOut) {
		LeaveCriticalSection (&q->qGuard);
		WaitForSingleObject (q->qNe, CV_TIMEOUT);
		if (MaxWait != INFINITE) {
			TotalWaitTime += CV_TIMEOUT;
			TimedOut = (TotalWaitTime > MaxWait);
		}
		EnterCriticalSection (&q->qGuard);
	}
	/* Usuwanie komunikatu z kolejki. */
	if (!TimedOut) QueueRemove (q, msg, msize);
	/* Zgaszanie, e kolejka nie jest pena, poniewa usunito komunikat. */
	PulseEvent (q->qNf);
	LeaveCriticalSection (&q->qGuard);

	return TimedOut ? WAIT_TIMEOUT : 0;
}

DWORD QueuePut (QUEUE_OBJECT *q, PVOID msg, DWORD msize, DWORD MaxWait)
{
	DWORD TotalWaitTime = 0;
	BOOL TimedOut = FALSE;

//	WaitForSingleObject (q->qGuard, INFINITE);
	EnterCriticalSection (&q->qGuard);
	if (q->msgArray == NULL) return 1;  /* Kolejk usunito. */
	while (QueueFull (q) && !TimedOut) {
//		ReleaseMutex (q->qGuard);
		LeaveCriticalSection (&q->qGuard);
		WaitForSingleObject (q->qNf, CV_TIMEOUT);
		if (MaxWait != INFINITE) {
			TotalWaitTime += CV_TIMEOUT;
			TimedOut = (TotalWaitTime > MaxWait);
		}
//		WaitForSingleObject (q->qGuard, INFINITE);
		EnterCriticalSection (&q->qGuard);
	}
	/* Umieszczanie komunikatu w kolejce. */
	if (!TimedOut) QueueInsert (q, msg, msize);	
	/* Zgaszanie, e kolejka jest niepusta (po wstawieniu komunikatu). */
	PulseEvent (q->qNe);
//	ReleaseMutex (q->qGuard);
	LeaveCriticalSection (&q->qGuard);
 
	return TimedOut ? WAIT_TIMEOUT : 0;
}

DWORD QueueInitialize (QUEUE_OBJECT *q, DWORD msize, DWORD nmsgs)
{
	/* Inicjowanie kolejki (w tym muteksu i zdarze). */
    /* Alokowanie pamici na wszystkie komunikaty. */
	
	if ((q->msgArray = calloc (nmsgs, msize)) == NULL) return 1;
	q->qFirst = q->qLast = 0;
	q->qSize = nmsgs;

	InitializeCriticalSection (&q->qGuard);
//	q->qGuard = CreateMutex (NULL, FALSE, NULL);
	q->qNe = CreateEvent (NULL, TRUE, FALSE, NULL);
	q->qNf = CreateEvent (NULL, TRUE, FALSE, NULL);
	return 0; /* Bez bdw. */
}

DWORD QueueDestroy (QUEUE_OBJECT *q)
{
	/* Zwalnianie wszystkie zasobw utworzonych za pomoc funkcji QueueInitialize. */
//	WaitForSingleObject (q->qGuard, INFINITE);
	EnterCriticalSection (&q->qGuard);
	free (q->msgArray);
	q->msgArray = NULL;
	CloseHandle (q->qNe);
	CloseHandle (q->qNf);
//	ReleaseMutex (q->qGuard);
	LeaveCriticalSection (&q->qGuard);
//	CloseHandle (q->qGuard);
	DeleteCriticalSection (&q->qGuard);

	return 0;
}

DWORD QueueEmpty (QUEUE_OBJECT *q)
{
	return (q->qFirst == q->qLast);
}

DWORD QueueFull (QUEUE_OBJECT *q)
{
	return ((q->qFirst - q->qLast) == 1 ||
		    (q->qLast == q->qSize-1 && q->qFirst == 0));
}


DWORD QueueRemove (QUEUE_OBJECT *q, PVOID msg, DWORD msize)
{
	char *pm;

	if (QueueEmpty(q)) return 1; /* Bd - kolejka jest pusta. */
	pm = q->msgArray;
	/* Usuwanie najstarszego ("pierwszego") komunikatu. */
	memcpy (msg, pm + (q->qFirst * msize), msize);
	q->qFirst = ((q->qFirst + 1) % q->qSize);
	return 0; /* Bez bdw. */
}

DWORD QueueInsert (QUEUE_OBJECT *q, PVOID msg, DWORD msize)
{
	char *pm;

	if (QueueFull(q)) return 1; /* Bd - kolejka jest pena. */
	pm = q->msgArray;
	/* Dodawanie najnowszego ("ostatniego") komunikatu. */
	memcpy (pm + (q->qLast * msize), msg, msize);
	q->qLast = ((q->qLast + 1) % q->qSize);
	return 0;
}
