/* Rozdzia 10. QueueObj.c. Wersja z funkcj SingalObjectAndWait.		*/
/* Funkcje kolejki												*/
#include "Everything.h"
#include "SynchObj.h"
#include "messages.h"

/* Funkcje do zarzdzania skoczon kolejk. */
/* Zwr uwag na zmienne maxWait i TimedOut.
 * Nie wykorzystano ich w tym rozwizaniu; w innych wersjach mona
 * zastosowa limity czasu (na przykad w rozwizaniu z obiektem
 * CRITICAL_SECTION).
 */

DWORD QueueGet (QUEUE_OBJECT *q, PVOID msg, DWORD mSize, DWORD maxWait)
{
	WaitForSingleObject (q->qGuard, INFINITE);
	if (q->msgArray == NULL) return 1;  /* Kolejk usunito. */
	while (QueueEmpty (q)) {
		SignalObjectAndWait (q->qGuard, q->qNe, INFINITE, FALSE);
		WaitForSingleObject (q->qGuard, INFINITE);
	}
	/* Usuwanie komunikatu z kolejki. */
	QueueRemove (q, msg, mSize);
	/* Zgaszanie, e kolejka nie jest pena, poniewa usunito komunikat. */
	PulseEvent (q->qNf);
	ReleaseMutex (q->qGuard);

	return 0;
}

DWORD QueuePut (QUEUE_OBJECT *q, PVOID msg, DWORD mSize, DWORD maxWait)
{
	WaitForSingleObject (q->qGuard, INFINITE);
	if (q->msgArray == NULL) return 1;  /* Kolejk usunito. */
	while (QueueFull (q)) {
		SignalObjectAndWait (q->qGuard, q->qNf, INFINITE, FALSE);
		WaitForSingleObject (q->qGuard, INFINITE);
	}
	/* Umieszczanie komunikatu w kolejce. */
	QueueInsert (q, msg, mSize);
	/* Zgaszanie, e kolejka jest niepusta (po wstawieniu komunikatu). */
	PulseEvent (q->qNe);
	ReleaseMutex (q->qGuard);
 
	return 0;
}

DWORD QueueInitialize (QUEUE_OBJECT *q, DWORD mSize, DWORD nMsgs)
{
	/* Inicjowanie kolejki (w tym muteksu i zdarze). */
    /* Alokowanie pamici na wszystkie komunikaty. */
	
	if ((q->msgArray = calloc (nMsgs, mSize)) == NULL) return 1;
	q->qFirst = q->qLast = 0;
	q->qSize = nMsgs;

	q->qGuard = CreateMutex (NULL, FALSE, NULL);
	q->qNe = CreateEvent (NULL, TRUE, FALSE, NULL);
	q->qNf = CreateEvent (NULL, TRUE, FALSE, NULL);
	return 0; /* No error */
}

DWORD QueueDestroy (QUEUE_OBJECT *q)
{
	/* Zwalnianie wszystkie zasobw utworzonych za pomoc funkcji QueueInitialize. */
	WaitForSingleObject (q->qGuard, INFINITE);
	free (q->msgArray);
	q->msgArray = NULL;
	CloseHandle (q->qNe);
	CloseHandle (q->qNf);
	ReleaseMutex (q->qGuard);
	CloseHandle (q->qGuard);

	return 0;
}

DWORD QueueEmpty (QUEUE_OBJECT *q)
{
	return (q->qFirst == q->qLast);
}

DWORD QueueFull (QUEUE_OBJECT *q)
{
	return ((q->qFirst - q->qLast) == 1 ||
		    (q->qLast == q->qSize-1 && q->qFirst == 0));
}


DWORD QueueRemove (QUEUE_OBJECT *q, PVOID msg, DWORD mSize)
{
	char *pm;

	if (QueueEmpty(q)) return 1; /* Bd - kolejka jest pusta. */
	pm = q->msgArray;
	/* Usuwanie najstarszego ("pierwszego") komunikatu. */
	memcpy (msg, pm + (q->qFirst * mSize), mSize);
	q->qFirst = ((q->qFirst + 1) % q->qSize);
	return 0; /* no error */
}

DWORD QueueInsert (QUEUE_OBJECT *q, PVOID msg, DWORD mSize)
{
	char *pm;

	if (QueueFull(q)) return 1; /* Bd - kolejka jest pena. */
	pm = q->msgArray;
	/* Dodawanie najnowszego ("ostatniego") komunikatu. */
	memcpy (pm + (q->qLast * mSize), msg, mSize);
	q->qLast = ((q->qLast + 1) % q->qSize);
	return 0;
}
