/* Rozdzia 10. messages.c.										*/
/* Funkcje kolejki.												*/

#include "Everything.h"
#include "messages.h"
#include <time.h>

DWORD ComputeChecksum (PVOID msg, DWORD length)
{
	/* Obliczanie sumy kontrolnej (xor) dla caego komunikatu z "length" liczbami. */
	DWORD i, cs = 0, *pInt;

	pInt = (DWORD *) msg;
	for (i = 0; i < length; i++) {
		cs = (cs ^ *pInt);
		pInt++;
	}
	return cs;		
}

VOID MessageFill (MSG_BLOCK *mBlock, DWORD src, DWORD dest, DWORD sequence)
{
	/* Zapenianie bufora i doczenia sumy kontrolnej oraz znacznika czasu.	*/
	/* Ta funkcja jest wywoywana w wtku producenta, kiedy zajmuje	on */
	/* muteks bloku komunikatu.					*/

	DWORD i;
	
	mBlock->checksum = 0;	
	for (i = 0; i < DATA_SIZE; i++) {
		mBlock->data[i] = rand();
	}
	mBlock->source = src;
	mBlock->destination = dest;
	mBlock->sequence = sequence;
	mBlock->timestamp = time(NULL);
	mBlock->fReady = 0;
	mBlock->fStop = (sequence < 0);
	mBlock->checksum = ComputeChecksum (mBlock, sizeof(MSG_BLOCK)/sizeof(DWORD));
	return;
}

void MessageDisplay (MSG_BLOCK *mBlock)
{
	/* Wywietlanie bufora i znacznika czasu, sprawdzanie sumy kontrolnej. */
	/* Ta funkcja jest wywoywana w wtku producenta, kiedy zajmuje	on */
	/* muteks bloku komunikatu.				*/
	DWORD tcheck = 0;
	
	tcheck = ComputeChecksum (mBlock, sizeof(MSG_BLOCK)/sizeof(DWORD));
	_tprintf (_T("\nKomunikat numer %d wygenerowano: %s"), 
		mBlock->sequence, ctime (&(mBlock->timestamp)));
	_tprintf (_T("Element zrodlowy i docelowy: %d %d\n"), 
		mBlock->source, mBlock->destination);
	_tprintf (_T("Pierwszy i ostatni wpis: %x %x\n"),
		mBlock->data[0], mBlock->data[DATA_SIZE-1]);
	if (tcheck == 0 /*mBlock->checksum ma warto 0 przy pierwszym obliczaniu sumy kontrolnej. */)
		_tprintf (_T("POPRAWNE  sprawdzono wartosc mChecksum.\n"));
	else
		_tprintf (_T("BLAD w wartosci mChecksum. Komunikat jest uszkodzony.\n"));
		
	return;

}
