/* Rozdzia 9. wcMT_VTP.c.									*/
/*															*/
/* wcMT_VTP plik1 plik2 ... plikN							*/
/* OSTRZEENIE: kod NIE obsuguje kodowania UNICODE. 		*/
/* Rwnolege zliczanie sw - wersjaz pul wtkw z systemw NT6 (Vista).	*/
/*															*/
/* Niezalene przetwarzanie wielu plikw					*/
/* w modelu z wtkiem gwnym i wtkami roboczymi.			*/
/* Okrela czn liczb znakw, sw i wierszy   			*/
/* w plikach okrelonych w wierszu polece, podobnie		*/
/* jak robi to UNIX-owe narzdzie wc.						*/
/* Kady plik jest przetwarzany przez odrbny wtek z puli.*/
/* Wtek gwny zbiera odrbne wyniki 						*/
/* wyniki i czy je w ostateczne rezultaty.				*/
/* Podobnie jak w innych implementacja programu wc uywane s znaki 8-bitowe. */

#include "Everything.h"
#define CACHE_LINE_SIZE 64

__declspec(align(CACHE_LINE_SIZE))
typedef struct { /* Struktura argumentu wtku.	*/
	char * filename;
	volatile unsigned int kchar;
	volatile unsigned int kword;
	volatile unsigned int kline;
	volatile unsigned int wcerror;
} WORK_OBJECT_ARG;

VOID CALLBACK wcfunc (PTP_CALLBACK_INSTANCE, PVOID, PTP_WORK);
int WorkerId = 0;	// Niepowtarzalny identyfikator obliczany przez kady egzemplarz funkcji zwrotnej.

int main (int argc, char * argv[])
{
	DWORD nchar = 0, nword = 0, nline = 0;
    PTP_WORK *pWorkObjects;
    WORK_OBJECT_ARG ** pWorkObjArgsArray, *pObjectArg;
	TP_CALLBACK_ENVIRON cbe;  // rodowisko funkcji zwrotnej.
	int nThread, iThrd;
	
    if (!WindowsVersionOK (6, 0)) 
        ReportError ("Ten program wymaga systemu Windows NT 6.0 lub nowszego.", 1, TRUE);

	if (argc < 2) {
		printf ("Stosowanie: wcMT_vtp nazwapliku ... nazwapliku\n");
		return 1;
	}

	/* Tworzenie wtku roboczego dla kadego podanego pliku. */
	nThread = (DWORD)argc - 1;
    pWorkObjects = malloc (nThread * sizeof(PTP_WORK));
	if (pWorkObjects != NULL)
		pWorkObjArgsArray = malloc (nThread * sizeof(WORK_OBJECT_ARG *));
	if (pWorkObjects == NULL || pWorkObjArgsArray == NULL)
        ReportError ("Nie mozna zaalokowa pamieci roboczej dla elementu roboczego lub tablicy argumentw.", 2, TRUE);

	InitializeThreadpoolEnvironment (&cbe);

	/* Tworzenie obiektu roboczego dla kadego pliku z wiersza polece.
	   Najpierw w argumentach naley umieci nazwy plikw.	*/
	for (iThrd = 0; iThrd < nThread; iThrd++) {
		pObjectArg = (pWorkObjArgsArray[iThrd] = _aligned_malloc (sizeof(WORK_OBJECT_ARG), CACHE_LINE_SIZE));
		if (NULL == pObjectArg)
			ReportError ("Nie mozna zaalokowac pamieci dla struktury argumentu watku.", 3, TRUE);
		pObjectArg->filename = argv[iThrd+1];
		pObjectArg->kword = pObjectArg->kchar = pObjectArg->kline = 0;
		pWorkObjects[iThrd] = CreateThreadpoolWork (wcfunc, pObjectArg, &cbe);
        if (pWorkObjects[iThrd] == NULL) 
            ReportError ("Nie mozna utworzyc watku konsumenta.", 4, TRUE);
		SubmitThreadpoolWork (pWorkObjects[iThrd]);
	}
	
	/* Wszystkie obiekty robocze s przesane. Oczekiwanie na zakoczenie pracy 	*/
	/* i czenie wynikw.			*/
	for (iThrd = 0; iThrd < nThread; iThrd++) {
		/* Oczekiwanie na zakoczenie obsugi obiektw roboczych. */
		WaitForThreadpoolWorkCallbacks (pWorkObjects[iThrd], FALSE);
		CloseThreadpoolWork(pWorkObjects[iThrd]);
	}
    free (pWorkObjects);
	
	/* czenie wynikw.							*/
	for (iThrd = 0; iThrd < argc - 1; iThrd++) {
		pObjectArg = pWorkObjArgsArray[iThrd]; 
		nchar += pObjectArg->kchar;
		nword += pObjectArg->kword;
		nline += pObjectArg->kline;
		printf ("%10d %9d %9d %s\n", pObjectArg->kline,
			pObjectArg->kword, pObjectArg->kchar,
			pObjectArg->filename);
	}
	free (pWorkObjArgsArray);
	printf ("%10d %9d %9d \n", nline, nword, nchar);
	return 0;
}

/* Funkcja narzdziowa. Dziaa szybciej od wersji z biblioteki jzyka C. */
int is_a_space(int ch) {
    if(ch == ' ' || ch == '\t' || ch == '\n' ||
        ch == '\f' || ch == '\r') {
        return 1;
    } else {
        return 0;
    }
}

/* Operacje na odwzorowanych plikach czsto dziaaj 
   szybciej ni tradycyjne operacje wejcia-wyjcia.
   Struktura obejmuje "uchwyt" na przedstawione dalej
   funkcje narzdziowe.   
 */
typedef struct {
    // Struktura dla odwzorowanego pliku.
    void* pInFile;
    HANDLE hInMap;
    HANDLE hIn;
} MAPPED_FILE_HANDLE;

/* Funkcje narzdziowe zwizane z odwzorowaniami. */
/* Zadanie: rozwi kod, aby wykorzysta systemy 64-bitowe. Ta wersja dziaa
   tylko dla maych plikw.
 */

void* map_file(LPCSTR filename, unsigned int* pFsLow, int* error, MAPPED_FILE_HANDLE* pmFH)
{
	HANDLE hIn, hInMap;
	LARGE_INTEGER fileSize;
	char* pInFile;

    *error = 0;
    hIn = CreateFile(filename, GENERIC_READ, 0, NULL, OPEN_EXISTING,
                     FILE_ATTRIBUTE_NORMAL, NULL);
    if (hIn == INVALID_HANDLE_VALUE) {
        *error = 2;
        return NULL;
    }

    // Tworzenie obiektu odwzorowania dla pliku wejciowego. Wykorzystanie rozmiaru pliku. 
    hInMap = CreateFileMapping(hIn, NULL, PAGE_READONLY, 0, 0, NULL);
    if (hInMap == INVALID_HANDLE_VALUE) {
        CloseHandle(hIn);
        *error = 3;
        return NULL;
    }

    // Odwzorowywanie pliku wejciowego. 
    pInFile = (char*) MapViewOfFile(hInMap, FILE_MAP_READ, 0, 0, 0);
    if (pInFile == NULL) {
        CloseHandle(hInMap);
        CloseHandle(hIn);
        *error = 4;
        return NULL;
    }

    /* Pobieranie rozmiaru pliku wejciowego. Poniewa odwzorowywanie si powiodo,  
	   rozmiar pliku wynosi < 4 GB. Zadanie dla Czytelnika: usu to ograniczenie. */
    if (!GetFileSizeEx(hIn, &fileSize) || fileSize.HighPart != 0) {
        UnmapViewOfFile(pInFile);
        CloseHandle(hInMap);
        CloseHandle(hIn);
        *error = 5;
        return NULL;
    }
	*pFsLow = fileSize.LowPart;

    pmFH->pInFile = pInFile;
    pmFH->hInMap = hInMap;
    pmFH->hIn = hIn;

    return pInFile;
}

void UnMapFile(MAPPED_FILE_HANDLE* pmFH)
{
    UnmapViewOfFile(pmFH->pInFile);
    CloseHandle(pmFH->hInMap);
    CloseHandle(pmFH->hIn);
}

/* Funkcja zwrotna wtku roboczego do przetwarzania jednego pliku.	*/
VOID CALLBACK wcfunc (PTP_CALLBACK_INSTANCE Instance, PVOID Context, PTP_WORK Work)
/* Zlicza znaki, sowa i wiersze w pliku	*/
/* targ->filename.					*/
/* UWAGA: to prosta wersja; wyniki mog by inne ni z narzdzia wc.		*/
{
	WORK_OBJECT_ARG * threadArgs;
	MAPPED_FILE_HANDLE fhandle;
	int iThrd;

	unsigned int ch, c, nl, nw, nc;
    int isspace_c;       // Obecny znak.
    int isspace_ch = 1;  // Poprzedni znak. Zakadamy, e to odstp (pozwala to uwzgldni pierwsze sowo).

    int error;
    unsigned int fsize;
    char *fin, *fend;
	
    iThrd = InterlockedIncrement (&WorkerId) - 1;
	threadArgs = (WORK_OBJECT_ARG *)Context;
	threadArgs->wcerror = 1; /* Ustawianie bdu. */
	
	fin = (char*) map_file(threadArgs->filename, &fsize, &error, &fhandle);
    if (NULL == fin) {
        return;
    }

    fend = fin + fsize;

	ch = nw = nc = nl = 0;
    while (fin < fend) {
        c = *fin++;
        isspace_c = is_a_space(c);
        if (!isspace_c && isspace_ch) {
            nw++;
        }
        isspace_ch = isspace_c;
        if (c == '\n') {
            nl++;
            isspace_ch = 1; // Rozpoczcie szukania nowego sowa.
        }
    }

    UnMapFile(&fhandle);
	threadArgs->kchar = fsize;
	threadArgs->kword = nw;
	threadArgs->kline = nl;
	threadArgs->wcerror = 0;
	return;
}
