/* Rozdzia 9. statsSRW_VTP.c.                             */
/* Prosty system z wtkiem gwnym i wtkami roboczymi,    */
/* gdzie kady wtek roboczy przekazuje dane do            */
/* wywietlenia do wtku gwnego.                         */

#include "Everything.h"
#define DELAY_COUNT 20
#define CACHE_LINE_SIZE 64

/* Stosowanie: statsSRW_VTP liczbaWtkw liczbaZada [opnienie [ledzenie]]  */
/* Program uruchamia liczbaWtkw wtkw roboczych, a kady z nich             */
/* wykonuje "liczbZada" jednostek roboczych. Kady wtek informuje o postpie */
/* na swojej niewspuytkowanej pozycji w tablicy z wykonanymi zadaniami.     */

VOID CALLBACK Worker (PTP_CALLBACK_INSTANCE, PVOID, PTP_WORK);
int workerDelay = DELAY_COUNT;
BOOL traceFlag = FALSE;

__declspec(align(CACHE_LINE_SIZE))
typedef struct _THARG {
	SRWLOCK slimRWL;
	int objectNumber;
    unsigned int tasksToComplete;
    unsigned int tasksComplete;
} THARG;
    
int _tmain (int argc, LPTSTR argv[])
{
    INT nThread, iThread;
	HANDLE *pWorkObjects;
	SRWLOCK srwl;
    unsigned int tasksPerThread, totalTasksComplete;
    THARG ** pWorkObjArgsArray, *pThreadArg;
	TP_CALLBACK_ENVIRON cbe;  // rodowisko funkcji zwrotnej.
    
    if (argc < 3) {
        _tprintf (_T("Stosowanie: statsSRW_VTP liczbaWatkow liczbaZadan [sledzenie]\n"));
        return 1;
    }
	_tprintf (_T("statsSRW_VTP %s %s %s\n"), argv[1], argv[2], argc>=4 ? argv[3] : "");
       
    nThread = _ttoi(argv[1]);
    tasksPerThread = _ttoi(argv[2]);
	if (argc >= 4) workerDelay = _ttoi(argv[3]);
    traceFlag = (argc >= 5);

	/* Inicjowanie blokady SRW. */
	InitializeSRWLock (&srwl);

    pWorkObjects = malloc (nThread * sizeof(PTP_WORK));
	if (pWorkObjects != NULL)
		pWorkObjArgsArray = malloc (nThread * sizeof(THARG *));

	if (pWorkObjects == NULL || pWorkObjArgsArray == NULL)
        ReportError (_T("Nie mozna zaalokowac pamieci roboczej dla obiektow roboczych lub tablicy argumentow."), 2, TRUE);
	InitializeThreadpoolEnvironment (&cbe);
    
    for (iThread = 0; iThread < nThread; iThread++) {
        /* Zapenianie argumentu wtku. */
		pThreadArg = (pWorkObjArgsArray[iThread] = _aligned_malloc (sizeof(THARG), CACHE_LINE_SIZE));
		if (NULL == pThreadArg)
			ReportError (_T("Nie mozna zaalokowac pamieci dla struktury argumentu."), 3, TRUE);
        pThreadArg->objectNumber = iThread;
        pThreadArg->tasksToComplete = tasksPerThread;
        pThreadArg->tasksComplete = 0;
        pThreadArg->slimRWL = srwl;
		pWorkObjects[iThread] = CreateThreadpoolWork (Worker, pThreadArg, &cbe);
        if (pWorkObjects[iThread] == NULL) 
            ReportError (_T("Nie mozna utworzyc watku konsumenta."), 4, TRUE);
		SubmitThreadpoolWork (pWorkObjects[iThread]);
    }

	/* Oczekiwanie na zakoczenie pracy przez wtki. */
	for (iThread = 0; iThread < nThread; iThread++) {		
		WaitForThreadpoolWorkCallbacks (pWorkObjects[iThread], FALSE);
		CloseThreadpoolWork(pWorkObjects[iThread]);
	}

    free (pWorkObjects);
    _tprintf (_T("Watki robocze zakonczyly dzialanie.\n"));
    totalTasksComplete = 0;
    for (iThread = 0; iThread < nThread; iThread++) {
		pThreadArg = pWorkObjArgsArray[iThread];
        if (traceFlag) _tprintf (_T("Zadania ukonczone przez watek %5d: %6d\n"), iThread, pThreadArg->tasksComplete);
        totalTasksComplete += pThreadArg->tasksComplete;
		_aligned_free (pThreadArg);
    }
	free (pWorkObjArgsArray);

    if (traceFlag) _tprintf (_T("Laczna liczba wykonanych zadan: %d.\n"), totalTasksComplete);
    
	return 0;
}

VOID CALLBACK Worker (PTP_CALLBACK_INSTANCE Instance, PVOID Context, PTP_WORK Work)
{
    THARG * threadArgs;

    threadArgs = (THARG *)Context;
	if (traceFlag)
		_tprintf (_T("Watek roboczy: %d. Identyfikatora watku: %d.\n"), threadArgs->objectNumber, GetCurrentThreadId());

    while (threadArgs->tasksComplete < threadArgs->tasksToComplete) {
        delay_cpu (workerDelay);
		AcquireSRWLockExclusive (&(threadArgs->slimRWL));
		(threadArgs->tasksComplete)++;
		ReleaseSRWLockExclusive (&(threadArgs->slimRWL));
    }
        
    return;        
}

