/* Rozdzia 9. statsMX.c.                                  */
/* Prosty system z wtkiem gwnym i wtkami roboczymi,    */
/* gdzie kady wtek roboczy przekazuje dane do            */
/* wywietlenia do wtku gwnego.                         */
/* WERSJA Z MUTEKSEM                                       */

#include "Everything.h"
#define DELAY_COUNT 20
#define CACHE_LINE_SIZE 64

/* Stosowanie: statsMX liczbaWtkw liczbaZada [opnienie [ledzenie]]       */
/* Program uruchamia liczbaWtkw wtkw roboczych, a kady z nich             */
/* wykonuje "liczbZada" jednostek roboczych. Kady wtek informuje o postpie */
/* na swojej niewspuytkowanej pozycji w tablicy z wykonanymi zadaniami.     */

DWORD WINAPI Worker (void *);
int workerDelay = DELAY_COUNT;

__declspec(align(CACHE_LINE_SIZE))
typedef struct _THARG {
	HANDLE hMutex;
	int threadNumber;
    unsigned int tasksToComplete;
    unsigned int tasksComplete;
} THARG;
    
int _tmain (int argc, LPTSTR argv[])
{
    INT nThread, iThread;
    HANDLE *hWorkers, hMutex;
    unsigned int tasksPerThread, totalTasksComplete;
    THARG ** pThreadArgsArray, *pThreadArg;
    BOOL traceFlag = FALSE;
    
    if (argc < 3) {
        _tprintf (_T("Stosowanie: statsMX liczbaWatkow liczbaZadan [sledzenie]\n"));
        return 1;
    }
	_tprintf (_T("statsMX %s %s %s\n"), argv[1], argv[2], argc>=4 ? argv[3] : "");
       
    nThread = _ttoi(argv[1]);
    tasksPerThread = _ttoi(argv[2]);
	if (argc >= 4) workerDelay = _ttoi(argv[3]);
    traceFlag = (argc >= 5);

	/* Tworzenie muteksu. */
    if ((hMutex = CreateMutex (NULL, FALSE, NULL)) == NULL)
		ReportError (_T("Nie mozna utworzyc muteksu."), 1, TRUE);

    hWorkers = malloc (nThread * sizeof(HANDLE));
	pThreadArgsArray = malloc (nThread * sizeof(THARG *));

	if (hWorkers == NULL || pThreadArgsArray == NULL)
        ReportError (_T("Nie mozna zaalokowac pamieci roboczej dla uchwytow lub tablicy argumentow."), 2, TRUE);
    
    for (iThread = 0; iThread < nThread; iThread++) {
        /* Zapenianie argumentu wtku. */
		pThreadArg = (pThreadArgsArray[iThread] = _aligned_malloc (sizeof(THARG), CACHE_LINE_SIZE));
		if (NULL == pThreadArg)
			ReportError (_T("Nie mozna zaalokowac pamieci dla struktury argumentu watku."), 3, TRUE);
        pThreadArg->threadNumber = iThread;
        pThreadArg->tasksToComplete = tasksPerThread;
        pThreadArg->tasksComplete = 0;
        pThreadArg->hMutex = hMutex;
		hWorkers[iThread] = (HANDLE)_beginthreadex (NULL, 0, Worker, pThreadArg, 0, NULL);
        if (hWorkers[iThread] == NULL) 
            ReportError (_T("Nie mozna utworzyc watku konsumenta."), 4, TRUE);
    }

	/* Oczekiwanie na zakoczenie pracy przez wtki. */
	for (iThread = 0; iThread < nThread; iThread++)
		WaitForSingleObject (hWorkers[iThread], INFINITE);
	CloseHandle (hMutex);
	free (hWorkers);
    _tprintf (_T("Watki robocze zakonczyly dzialanie.\n"));
    
	totalTasksComplete = 0;
    for (iThread = 0; iThread < nThread; iThread++) {
		pThreadArg = pThreadArgsArray[iThread];
        if (traceFlag) _tprintf (_T("Zadania ukonczone przez watek %5d: %6d\n"), iThread, pThreadArg->tasksComplete);
        totalTasksComplete += pThreadArg->tasksComplete;
		_aligned_free (pThreadArg);
    }
	free (pThreadArgsArray);
    if (traceFlag) _tprintf (_T("Laczna liczba wykonanych zadan: %d.\n"), totalTasksComplete);
    
	return 0;
}

DWORD WINAPI Worker (void *arg)
{
    THARG * threadArgs;
    int iThread;

    threadArgs = (THARG *)arg;    
    iThread = threadArgs->threadNumber;

    while (threadArgs->tasksComplete < threadArgs->tasksToComplete) {
        delay_cpu (workerDelay);
        WaitForSingleObject (threadArgs->hMutex, INFINITE);
        (threadArgs->tasksComplete)++;
        ReleaseMutex (threadArgs->hMutex); 
    }
        
    return 0;        
}

