/********************************************************************/
/*   Rozdzia 9.
	 Wzbogacony o liczb powtrze ptli dla obiektw CS.
     Program do testowania rnych technik synchronizacji z systemu Windows w celu
	 sprawdzenia wpywu wzajemnego wykluczania. W prosty sposb porwnywane s 
	 obiekty CS i muteksy ze wzgldu na wydajno.
	 Prawie wszystkie czynniki, ktre wpywaj na wydajno programw wielowtkowych,
	 s przedstawiane tu w uproszczony sposb, co pozwala oceni atrakcyjno
	 rnych projektw.
		Liczba wtkw
		Stosowanie muteksw lub obiektw CS
		Zajmowanie zasobw
		Obcienie obliczeniami i operacjami wejcia-wyjcia
		Kontrolowanie liczby aktywnych wtkw
	 
	 Stosowanie:
	 TimeMutualExclusion co [glebokosc [opoznienie [liczWatkow [punktyUspienia [liczAktWatkow [liczPowt]]]]]]
	 
	 co:	    1 - Testowanie obiektw CS
				2 - Testowanie zagniedonych obiektw CS
				3 - Testowanie muteksw				
				TESTOWANE: pozwala okreli wzgldn wydajno obiektw CS i muteksw,
						(zwaszcza czasu spdzonego w jdrze).
						Testowanie dwch odrbnych zagniedonych obiektw CS
						pozwala okreli, czy wystpuje liniowy (dwukrotno)
						czy nieliniowy wpyw na wydajno.
				
	glebokosc:	1 (domylnie) lub wicej oznacza liczb rekurencyjnych wej,
						po ktrych nastpuje tyle samo wyj.
						0 pokazuje dziaanie programu bez synchronizacji.						
				TESTOWANE: czy wydajno zmienia si liniowo wraz z tym parametrem?
				
	opoznienie:	0 (domylnie) lub wicej to opnienie powodujce "marnowanie" czasu 
					procesora po wejciu, a przed wyjciem.
				TESTOWANE: due opnienie oznacza wtki z wieloma obliczeniami.
					Mona zwikszy priorytet takich wtkw, jednak mog
					take zosta wywaszczone.
	
	liczWatkow:	liczba rwnolegych wtkw rywalizujcych o blokad.
					Musi to by warto pomidzy 1 i 64
					(maksymalna warto dla funkcji WaitForMultipleObjects). 
					Warto domylna to 4.
				TESTOWANE: okrela, czy czas rzeczywisty ronie liniowo wraz z
					liczb wtkw. Dua liczba wtkw rywalizujcych
					o te same zasoby moe nieliniowo pogarsza wydajno.

	punktyUspienia:	0	[domylnie] bez usypiania (nie zwalnia procesora)
					1	Sleep(0) po zajciu wszystkich zasobw, co powoduje
						udostpnienie procesora w czasie ich zajmowania 
					2	Sleep(0) po zwolnieniu wszystkich zasobw, co powoduje
						udostpnianie procesora bez ich zajmowania
					3	Sleep(0) w obu miejscach
				TESTOWANE: udostpnianie procesorailustruje najlepszy przypadek dla
					wtku, ktry wykonuje operacje wejcia-wyjcia lub z innych przyczyn blokuje program.

    liczAktWatkow: liczba aktywowanych wtkw. Domylnie jest to liczWatkow.
					Wszystkie pozosta wtki oczekuj na semafor. 
				TESTOWANE: wydajno moe wzrosn po ograniczeniu liczby jednoczenie
					aktywnych wtkw rywalizujcych o te same zasoby.
					Powoduje to take serializacj wykonywania wtkw (zwaszcza
					przy niskich wartociach).
					Jeli warto jest ujemna, naley uy wartoci bezwzgldnej,
					a ponadto zwraca licznik semafora po wywoaniach zwalniajcych.

    liczPowt: liczba powtrze uywana przy inicjowania obiektw CS.
	          Ignorowana, jeli ma warto rn od 1 lub 2. Warto domylna jest
			  rwna wartoci domylnej dla danego obiektu CS. Nie ma efektu w systemach
			  jednoprocesorowych.
		            
DODATKOWE TESTY: okrela, czy wydajno zmienia si w zalenoci od
	  operacji gwnych lub w tle.

  Autor: Johnson (John) M. Hart. 23 kwietnia 1998. Wzbogacony 10 maja 1998.        
		Oparty na pomyle Davida Poultona.
	*/
/********************************************************************/
#define _WIN32_WINNT 0x0500  // WINBASE.H - naley umieci przed deklaracj #include <windows.h>!
			// Jest potrzebna dla funkcji InitializeCriticalSectionAndSpinCount i
			// SetCriticalSectionSpinCount oraz innych funkcji obsugiwanych w 
			// systemach Windows NT 5.0 i nowszych. Uwaga: wedug biblioteki MSDN
			// potrzebne s tylko systemy NT 4.0, jednak wedug pliku WINBASE.H jest inaczej.
#include "Everything.h"

#define ITERATIONS 1000000	/*  Liczba powtrze testu wzajemnego wykluczania. */

#define THREADS 4			/*  Domylna liczba wtkw do testowania wzajemnego wykluczania.
						Nie moe wynosi wicej ni 64 (ograniczenie z uwagi na funkcj WaitForMultipleObjects). */

DWORD WINAPI CrSecProc(LPVOID);
DWORD WINAPI CrSecProcA(LPVOID);
DWORD WINAPI MutexProc(LPVOID);

int DelayFactor = 0, Which = 1, Depth = 1, NumThreads = THREADS, SleepPoints = 0;
int SpinCount = -1;
int NumThActive;

HANDLE hMutex;					/* Uchwyt muteksu. */
HANDLE hSem;					/* Semafor ograniczajcy liczb aktywnych wtkw. */
CRITICAL_SECTION hCritical, hCriticalA;			/*  Obiekt CS. */
BOOLEAN PrintSemCount = FALSE;
LONG SemCount=-1, SemCount1=-1;

/********************************************************************/
/*  Funkcja do "marnowania" czasu. Zuywa losow ilo czasu procesora.       */
/********************************************************************/

void WasteTime (DWORD DelayFactor)
{
	int Delay, k, i;
	if (DelayFactor == 0) return;
	Delay = (DWORD)(DelayFactor * (float)rand()/RAND_MAX); 
	for (i = 0; i < Delay; i++) k = rand()*rand(); /* Marnowanie czasu. */
	return;
}




/************************************************************************/
/*  Dla kadego algorytmu wzajmenego wykluczania naley utworzy wtki i*/
/*	oczekiwa na zakoczenie przez nie pracy.													*/
/************************************************************************/
int _tmain(int argc, LPTSTR argv[])
{	
	HANDLE *hThreadHandles;			/* Tablica na uchwyty wtkw. */
	DWORD ThreadID;							/* Zmienna na identyfikator wtku. */
	int iTh;								/* Zmienna do sterowania ptl. */

	FILETIME FileTime;	/* Czas do inicjowania liczb losowych. */
	SYSTEMTIME SysTi;

/*	TimeMutex co [glebokosc [opoznienie [liczWatkow [punktyUspienia]]]] */

	/*  Inicjowanie generatora liczb losowych. */
	GetSystemTime (&SysTi);
	SystemTimeToFileTime (&SysTi, &FileTime);
	srand (FileTime.dwLowDateTime);
		
	if (argc >= 4) DelayFactor = _ttoi (argv[3]);		
	if (argc >= 3) Depth = _ttoi (argv[2]);
	if (argc >= 2) Which = _ttoi (argv[1]);
	if (argc >= 5) NumThreads = NumThActive = _ttoi (argv[4]);
	if (argc >= 6) SleepPoints = _ttoi (argv[5]);
	if (argc >= 7) NumThActive = _ttoi (argv[6]);
	if (NumThActive < 0) {
		NumThActive = -NumThActive;
		PrintSemCount = TRUE;
	}
	if (NumThActive == 0) NumThActive = NumThreads;

	if (argc >= 8) SpinCount = _ttoi (argv[7]);

	if (Which != 1 && Which != 2 && Which != 3) {
		_tprintf (_T("Pierwszy argument musi mie warto 1, 2 lub 3.\n"));
		return 1;
	}
	if (!(NumThreads >= 1 && NumThreads <= MAXIMUM_WAIT_OBJECTS)) {
		_tprintf (_T("Liczba wtkw musi wynosi midzy 1 i %d\n"), MAXIMUM_WAIT_OBJECTS);
		return 2;
	}
	
	NumThActive = min (NumThActive, NumThreads);
	if (!(SleepPoints >= 0 && SleepPoints <= 3)) SleepPoints = 0;

	_tprintf (_T("co = %d, glebokosc = %d, opoznienie = %d, liczWatkow = %d, punktyUspienia = %d, liczAktWatkow = %d, liczPowt = %d\n"),
		Which, Depth, DelayFactor, NumThreads, SleepPoints, NumThActive, SpinCount);

	if (Which == 3) hMutex=CreateMutex (NULL, FALSE, NULL);		
	if  (Which == 1 || Which == 2) InitializeCriticalSection (&hCritical);
	if ((Which == 1 || Which == 2) && SpinCount >= 0) 
		SetCriticalSectionSpinCount (&hCritical, SpinCount); 

	if (Which == 2) InitializeCriticalSection (&hCriticalA);
	hSem = CreateSemaphore (NULL, NumThActive, NumThActive, NULL);
	if (PrintSemCount) {
		ReleaseSemaphore (hSem, 1, &SemCount); /* Powinno zakoczy si niepowodzeniem. */
		_tprintf (_T("Licznike semafora w momencie tworzenia: %d\n"), SemCount);
		ReleaseSemaphore (hSem, 0, &SemCount1);
		_tprintf (_T("Licznik semafora po zwolnieniu 0: %d\n"), SemCount1);
		SemCount = SemCount1 = -1;
	}
	if (hSem == NULL) {
		_tprintf (_T("Nie mozna utworzy semafora. %d\n"), GetLastError());
		return 3;
	}

	/* Tworzenie wszystkich wtkw i czekanie na zakoczenie przez nie pracy. */

	hThreadHandles = malloc (NumThreads * sizeof(HANDLE));
	if (hThreadHandles == NULL) {
		_tprintf (_T("Nie mozna zaalokowac pamieci na uchwyty watkow.\n"));
		return 4;
	}

	for(iTh=0; iTh<NumThreads; iTh++)				
	{
		if((hThreadHandles[iTh] = 
			(HANDLE)_beginthreadex 
			(NULL, 0, Which == 1 ? CrSecProc : Which == 3 ? MutexProc : CrSecProcA,
				NULL, 0, &ThreadID)) == NULL)
		{
			_tprintf(_T("Blad tworzenia watku %d\n"), iTh);
			return 1;
		}	
	}		

	WaitForMultipleObjects(NumThreads,hThreadHandles,TRUE,INFINITE);  
	
	for(iTh=0; iTh<NumThreads; iTh++)	CloseHandle(hThreadHandles[iTh]);	
	free (hThreadHandles);

	if (Which == 1 || Which == 2) DeleteCriticalSection(&hCritical);
	if (Which == 2) DeleteCriticalSection(&hCriticalA);
	if (Which == 3) CloseHandle(hMutex);
	return 0;
}

/********************************************************************/
/*	Proste funkcje wtkw do wchodzenia do blokowanych obszarw i opuszczania ich 
    (obiektw CS i muteksw).
	Kady wtek musi oczekiwa na semafor przed rozpoczciem pracy i
	zwalnia semafor po zakoczeniu.				*/
/********************************************************************/

DWORD WINAPI MutexProc(LPVOID Nothing)
{
	int i, k;

	WaitForSingleObject (hSem, INFINITE);
	for (i = 0; i < ITERATIONS; i++)
	{
		for (k = 0; k < Depth; k++) /* Parametr Depth moe mie warto 0. */
			if(WaitForSingleObject(hMutex,INFINITE)==WAIT_FAILED) {
				_tprintf(_T("Niepowodzenie przy oczekiwaniu muteks: %d\n"), GetLastError());
				break;    
			}
		if (SleepPoints % 2 == 1) Sleep (0); /* Udostpnianie procesora przy zajtych zasobach. */
		WasteTime (DelayFactor);/* Tu kod zwizany z obiektem CS. */
		for (k = 0; k < Depth; k++) ReleaseMutex(hMutex);
		if (SleepPoints >= 2) Sleep (0); /* Udostpnianie procesora przy zajtych zasobach. */
	}
	ReleaseSemaphore (hSem, 1, &SemCount);
	if (PrintSemCount) {
		_tprintf (_T("Licznik semafora na koniec funkcji MutexProc: %d\n"), SemCount);
		ReleaseSemaphore (hSem, 2*NumThActive, &SemCount1);
		_tprintf (_T("Licznik semafora po zwolnieniu w funkcji MutexProc: %d\n"), SemCount1);
		SemCount = SemCount1 = -1;
	}


	return 0;
}

DWORD WINAPI CrSecProc(LPVOID Nothing)
{
	int i, k;

	WaitForSingleObject (hSem, INFINITE);
	for (i = 0; i < ITERATIONS; i++)
	{
		for (k = 0; k < Depth; k++) 
			EnterCriticalSection (&hCritical);
		if (SleepPoints % 2 == 1) Sleep (0); /* Udostpnianie procesora przy zajtych zasobach. */
		WasteTime (DelayFactor);/* Tu kod zwizany z obiektem CS. */
		for (k = 0; k < Depth; k++) 
			LeaveCriticalSection(&hCritical);
		if (SleepPoints >= 2) Sleep (0); /* Udostpnianie procesora przy zajtych zasobach. */
	}
	ReleaseSemaphore (hSem, 1, &SemCount);
	if (PrintSemCount) {
		_tprintf (_T("Licznik semafora po zwolnieniu w funkcji CrSecProc: %d\n"), SemCount);
		SemCount = SemCount1 = -1;
	}

	return 0;
}


DWORD WINAPI CrSecProcA(LPVOID Nothing)
{
	int i, k;

	WaitForSingleObject (hSem, INFINITE);
	for (i = 0; i < ITERATIONS; i++)
	{
		for (k = 0; k < Depth; k++) {
			EnterCriticalSection (&hCritical);
			EnterCriticalSection (&hCriticalA);
		}
		if (SleepPoints % 2 == 1) Sleep (0); /* Udostpnianie procesora przy zajtych zasobach. */
		WasteTime (DelayFactor);/* Tu kod zwizany z obiektem CS. */
		for (k = 0; k < Depth; k++) {
			LeaveCriticalSection(&hCriticalA);
			LeaveCriticalSection(&hCritical);
		}
		if (SleepPoints >= 2) Sleep (0); /* Udostpnianie procesora przy zajtych zasobach. */
	}
	ReleaseSemaphore (hSem, 1, &SemCount);
	if (PrintSemCount) {
		_tprintf (_T("Licznik semafora na kocu funkcji CrSecProcA: %d\n"), SemCount);
		SemCount = SemCount1 = -1;
	}

	return 0;
}

