/********************************************************************/
/*   Rozdzia 9.
     Program do testowania rnych technik synchronizacji z systemu Windows w celu
	 sprawdzenia wpywu wzajemnego wykluczania. W prosty sposb porwnywane s 
	 obiekty CS, muteksy, blokady SRW ze wzgldu na wydajno.
	 Prawie wszystkie czynniki, ktre wpywaj na wydajno programw wielowtkowych,
	 s przedstawiane tu w uproszczony sposb, co pozwala oceni atrakcyjno
	 rnych projektw.
		Liczba wtkw
		Stosowanie muteksw lub obiektw CS
		Zajmowanie zasobw
		Obcienie obliczeniami i operacjami wejcia-wyjcia
		Kontrolowanie liczby aktywnych wtkw
	 
	 Stosowanie:
	 TimeMutualExclusion co [glebokosc [opoznienie [liczWatkow [punktyUspienia [liczAktWatkow [procentWsp]]]]]]

		co:	    1 - Testowanie obiektw CS
				2 - Testowanie zagniedonych obiektw CS
				3 - Testowanie muteksw
				4 - Testowanie blokad SRW
				TESTOWANE: pozwala okreli wzgldn wydajno obiektw CS, muteksw,
						blokad SRW (zwaszcza czasu spdzonego w jdrze).
						Testowanie dwch odrbnych zagniedonych obiektw CS
						pozwala okreli, czy wystpuje liniowy (dwukrotno)
						czy nieliniowy wpyw na wydajno.

		glebokosc:	1 (domylnie) lub wicej oznacza liczb rekurencyjnych wej,
						po ktrych nastpuje tyle samo wyj.
						0 pokazuje dziaanie programu bez synchronizacji.
						Jeli Co == 4, zakadana jest warto 1.
				TESTOWANE: czy wydajno zmienia si liniowo wraz z tym parametrem?

		opoznienie:	0 (domylnie) lub wicej to opnienie powodujce "marnowanie" czasu 
					procesora po wejciu, a przed wyjciem.
				TESTOWANE: due opnienie oznacza wtki z wieloma obliczeniami.
					Mona zwikszy priorytet takich wtkw, jednak mog
					take zosta wywaszczone.

		liczWatkow:	liczba rwnolegych wtkw rywalizujcych o blokad.
					Musi to by warto pomidzy 1 i 64
					(maksymalna warto dla funkcji WaitForMultipleObjects). 
					Warto domylna to 4.
				TESTOWANE: okrela, czy czas rzeczywisty ronie liniowo wraz z
					liczb wtkw. Dua liczba wtkw rywalizujcych
					o te same zasoby moe nieliniowo pogarsza wydajno.

		punktyUspienia:	0	[domylnie] bez usypiania (nie zwalnia procesora)
						1	Sleep(0) po zajciu wszystkich zasobw, co powoduje
							udostpnienie procesora w czasie ich zajmowania 
						2	Sleep(0) po zwolnieniu wszystkich zasobw, co powoduje
							udostpnianie procesora bez ich zajmowania
						3	Sleep(0) w obu miejscach
				TESTOWANE: udostpnianie procesorailustruje najlepszy przypadek dla
					wtku, ktry wykonuje operacje wejcia-wyjcia lub z innych przyczyn blokuje program.

		liczAktWatkow: liczba aktywowanych wtkw. Domylnie jest to liczWatkow.
					Wszystkie pozosta wtki oczekuj na semafor. 0 oznacza brak
					ogranicze.
				TESTOWANE: wydajno moe wzrosn po ograniczeniu liczby jednoczenie
					aktywnych wtkw rywalizujcych o te same zasoby.
					Powoduje to take serializacj wykonywania wtkw (zwaszcza
					przy niskich wartociach).

	    procentWsp: ignorowany, jeli co != 4 (blokady SRW).
		            Domylnie 0 (wszystkie blokady s zajmowane na wyczno). Rodzaj
					blokady jest okrelany losowo.
	
	  DODATKOWE TESTY: okrela, czy wydajno zmienia si w zalenoci od
	  operacji gwnych lub w tle.

  Autor: Johnson (John) M. Hart. 23 kwietnia 1998. Wzbogacony 10 maja 1998,
        zaktualizowany 31 maja 2009.
		Oparty na pomyle Davida Poultona.
	Oparty na WIELOWTKOWEJ APLIKACJI KONSOLOWEJ.
*/
/********************************************************************/

#include "Everything.h"

#define ITERATIONS 10000000	/*  Liczba powtrze testu wzajemnego wykluczania. */

#define THREADS 4			/*  Domylna liczba wtkw do testowania wzajemnego wykluczania.
						Nie moe wynosi wicej ni 64 (ograniczenie z uwagi na funkcj WaitForMultipleObjects). */

DWORD WINAPI CrSecProc(LPVOID);
DWORD WINAPI CrSecProcA(LPVOID);
DWORD WINAPI MutexProc(LPVOID);
DWORD WINAPI SRWLockProc(LPVOID);

int DelayFactor = 0, Which = 1, Depth = 1, NumThreads = THREADS, SleepPoints = 0, SharedPercent = 0;
int NumThActive;

HANDLE hMutex;					/* Uchwyt muteksu. */
HANDLE hSem;					/* Semafor ograniczajcy liczb aktywnych wtkw. */
CRITICAL_SECTION hCritical, hCriticalA;			/*  Obiekt CS. */
SRWLOCK hSRWL;

/********************************************************************/
/*  Funkcja do "marnowania" czasu. Zuywa losow ilo czasu procesora.       */
/********************************************************************/

void WasteTime (DWORD DelayFactor)
{
	int Delay, k, i;
	if (DelayFactor == 0) return;
	Delay = (DWORD)(DelayFactor * (float)rand()/RAND_MAX); 
	for (i = 0; i < Delay; i++) k = rand()*rand(); /* Marnowanie czasu. */

	return;
}

/************************************************************************/
/*  Dla kadego algorytmu wzajmenego wykluczania naley utworzy wtki i*/
/*	oczekiwa na zakoczenie przez nie pracy.							*/
/************************************************************************/
int _tmain(int argc, LPTSTR argv[])
{	
	HANDLE *hThreadHandles;			/* Tablica na uchwyty wtkw. */
	DWORD ThreadID;							/* Zmienna na identyfikator wtku. */
	int iTh;								/* Zmienna do sterowania ptl. */

	FILETIME FileTime;	/* Czas do inicjowania liczb losowych. */
	SYSTEMTIME SysTi;

/*	TimeMutex co [glebokosc [opoznienie [liczWatkow [punktyUspienia]]]] */

	/*  Inicjowanie generatora liczb losowych. */
	GetSystemTime (&SysTi);
	SystemTimeToFileTime (&SysTi, &FileTime);
	srand (FileTime.dwLowDateTime);
		
	if (argc >= 4) DelayFactor = _ttoi (argv[3]);		
	if (argc >= 3) Depth = _ttoi (argv[2]);
	if (argc >= 2) Which = _ttoi (argv[1]);
	if (argc >= 5) NumThreads = _ttoi (argv[4]);
	if (argc >= 6) SleepPoints = _ttoi (argv[5]);
	if (argc >= 7) NumThActive = max (_ttoi (argv[6]), 0);
	else NumThActive = NumThreads;

	if (4 == Which && argc >= 8) {
		SharedPercent = min (_ttoi (argv[7]), 100);
		if (!WindowsVersionOK (6, 0)) 
		    ReportError (_T("Ten program wymaga systemu Windows NT 6.0 lub nowszego."), 1, FALSE);
	}

	if (Which != 1 && Which != 2 && Which != 3 && Which != 4) {
		_tprintf (_T("Pierwszy argument musi mie warto 1, 2, 3 lub 4.\n"));
		return 1;
	}
	if (!(NumThreads >= 1 && NumThreads <= MAXIMUM_WAIT_OBJECTS)) {
		_tprintf (_T("Liczba wtkw musi wynosi midzy 1 i %d\n"), MAXIMUM_WAIT_OBJECTS);
		return 2;
	}
	NumThActive = min (NumThActive, NumThreads);
	if (!(SleepPoints >= 0 && SleepPoints <= 3)) SleepPoints = 0;

	_tprintf (_T("co = %d, glebokosc = %d, opoznienie = %d, liczWatkow = %d, punktyUspienia = %d, liczAktWatkow = %d\n"),
		Which, Depth, DelayFactor, NumThreads, SleepPoints, NumThActive);
	if (4 == Which)
		_tprintf (_T("Proces wspolnych zajec = %d.\n"), SharedPercent);

	if (3 == Which) hMutex=CreateMutex (NULL, FALSE, NULL);		
	if (1 == Which || 2 == Which) InitializeCriticalSection (&hCritical);
	if (2 == Which) InitializeCriticalSection (&hCriticalA);
	if (4 == Which) InitializeSRWLock (&hSRWL);

	hSem = CreateSemaphore (NULL, NumThActive, max (NumThActive, 1), NULL);
	if (hSem == NULL) {
		_tprintf (_T("Nie mozna utworzyc semafora ograniczajacego. %d\n"), GetLastError());
		return 3;
	}

	/*	Tworzenie wszystkich wtkw i czekanie na zakoczenie przez nie pracy. */

	hThreadHandles = malloc (NumThreads * sizeof(HANDLE));
	if (hThreadHandles == NULL) {
		_tprintf (_T("Nie mozna zaalokowac pamieci na uchwyty watkow.\n"));
		return 4;
	}

	for(iTh=0; iTh<NumThreads; iTh++)				
	{
		if((hThreadHandles[iTh] = 
			(HANDLE)_beginthreadex 
			(NULL, 0, Which == 1 ? CrSecProc : Which == 2 ? CrSecProcA : 
			Which == 3 ? MutexProc : Which == 4 ? SRWLockProc : NULL,
				NULL, 0, &ThreadID)) == NULL)
		{
			_tprintf(_T("Blad tworzenia watku %d\n"), iTh);
			return 1;
		}	
	}		

	WaitForMultipleObjects(NumThreads,hThreadHandles,TRUE,INFINITE);  
	
	for(iTh=0; iTh<NumThreads; iTh++)	CloseHandle(hThreadHandles[iTh]);	
	free (hThreadHandles);

	if (Which == 1 || Which == 2) DeleteCriticalSection(&hCritical);
	if (Which == 2) DeleteCriticalSection(&hCriticalA);
	if (Which == 3) CloseHandle(hMutex);
	return 0;
}

/********************************************************************/
/*	Proste funkcje wtkw do wchodzenia do blokowanych obszarw i opuszczania ich 
    (obiektw CS, muteksw lub blokad SRW).
	Kady wtek musi oczekiwa na semafor przed rozpoczciem pracy i
	zwalnia semafor po zakoczeniu.				*/
/********************************************************************/

DWORD WINAPI MutexProc(LPVOID Nothing)
{
	int i, k;

	if (NumThActive > 0) WaitForSingleObject (hSem, INFINITE);
	for (i = 0; i < ITERATIONS; i++)
	{
		for (k = 0; k < Depth; k++) /* Gboko moe wynosi 0. */
			if(WaitForSingleObject(hMutex,INFINITE)==WAIT_FAILED) {
				_tprintf(_T("Niepowodzenie przy oczekiwaniu muteks: %d\n"), GetLastError());
				break;    
			}
		if (SleepPoints % 2 == 1) Sleep (0); /* Udostpnianie procesora przy zajtych zasobach. */
		WasteTime (DelayFactor); /* Tu kod zwizany z obiektem CS. */
		for (k = 0; k < Depth; k++) ReleaseMutex(hMutex);
		if (SleepPoints >= 2) Sleep (0); /* Udostpnianie procesora przy zajtych zasobach. */
	}
	if (NumThActive > 0) ReleaseSemaphore (hSem, 1, &i);
	return 0;
}

DWORD WINAPI CrSecProc(LPVOID Nothing)
{
	int i, k;

	if (NumThActive > 0) WaitForSingleObject (hSem, INFINITE);
	for (i = 0; i < ITERATIONS; i++)
	{
		for (k = 0; k < Depth; k++) 
			EnterCriticalSection (&hCritical);
		if (SleepPoints % 2 == 1) Sleep (0); /* Udostpnianie procesora przy zajtych zasobach. */
		WasteTime (DelayFactor); /* Tu kod zwizany z obiektem CS. */
		for (k = 0; k < Depth; k++) 
			LeaveCriticalSection(&hCritical);
		if (SleepPoints >= 2) Sleep (0); /* Udostpnianie procesora przy zajtych zasobach. */
	}
	if (NumThActive > 0) ReleaseSemaphore (hSem, 1, &i);
	return 0;
}

DWORD WINAPI CrSecProcA(LPVOID Nothing)
{
	int i, k;

	if (NumThActive > 0) WaitForSingleObject (hSem, INFINITE);
	for (i = 0; i < ITERATIONS; i++)
	{
		for (k = 0; k < Depth; k++) {
			EnterCriticalSection (&hCritical);
			EnterCriticalSection (&hCriticalA);
		}
		if (SleepPoints % 2 == 1) Sleep (0); /* Udostpnianie procesora przy zajtych zasobach. */
		WasteTime (DelayFactor); /* Tu kod zwizany z obiektem CS. */
		for (k = 0; k < Depth; k++) {
			LeaveCriticalSection(&hCriticalA);
			LeaveCriticalSection(&hCritical);
		}
		if (SleepPoints >= 2) Sleep (0); /* Udostpnianie procesora przy zajtych zasobach. */
	}
	if (NumThActive > 0) ReleaseSemaphore (hSem, 1, &i);
	return 0;
}

DWORD WINAPI SRWLockProc(LPVOID Nothing)
{
	int i;

	if (NumThActive > 0) WaitForSingleObject (hSem, INFINITE);
	for (i = 0; i < ITERATIONS; i++)
	{
		if (1 || SharedPercent > 0 && (100.0 * (float)rand())/RAND_MAX > SharedPercent)
		{
			// Blokada na wyczno.
		    AcquireSRWLockExclusive (&hSRWL);
		    if (SleepPoints % 2 == 1) Sleep (0); /* Udostpnianie procesora przy zajtych zasobach. */
		    WasteTime (DelayFactor); /* Tu kod zwizany z obiektem CS. */
	        ReleaseSRWLockExclusive(&hSRWL);
		    if (SleepPoints >= 2) Sleep (0); /* Udostpnianie procesora przy zajtych zasobach. */
		} else {
			// Blokada wspuytkowana.
		    AcquireSRWLockShared (&hSRWL);
		    if (SleepPoints % 2 == 1) Sleep (0); /* Udostpnianie procesora przy zajtych zasobach. */
		    WasteTime (DelayFactor); /* Tu kod zwizany z obiektem CS. */
	        ReleaseSRWLockShared(&hSRWL);
		    if (SleepPoints >= 2) Sleep (0); /* Udostpnianie procesora przy zajtych zasobach. */
		}
	}
	if (NumThActive > 0) ReleaseSemaphore (hSem, 1, &i);
	return 0;
}
