/* Rozdzia 8. simplePC.c.										*/
/* Zarzdza dwoma wtkami (producenta i konsumenta).			*/
/* Producent okresowo tworzy bufory mData z sum kontroln  	*/
/* (bloki komunikatu) informujce konsumenta o tym, e dane s 	*/
/* gotowe. Konsument wywietla te dane na danie       		*/
/* uytkownika. Konsument wczytuje nastpny kompletny bufor		*/
/* mData i sprawdza jego poprawno przed wywietleniem.		*/

#include "Everything.h"
#include <time.h>
#define DATA_SIZE 256

typedef struct MSG_BLOCK_TAG { /* Blok komunikatu. */
	CRITICAL_SECTION mGuard;	/* Zabezpiecza struktur bloku komunikatu.	*/
	DWORD fReady, fStop; 
		/* Flagi gotowoci i zatrzymania.	*/
	volatile DWORD nCons, mSequence; /* Numer porzdkowy bloku komunikatu.	*/
	DWORD nLost;
	time_t mTimestamp;
	DWORD mChecksum; /* Suma kontrolna dla zawartoci komunikatu.		*/
	DWORD mData[DATA_SIZE]; /* Zawarto komunikatu.		*/
} MSG_BLOCK;
/*	Dla bloku komunikatu speniony jest jeden z poniszych warunkw:	*/
/*	  1)	!fReady || fStop											*/
/*			 nie mona niczego zaoy na temat mData		LUB			*/
/*	  2)	fReady && mData s prawidowe								*/
/*			 && mChecksum i mTimestamp s prawidowe					*/ 
/*  Ponadto zawsze obowizuje zaleno 0 <= nLost + nCons <= mSequence	*/

/* Pojedynczy blok komunikatu gotowy do uzupenienia nowymi danymi. 	*/
MSG_BLOCK mBlock = { 0, 0, 0, 0, 0 }; 

DWORD WINAPI Produce (void *);
DWORD WINAPI Consume (void *);
void MessageFill (MSG_BLOCK *);
void MessageDisplay (MSG_BLOCK *);
	
int _tmain (int argc, LPTSTR argv[])
{
	DWORD status;
	HANDLE hProduce, hConsume;
	
	/* Inicjowanie obiektu CRITICAL_SECTION dla bloku komunikatu. */
	InitializeCriticalSection (&mBlock.mGuard);

	/* Tworzenie dwch wtkw. */
	hProduce = (HANDLE)_beginthreadex (NULL, 0, Produce, NULL, 0, NULL);
	if (hProduce == NULL) 
		ReportError (_T("Nie mozna utworzyc watku producenta."), 1, TRUE);
	hConsume = (HANDLE)_beginthreadex (NULL, 0, Consume, NULL, 0, NULL);
	if (hConsume == NULL) 
		ReportError (_T("Nie mozna utworzyc watku konsumenta."), 2, TRUE);
	
	/* Oczekiwanie na zakoczenie pracy przez producenta i konsumenta. */
	
	status = WaitForSingleObject (hConsume, INFINITE);
	if (status != WAIT_OBJECT_0) 
		ReportError (_T("Nieudane oczekiwanie na watek konsumenta."), 3, TRUE);
	status = WaitForSingleObject (hProduce, INFINITE);
	if (status != WAIT_OBJECT_0) 
		ReportError (__T("Nieudane oczekiwanie na watek producenta."), 4, TRUE);

	DeleteCriticalSection (&mBlock.mGuard);

	_tprintf (_T("Watki producenta i konsumenta zakonczyly prace.\n"));
	_tprintf (_T("Wygenerowano: %d, skonsumowano: %d, utracono: %d.\n"),
		mBlock.mSequence, mBlock.nCons, mBlock.mSequence - mBlock.nCons);
	return 0;
}

DWORD WINAPI Produce (void *arg)
/* Wtek producenta - tworzy nowe komunikaty w losowych odstpach czasu. */
{
	srand ((DWORD)time(NULL)); /* Inicjowanie generatora liczb losowych. 	*/
	
	while (!mBlock.fStop) {
		/* Losowe opnienie. */
		Sleep(rand()/100);
		
		/* Pobieranie i zapenianie bufora. */
		
		EnterCriticalSection (&mBlock.mGuard);
		__try {
			if (!mBlock.fStop) {
				mBlock.fReady = 0;
				MessageFill (&mBlock);
				mBlock.fReady = 1;
				InterlockedIncrement (&mBlock.mSequence);
			}
		} 
		__finally { LeaveCriticalSection (&mBlock.mGuard); }
	}
	return 0;
}

DWORD WINAPI Consume (void *arg)
{
	CHAR command, extra;
	/* Wywietlanie NASTPNEGO komunikatu w odpowiedzi na danie uytkownika. */
	while (!mBlock.fStop) { /* Jedyny wtek z dostpem do urzdze stdin i stdout. */
		_tprintf (_T("\n**Wpisz 's', aby skonsumowac, lub 'z', aby zatrzymac: "));
		_tscanf (_T("%c%c"), &command, &extra);
		if (command == _T('z')) {
			/* Obiekt CS nie jest tu potrzebny. Nie jest to operacja wczytaj, zmodyfikuj, zapisz.
             * Producent widzi now warto po zwrceniu sterowania przez konsumenta. */
			mBlock.fStop = 1;
		} else if (command == _T('s')) { /* Pobieranie nowego bufora do wywietlenia. */
			EnterCriticalSection (&mBlock.mGuard);
			__try {
				if (mBlock.fReady == 0) 
					_tprintf (_T("Brak nowych danych. Sprobuj pozniej.\n"));
				else {
					MessageDisplay (&mBlock);
					mBlock.nLost = mBlock.mSequence - mBlock.nCons + 1;
					mBlock.fReady = 0; /* Brak nowych komunikatw. */
					InterlockedIncrement(&mBlock.nCons);
				}
			} 
			__finally { LeaveCriticalSection (&mBlock.mGuard); }
		} else {
			_tprintf (_T("Niedozwolone polecenie. Sprobuj ponownie.\n"));
		}
	}
	return 0;		
}

void MessageFill (MSG_BLOCK *msgBlock)
{
	/* Zapenianie bufora na komunikat oraz tworzenie sumy kontrolnej i znacznika czasu.	*/
	/* Ta funkcja jest wywoywana w wtku producenta, kiedy zajmuje on 	*/
	/* muteks bloku komunikatu.					*/
	
	DWORD i;
	
	msgBlock->mChecksum = 0;	
	for (i = 0; i < DATA_SIZE; i++) {
		msgBlock->mData[i] = rand();
		msgBlock->mChecksum ^= msgBlock->mData[i];
	}
	msgBlock->mTimestamp = time(NULL);
	return;
}

void MessageDisplay (MSG_BLOCK *msgBlock)
{
	/* Zapenianie bufora na komunikat oraz tworzenie sumy kontrolnej i znacznika czasu.	*/
	/* Ta funkcja jest wywoywana w wtku producenta, kiedy zajmuje on 	*/
	/* muteks bloku komunikatu.					*/
	DWORD i, tcheck = 0;
	
	for (i = 0; i < DATA_SIZE; i++) 
		tcheck ^= msgBlock->mData[i];
	_tprintf (_T("\nKomunikat numer %d wygenerowano %s"), 
		msgBlock->mSequence, _tctime (&(msgBlock->mTimestamp)));
	_tprintf (_T("Pierwszy i ostatni wpis: %x %x\n"),
		msgBlock->mData[0], msgBlock->mData[DATA_SIZE-1]);
	if (tcheck == msgBlock->mChecksum)
		_tprintf (_T("POPRAWNE  sprawdzono wartosc mChecksum.\n"));
	else
		_tprintf (_T("BLAD w wartosci mChecksum. Komunikat jest uszkodzony.\n"));
		
	return;
}