/* Rozdzia 8. eventPC.c.										*/
/* Zarzdza dwoma wtkami (producenta i konsumenta).			*/
/* Producent okresowo tworzy bufory mData z sum kontroln  	*/
/* (bloki komunikatu) informujce konsumenta o tym, e dane s 	*/
/* gotowe. Konsument wywietla te dane na danie       		*/
/* uytkownika. Konsument wczytuje nastpny kompletny bufor		*/
/* mData i sprawdza jego poprawno przed wywietleniem.		*/
/* Jest to nowa implementacja programu simplePC.c z wykorzystaniem zdarze.		*/

#include "Everything.h"
#include <time.h>
#define DATA_SIZE 256

typedef struct msg_block_tag { /* Blok komunikatu. */
	volatile DWORD	f_ready, f_stop; 
		/* Flagi gotowoci i zatrzymania.	*/
	volatile DWORD sequence; /* Numer porzdkowy bloku komunikatu.	*/
	volatile DWORD nCons, nLost;
	time_t timestamp;
	HANDLE	mguard;	/* Muteks zabezpieczajcy struktur bloku komunikatu.	*/
	HANDLE	mready; /* Zdarzenie informujce o tym, e komunikat jest gotowy.			*/
	DWORD	checksum; /* Suma kontrolna dla zawartoci komunikatu.		*/
	DWORD	data[DATA_SIZE]; /* Zawarto komunikatu.		*/
} MSG_BLOCK;
/*	Dla bloku komunikatu speniony jest jeden z poniszych warunkw:	*/
/*	  1)	!fReady || fStop											*/
/*			 nie mona niczego zaoy na temat mData		LUB			*/
/*	  2)	fReady && mData s prawidowe								*/
/*			 && mChecksum i mTimestamp s prawidowe					*/ 
/*  Ponadto zawsze obowizuje zaleno 0 <= nLost + nCons <= mSequence	*/

/* Pojedynczy blok komunikatu gotowy do uzupenienia nowymi danymi. 	*/
MSG_BLOCK mblock = { 0, 0, 0, 0, 0 }; 

DWORD WINAPI produce (void *);
DWORD WINAPI consume (void *);
void MessageFill (MSG_BLOCK *);
void MessageDisplay (MSG_BLOCK *);
	
int _tmain (int argc, LPTSTR argv[])
{
	DWORD Status, ThId;
	HANDLE produce_h, consume_h;
	
	/* Inicjowanie muteksu i zdarzenia (z automatycznym zerowaniem) dla bloku komunikatu. */
	mblock.mguard = CreateMutex (NULL, FALSE, NULL);
	mblock.mready = CreateEvent (NULL, FALSE, FALSE, NULL);

	/* Tworzenie dwch wtkw. */
	produce_h = (HANDLE)_beginthreadex (NULL, 0, produce, NULL, 0, &ThId);
	if (produce_h == NULL) 
		ReportError (_T("Nie mozna utworzyc watku producenta."), 1, TRUE);
	consume_h = (HANDLE)_beginthreadex (NULL, 0, consume, NULL, 0, &ThId);
	if (consume_h == NULL) 
		ReportError (_T("Nie mozna utworzyc watku konsumenta."), 2, TRUE);
	
	/* Oczekiwanie na zakoczenie pracy przez producenta i konsumenta. */
	
	Status = WaitForSingleObject (consume_h, INFINITE);
	if (Status != WAIT_OBJECT_0) 
		ReportError (_T("Nieudane oczekiwanie na watek konsumenta."), 3, TRUE);
	Status = WaitForSingleObject (produce_h, INFINITE);
	if (Status != WAIT_OBJECT_0) 
		ReportError (__T("Nieudane oczekiwanie na watek producenta."), 4, TRUE);

	CloseHandle (mblock.mguard);
	CloseHandle (mblock.mready);

	_tprintf (_T("Watki producenta i konsumenta zakonczyly prace.\n"));
	_tprintf (_T("Wygenerowano: %d, skonsumowano: %d, utracono: %d.\n"),
		mblock.sequence, mblock.nCons, mblock.nLost);
	return 0;
}

DWORD WINAPI produce (void *arg)
/* Wtek producenta - tworzy nowe komunikaty w losowych odstpach czasu. */
{
	
	srand ((DWORD)time(NULL)); /* Inicjowanie generatora liczb losowych. 	*/
	
	while (!mblock.f_stop) {
		/* Losowe opnienie. */
		Sleep(rand()); /* Dugie oczekiwanie na nastpny komunikat. */
		
		/* Pobieranie i zapenianie bufora. */
		
		WaitForSingleObject (mblock.mguard, INFINITE);
		__try {
			if (!mblock.f_stop) {
				mblock.f_ready = 0;
				MessageFill (&mblock);
				mblock.f_ready = 1;
				mblock.sequence++;
				SetEvent(mblock.mready); /* Zgaszanie dostpnoci komunikatu. */
			}
		} 
		__finally { ReleaseMutex (mblock.mguard); }
	}
	return 0;
}

DWORD WINAPI consume (void *arg)
{
	DWORD ShutDown = 0;
	CHAR command, extra;
	/* Wywietlanie NASTPNEGO komunikatu w odpowiedzi na danie uytkownika. */
	while (!ShutDown) { /* Jedyny wtek z dostpem do urzdze stdin i stdout. */
		_tprintf (_T("\n**Wpisz 's', aby skonsumowac, lub 'z', aby zatrzymac: "));
		_tscanf (_T("%c%c"), &command, &extra);
		if (command == _T'z')) {
			WaitForSingleObject (mblock.mguard, INFINITE);
			ShutDown = mblock.f_stop = 1;
			ReleaseMutex (mblock.mguard);
		} else if (command == _T('s')) { /* Nowy bufor do wywietlenia. */
			WaitForSingleObject (mblock.mguard, INFINITE);
			WaitForSingleObject (mblock.mready, INFINITE);
			MessageDisplay (&mblock);
			mblock.nCons++;
			mblock.nLost = mblock.sequence - mblock.nCons;
			mblock.f_ready = 0; /* Brak nowych gotowych komunikatw. */
			ReleaseMutex (mblock.mguard);
		} else {
			_tprintf (_T("Niedozwolone polecenie. Sprobuj ponownie.\n"));
		}
	}
	return 0;		
}

void MessageFill (MSG_BLOCK *mblock)
{
	/* Zapenianie bufora na komunikat oraz tworzenie sumy kontrolnej i znacznika czasu.	*/
	/* Ta funkcja jest wywoywana w wtku producenta, kiedy zajmuje on 	*/
	/* muteks bloku komunikatu.					*/
	
	DWORD i;
	
	mblock->checksum = 0;	
	for (i = 0; i < DATA_SIZE; i++) {
		mblock->data[i] = rand();
		mblock->checksum ^= mblock->data[i];
	}
	mblock->timestamp = time(NULL);
	return;
}

void MessageDisplay (MSG_BLOCK *mblock)
{
	/* Wywietlanie bufora z komunikatem i znacznika czasu oraz sprawdzanie sumy kontrolnej. */
	/* Ta funkcja jest wywoywana w wtku producenta, kiedy zajmuje on 	*/
	/* muteks bloku komunikatu.					*/
	DWORD i, tcheck = 0;
	
	for (i = 0; i < DATA_SIZE; i++) 
		tcheck ^= mblock->data[i];
	_tprintf (_T("\nKomunikat numer %d wygenerowano %s"), 
		mblock->sequence, _tctime (&(mblock->timestamp)));
	_tprintf (_T("Pierwszy i ostatni wpis: %x %x\n"),
		mblock->data[0], mblock->data[DATA_SIZE-1]);
	if (tcheck == mblock->checksum)
		_tprintf (_T("POPRAWNE  sprawdzono wartosc mChecksum.\n"));
	else
		_tprintf (_T("BLAD w wartosci mChecksum. Komunikat jest uszkodzony.\n"));
		
	return;

}