/* Rozdzia 7. wcST.c										*/
/*															*/
/* wcST plik1 plik2 ... plikN								*/
/* OSTRZEENIE: kod NIE obsuguje kodowania UNICODE.		*/
/*															*/
/* Rwnolege zliczanie sw - wersja jednowtkowa.			*/
/*	Porwnaj wydajno z programem wcMT.c.					*/
/* Wywoywanie funkcji wtkw synchronicznie, a nie			*/
/* za pomoc wtkw, bywa przydatne na wczesnych etapach 	*/
/* diagnozowania, poniewa mona przetestowa  logik programu	*/
/* w rodowisku jednowtkowym przed przetestowaniem kodu do	*/
/* zarzdzania wtkami.										*/
/* Niezalene przetwarzanie wielu plikw					*/
/* w modelu z wtkiem gwnym i wtkami roboczymi.			*/
/* Okrela czn liczb znakw, sw i wierszy   			*/
/* w plikach okrelonych w wierszu polece, podobnie		*/
/* jak robi to UNIX-owe narzdzie wc.						*/
/* Kady plik jest przetwarzany przez odrbny wtek roboczy.*/
/* Wtek gwny zbiera odrbne wyniki 						*/
/* wyniki i czy je w ostateczne rezultaty.				*/

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>

typedef struct { /* Struktura argumentu wtku.			*/
	char * filename;
	int kchar;
	int kword;
	int kline;
	int wcerror;
} THREAD_ARG;

int wcfunc (void *);

int main (int argc, char * argv[])

{
	int ithrd, tstatus;
	int nchar = 0, nword = 0, nline = 0;
	THREAD_ARG * targ;
	
	if (argc < 2) {
		printf ("Stosowanie: wcST nazwapliku ... nazwapliku\n");
		return 1;
	}
	
	/* Alokowanie odwoania do wtku i argumentu wtku dla 	*/
	/* kadego wtku roboczego.					*/
	targ = (THREAD_ARG *) calloc (argc-1, sizeof (THREAD_ARG));
	if (targ == NULL) {
		printf ("Nie mozna zaalokowac pamieci dla watku roboczego.\n");
		return 2;
	}
	
	/* Zliczanie plikw z wiersza polece. */
	for (ithrd = 0; ithrd < argc - 1; ithrd++) {
		targ[ithrd].filename = argv[ithrd+1];
		/* Tworzenie wtku roboczego do przetwarzania pliku. */
		tstatus = wcfunc ((void *)&targ[ithrd]);
		if (tstatus != 0)
			printf ("Blad przy zliczaniu slow w pliku: %s\n",
				targ[ithrd].filename);
		nchar += targ[ithrd].kchar;
		nword += targ[ithrd].kword;
		nline += targ[ithrd].kline;
		printf ("%10d %9d %9d %s\n", targ[ithrd].kline,
			targ[ithrd].kword, targ[ithrd].kchar,
			targ[ithrd].filename);
	}
	
	
	free (targ); /* Wtki zostay odczone. 	*/
	printf ("%10d %9d %9d \n", nline, nword, nchar);
	return 0;
}

int wcfunc (void * arg)
/* Zlicza znaki, sowa i wiersze w pliku	*/
/* targ->filename.					*/
/* UWAGA: to prosta wersja; wyniki mog by inne ni z narzdzia wc. */
{
	FILE * fin;
	THREAD_ARG * targ;
	int ch, c, nl, nw, nc;
	
	targ = (THREAD_ARG *)arg;
	targ->wcerror = 1; /* Ustawianie bdu. */
	fin = fopen (targ->filename, "r");
	if (fin == NULL) return 1;
	
	ch = nw = nc = nl = 0;
	while (!feof (fin)) {
		c = getc (fin);
		if (c == '\0') break;
		if (isspace(c) && isalpha(ch))
			nw++;
		ch = c;
		nc++;
		if (c == '\n')
			nl++;
	}
	fclose (fin);
	targ->kchar = nc; targ->kword = nw;
	targ->kline = nl;
	targ->wcerror = 0;
	return 0;
}
