/* Rozdzia 7. wcMTxx.c										*/
/* CELOWO Z WIELOMA BDAMI									*/
/*      Kod nie jest zgodny z kodowaniem UNICODE.		    */
/*															*/
/* wcMTxx plik1 plik2 ... plikN								*/
/*															*/
/* Rwnolege zliczanie sw - wersja wielowtkowa.			*/
/* Obejmuje wiele czsto spotykanych bdw i kiepskich		*/
/* technik programistycznych.								*/
/*															*/
/* Niezalene przetwarzanie wielu plikw					*/
/* w modelu z wtkiem gwnym i wtkami roboczymi.			*/
/* Okrela czn liczb znakw, sw i wierszy   			*/
/* w plikach okrelonych w wierszu polece, podobnie		*/
/* jak robi to UNIX-owe narzdzie wc.						*/
/* Kady plik jest przetwarzany przez odrbny wtek roboczy.*/
/* Wtek gwny zbiera odrbne wyniki 						*/
/* wyniki i czy je w ostateczne rezultaty.				*/

#include "Everything.h"

typedef struct { /* Struktura argumentu wtku.		*/
	char * filename;
	int kchar;
	int kword;
	int kline;
	int wcerror;
	int Done;
} THREAD_ARG;

DWORD WINAPI wcfunc (void *);

int main (int argc, char * argv[])

{
	DWORD ithrd, tid;
	DWORD nchar = 0, nword = 0, nline = 0;
	THREAD_ARG * targ;
	
	if (argc < 2) {
		printf ("Stosowanie: wcMTxx nazwapliku ... nazwapliku\n");
		return 1;
	}
	
	/* Alokowanie odwoania do wtku i argumentu wtku dla 	*/
	/* kadego wtku roboczego.					*/
	targ = (THREAD_ARG *) calloc (argc-1, sizeof (THREAD_ARG));
	if (targ == NULL) {
		printf ("Nie mozna zaalokowac pamieci dla watku roboczego.\n");
		return 2;
	}
	
	/* Tworzenie wtku roboczego dla kadego podanego pliku. */
	for (ithrd = 0; ithrd < (DWORD)argc - 1; ithrd++) {
		targ[ithrd].filename = argv[ithrd+1];
		/* Tworzenie wtku roboczego do przetwarzania pliku. */
		if (_beginthreadex (NULL, 0, wcfunc, &targ[ithrd], 0, &tid) == 0)
				ReportError ("Nie mozna utworzyc watku.", 1, TRUE);
	}
	
	/* Wszystkie wtki robocze dziaaj. Trzeba poczeka na zakoczenie	*/
	/* przez nie pracy i poczy wyniki. */
	for (ithrd = 0; ithrd < (DWORD)argc - 1; ithrd++) {
		while (targ[ithrd].Done == 0) Sleep(0);
		/* Zgoszenie niepowodzenia, ale kontynuowanie pracy. 		*/
		nchar += targ[ithrd].kchar;
		nword += targ[ithrd].kword;
		nline += targ[ithrd].kline;
		printf ("%10d %9d %9d %s\n", targ[ithrd].kline,
			targ[ithrd].kword, targ[ithrd].kchar,
			targ[ithrd].filename);
	}
	
	printf ("%10d %9d %9d \n", nline, nword, nchar);
	return 0;
}

DWORD WINAPI wcfunc (void * arg)
/* Zlicza znaki, sowa i wiersze w pliku	*/
/* targ->filename.					*/
/* UWAGA: to prosta wersja; wyniki mog by inne ni z narzdzia wc. */
{
	FILE * fin;
	THREAD_ARG * targ;
	int ch, c, nl, nw, nc;
	
	targ = (THREAD_ARG *)arg;
	targ->wcerror = 1; /* Ustawianie bdu. */
	fin = fopen (targ->filename, "r");
	if (fin == NULL) return (targ->wcerror);
	
	ch = nw = nc = nl = 0;
	while (!feof (fin)) {
		c = getc (fin);
		if (c == '\0') break;
		if (isspace(c) && isalpha(ch))
			nw++;
		ch = c;
		nc++;
		if (c == '\n')
			nl++;
	}
	fclose (fin);
	targ->kchar = nc; targ->kword = nw;
	targ->kline = nl;
	targ->wcerror = 0;
	targ->Done = 1;
	return 0;
}
