/* Rozdzia 7. wcMTx.c										*/
/*		CELOWO BDNY. ZNAJD I NAPRAW USTERKI.				*/
/*      Kod nie jest zgodny z kodowaniem UNICODE.		    */
/* wcMT plik1 plik2 ... plikN								*/
/*															*/
/* Rwnolege zliczanie sw - wersja wielowtkowa.			*/
/*															*/
/* Niezalene przetwarzanie wielu plikw					*/
/* w modelu z wtkiem gwnym i wtkami roboczymi.			*/
/* Okrela czn liczb znakw, sw i wierszy   			*/
/* w plikach okrelonych w wierszu polece, podobnie		*/
/* jak robi to UNIX-owe narzdzie wc.						*/
/* Kady plik jest przetwarzany przez odrbny wtek roboczy.*/
/* Wtek gwny zbiera odrbne wyniki 						*/
/* wyniki i czy je w ostateczne rezultaty.				*/

#include "Everything.h"

typedef struct { /* Struktura argumentu wtku.		*/
	char * filename;
	volatile int kchar;
	volatile int kword;
	volatile int kline;
	volatile int wcerror;
} THREAD_ARG;

DWORD WINAPI wcfunc (void *);

int main (int argc, char * argv[])

{
	HANDLE *tref;
	DWORD ithrd, tstatus, tid;
	DWORD nchar = 0, nword = 0, nline = 0;
	THREAD_ARG * targ;
	
	if (argc < 2) {
		printf ("Stosowanie: wcMTx nazwapliku ... nazwapliku\n");
		return 1;
	}
	
	/* Alokowanie odwoania do wtku i argumentu wtku dla 	*/
	/* kadego wtku roboczego.					*/
	tref = (HANDLE *) calloc (argc-1, sizeof(HANDLE));
	targ = (THREAD_ARG *) calloc (argc-1, sizeof (THREAD_ARG));
	if (tref == NULL || targ == NULL) {
		printf ("Nie mozna zaalokowac pamieci dla watku roboczego.\n");
		return 2;
	}
	
	/* Tworzenie wtku roboczego dla kadego podanego pliku. */
	for (ithrd = 0; ithrd < (DWORD)argc - 1; ithrd++) {
		/* Tworzenie wtku roboczego do przetwarzania pliku. */
		tref[ithrd] = (HANDLE)_beginthreadex (NULL, 0, wcfunc, (PVOID)targ[ithrd],
			0, &tid);
		targ[ithrd].filename = argv[ithrd+1];
	}
	
	/* Wszystkie wtki robocze dziaaj. Trzeba poczeka na zakoczenie	*/
	/* przez nie pracy i poczy wyniki. */
	for (ithrd = 0; ithrd < (DWORD)argc - 1; ithrd++) {
		tstatus = WaitForSingleObject (tref[ithrd], INFINITE);
		/* Zgoszenie niepowodzenia, ale kontynuowanie pracy.		*/
		if (tstatus != WAIT_OBJECT_0) 
			ReportError ("Blad oczekiwania na watek.", 0, TRUE);
		nchar += targ[ithrd].kchar;
		nword += targ[ithrd].kword;
		nline += targ[ithrd].kline;
		printf ("%10d %9d %9d %s\n", targ[ithrd].kline,
			targ[ithrd].kword, targ[ithrd].kchar,
			targ[ithrd].filename);
	}
	
	free (tref); /* Dealokacja zasobw z pamici. */
	free (targ); /* Wtki zostay odczone. */
	printf ("%10d %9d %9d \n", nline, nword, nchar);
	return 0;
}

static int ch, c, nl, nw, nc;

DWORD WINAPI wcfunc (void * arg)
/* Zlicza znaki, sowa i wiersze w pliku	*/
/* targ->filename.					*/
/* UWAGA: to prosta wersja; wyniki mog by inne ni z narzdzia wc. */
{
	FILE * fin;
	THREAD_ARG * targ;
	
	targ = (THREAD_ARG *)arg;
	targ->wcerror = 1; /* Ustawianie bdu. */
	fin = fopen (targ->filename, "r");
	if (fin == NULL) return (targ->wcerror);
	
	ch = nw = nc = nl = 0;
	while (!feof (fin)) {
		c = getc (fin);
		if (c == '\0') break;
		if (isspace(c) && isalpha(ch))
			nw++;
		ch = c;
		nc++;
		if (c == '\n')
			nl++;
	}
	fclose (fin);
	targ->kchar = nc; targ->kword = nw;
	targ->kline = nl;
	targ->wcerror = 0;
	return 0;
}
