/* Rozdzia 7. wcMTMM.c										*/
/*															*/
/* wcMTMM plik1 plik2 ... plikN								*/
/* OSTRZEENIE: kod NIE obsuguje kodowania UNICODE.		*/
/*															*/
/* Rwnolege zliczanie sw - wersja wielowtkowa.			*/
/*    z plikami odwzorowanymi w pamici.					*/
/*															*/
/* Niezalene przetwarzanie wielu plikw					*/
/* w modelu z wtkiem gwnym i wtkami roboczymi.			*/
/* Okrela czn liczb znakw, sw i wierszy   			*/
/* w plikach okrelonych w wierszu polece, podobnie		*/
/* jak robi to UNIX-owe narzdzie wc.						*/
/* Kady plik jest przetwarzany przez odrbny wtek roboczy.*/
/* Wtek gwny zbiera odrbne wyniki 						*/
/* wyniki i czy je w ostateczne rezultaty.				*/
/* OGRANICZENIE: nie obsuguje "bardzo duych" plikw (> 4 GB).	*/

#include "Everything.h"

typedef struct { /* Struktura argumentu wtku. */
	char * filename;
	volatile unsigned int kchar;
	volatile unsigned int kword;
	volatile unsigned int kline;
	volatile unsigned int wcerror;
} THREAD_ARG;

DWORD WINAPI wcfunc (void *);

int main (int argc, char * argv[])

{
	HANDLE *tref;
	DWORD ithrd, tstatus, tid;
	DWORD nchar = 0, nword = 0, nline = 0;
	THREAD_ARG * targ;
	
	if (argc < 2) {
		printf ("Stosowanie: wcMT nazwaPliku ... nazwaPliku\n");
		return 1;
	}
	
	/* Alokowanie odwoania do wtku i argumentu wtku dla 	*/
	/* kadego wtku roboczego.					*/
	tref = (HANDLE *) calloc (argc-1, sizeof(HANDLE));
	targ = (THREAD_ARG *) calloc (argc-1, sizeof (THREAD_ARG));
	if (tref == NULL || targ == NULL) {
		printf ("Nie mozna zaalokowac pamieci dla watku roboczego.\n");
		return 2;
	}
	
	/* Tworzenie wtku roboczego dla kadego podanego pliku. */
	for (ithrd = 0; ithrd < (DWORD)argc - 1; ithrd++) {
		targ[ithrd].filename = argv[ithrd+1];
		/* Tworzenie wtku roboczego do przetwarzania pliku. */
		tref[ithrd] = (HANDLE)_beginthreadex (NULL, 0, wcfunc, &targ[ithrd],
			0, &tid);
		if (tref[ithrd] == NULL) ReportError ("Nie mozna utworzyc watku.", 1, TRUE);
	}
	
	/* Wszystkie wtki robocze dziaaj. Trzeba poczeka na zakoczenie	*/
	/* przez nie pracy i poczy wyniki. */
	for (ithrd = 0; ithrd < (DWORD)argc - 1; ithrd++) {
		tstatus = WaitForSingleObject (tref[ithrd], INFINITE);
		/* Zgoszenie niepowodzenia, ale kontynuowanie pracy. 		*/
		if (tstatus != WAIT_OBJECT_0) 
			ReportError ("Blad oczekiwania na watek.", 0, TRUE);
		CloseHandle (tref[ithrd]);
		nchar += targ[ithrd].kchar;
		nword += targ[ithrd].kword;
		nline += targ[ithrd].kline;
		printf ("%10d %9d %9d %s\n", targ[ithrd].kline,
			targ[ithrd].kword, targ[ithrd].kchar,
			targ[ithrd].filename);
	}
	
	free (tref); /* Dealokacja zasobw z pamici. */
	free (targ); /* Wtki zostay odczone. */
	printf ("%10d %9d %9d \n", nline, nword, nchar);
	return 0;
}

/* Funkcja narzdziowa. Szybsza od wersji z biblioteki jzyka C. */
int is_a_space(int ch) {
    if(ch == ' ' || ch == '\t' || ch == '\n' ||
        ch == '\f' || ch == '\r') {
        return 1;
    } else {
        return 0;
    }
}

/* Operacje na odwzorowanych plikach czsto dziaaj 
   szybciej ni tradycyjne operacje wejcia-wyjcia.
   Struktura obejmuje "uchwyt" na przedstawione dalej
   funkcje narzdziowe.
 */
typedef struct {
    // Struktura dla odwzorowanego pliku.
    void* pInFile;
    HANDLE hInMap;
    HANDLE hIn;
} MAPPED_FILE_HANDLE;

/* Funkcje narzdziowe zwizane z odwzorowaniami. */
/* Zadanie: rozwi kod, aby wykorzysta systemy 64-bitowe. Ta wersja dziaa
   tylko dla maych plikw.
 */

void* map_file(LPCSTR filename, unsigned unsigned int* pFsLow, int* error, MAPPED_FILE_HANDLE* pmFH)
{
	HANDLE hIn, hInMap;
	LARGE_INTEGER fileSize;
	char* pInFile;

    *error = 0;
    hIn = CreateFile(filename, GENERIC_READ, 0, NULL, OPEN_EXISTING,
                     FILE_ATTRIBUTE_NORMAL, NULL);
    if (hIn == INVALID_HANDLE_VALUE) {
        *error = 2;
        return NULL;
    }

    // Tworzenie obiektu odwzorowania dla pliku wejciowego. Wykorzystanie rozmiaru pliku. 
    hInMap = CreateFileMapping(hIn, NULL, PAGE_READONLY, 0, 0, NULL);
    if (hInMap == INVALID_HANDLE_VALUE) {
        CloseHandle(hIn);
        *error = 3;
        return NULL;
    }

    // Odwzorowywanie pliku wejciowego.
    pInFile = (char*) MapViewOfFile(hInMap, FILE_MAP_READ, 0, 0, 0);
    if (pInFile == NULL) {
        CloseHandle(hInMap);
        CloseHandle(hIn);
        *error = 4;
        return NULL;
    }

    /* Pobieranie rozmiaru pliku wejciowego. Poniewa odwzorowywanie si powiodo,  
	   rozmiar pliku wynosi < 4 GB. Zadanie dla Czytelnika: usu to ograniczenie. */
    if (!GetFileSizeEx(hIn, &fileSize) || fileSize.HighPart != 0) {
        UnmapViewOfFile(pInFile);
        CloseHandle(hInMap);
        CloseHandle(hIn);
        *error = 5;
        return NULL;
    }
	*pFsLow = fileSize.LowPart;

    pmFH->pInFile = pInFile;
    pmFH->hInMap = hInMap;
    pmFH->hIn = hIn;

    return pInFile;
}

void UnMapFile(MAPPED_FILE_HANDLE* pmFH)
{
    UnmapViewOfFile(pmFH->pInFile);
    CloseHandle(pmFH->hInMap);
    CloseHandle(pmFH->hIn);
}

/* Funkcja wtku roboczego do przetwarzania jednego pliku. */
DWORD WINAPI wcfunc (void * arg)
/* Zlicza znaki, sowa i wiersze w pliku	*/
/* targ->filename.					*/
/* UWAGA: to prosta wersja; wyniki mog by inne ni z narzdzia wc.	*/
{
	THREAD_ARG * targ;
	MAPPED_FILE_HANDLE fhandle;
	unsigned int ch, c, nl, nw, nc;
    int isspace_c;       // Obecny znak.
    int isspace_ch = 1;  // Poprzedni znak. Zakadamy, e to odstp (pozwala to uwzgldni pierwsze sowo).

    int error;
    unsigned int fsize;
    char *fin, *fend;
	
	targ = (THREAD_ARG *)arg;
	targ->wcerror = 1; /* Ustawianie bdu. */
	
	fin = (char*) map_file(targ->filename, &fsize, &error, &fhandle);
    if (NULL == fin) {
        return 1;
    }

    fend = fin + fsize;

	ch = nw = nc = nl = 0;
    while (fin < fend) {
        c = *fin++;
        isspace_c = is_a_space(c);
        if (!isspace_c && isspace_ch) {
            nw++;
        }
        isspace_ch = isspace_c;
        if (c == '\n') {
            nl++;
            isspace_ch = 1; // Rozpoczcie szukania nowego sowa.
        }
    }

    UnMapFile(&fhandle);
	targ->kchar = fsize;
	targ->kword = nw;
	targ->kline = nl;
	targ->wcerror = 0;
	return 0;
}
