/* Rozdzia 7. SortMTx. Model zespou roboczego. CELOWO BDNY.
/*	Sortowanie pliku za pomoc wielu wtkw i sortowania przez scalanie.
	sortMT [opcje] liczbaWtkw plik. Model zespou roboczego.  */

/*  Ten program jest oparty na programie sortHP.
	Alokuje blok dla sortowanego pliku, wczytuje ten plik,
	a nastpnie tworzy "liczbaWtkw" wtkw (jeli ta warto to 0, uywa liczby
	procesorw) do sortowania fragmentw pliku. Nastpnie
	scala wyniki w parach. */

/* OGRANICZENIA:
	1.	Liczba wtkw musi by potg liczby 2.
	2.	Liczba 64-bajtowych rekordw musi by wielokrotnoci liczby wtkw.
	wiczenie wymaga usunicia tych ogranicze. */ */

#include "Everything.h"

#define DATALEN 56  /* Odpowiednia dugo danych z plikw prezydenci.txt i krolowie.txt. */
#define KEYLEN 8
typedef struct _RECORD {
	TCHAR Key [KEYLEN];
	TCHAR Data [DATALEN];
} RECORD;
#define RECSIZE sizeof (RECORD)
typedef RECORD * LPRECORD;

typedef struct _THREADARG {	/* Argument wtku. */
	DWORD iTh;		/* Numer wtku: 0, 1, 3, ... */
	LPRECORD lowRecord;	/* Najmniejszy rekord. */
	LPRECORD highRecord;	/* Najwikszy rekord. */
} THREADARG, *PTHREADARG;

static DWORD WINAPI ThSort (PTHREADARG pThArg);
static int KeyCompare (LPCTSTR, LPCTSTR);

static DWORD nRec;	/* czna liczba sortowanych rekordw. */
static HANDLE * ThreadHandle;

int _tmain (int argc, LPTSTR argv[])
{
	/* Plik to pierwszy argument. Sortowanie odbywa si w miejscu */
	/* na stertach w pamici. */

	HANDLE hFile;
	LPRECORD pRecords = NULL;
	DWORD FsLow, nRead, LowRecNo, nRecTh, NPr, ThId, iTh;
	BOOL NoPrint;
	int iFF, iNP;
	PTHREADARG ThArg;
	LPTSTR StringEnd;

	if (argc <= 3) 
		ReportError (_T ("Stosowanie: sortMTx [opcje] liczbaWatkow pliki"), 1, FALSE);

	iNP = Options (argc, argv, _T ("n"), &NoPrint, NULL);
	iFF = iNP + 1;
	NPr = _ttoi (argv [iNP]);

	if (argc <= iFF)
		ReportError (_T ("Stosowanie: sortMTx [opcje] liczbaWatkow pliki"), 1, FALSE);

	/* Otwieranie pliku (uywanie tymczasowej kopii). */

	hFile = CreateFile (argv[iFF], GENERIC_READ | GENERIC_WRITE,
			0, NULL, OPEN_EXISTING, 0, NULL);
	if (hFile == INVALID_HANDLE_VALUE)
		ReportException (_T ("Nieudane otwieranie pliku wejsciowego."), 2);
	
	/* Pobieranie rozmiaru pliku. */

	FsLow = GetFileSize (hFile, NULL);
	if (FsLow == 0xFFFFFFFF)
		ReportException (_T ("Blad pobierania rozmiaru pliku."), 3);

	nRec = FsLow / RECSIZE;	/* czna liczba rekordw. */
	nRecTh = nRec / NPr;	/* Rekordy na wtek. */
	ThArg = malloc (NPr * sizeof (THREADARG));	/* Tablica argumentw wtku. */ 
	ThreadHandle = malloc (NPr * sizeof (HANDLE));
	
	/* Alokowanie bufora na kompletny plik zakoczony znakiem pustym i z wolnym miejscem. */

	pRecords = malloc (FsLow + sizeof (TCHAR));	/* Wczytywanie caego pliku. */
	
	if (!ReadFile (hFile, pRecords, FsLow, &nRead, NULL))
		ReportException (_T ("Blad przy wczytywaniu sortowanego pliku."), 4);
	CloseHandle (hFile);

	/* Tworzenie wtkw sortujcych. */

	LowRecNo = 0;
	for (iTh = 0; iTh < NPr; iTh++) {
		ThArg [iTh].iTh = iTh;
		ThArg [iTh].LowRec = pRecords + LowRecNo;
		LowRecNo += nRecTh;
		ThreadHandle [iTh] = (HANDLE)_beginthreadex (
				NULL, 0, ThSort, &ThArg [iTh], 0, &ThId);
		ThArg [iTh].HighRec = pRecords + (LowRecNo + nRecTh);
	}

	/* Wznawianie pracy wszystkich pocztkowo wstrzymanych wtkw. */

	for (iTh = 0; iTh < NPr; iTh++)
		ResumeThread (ThreadHandle [iTh]);

	for (iTh = 0; iTh < NPr; iTh++)
		CloseHandle (ThreadHandle [iTh]);

	/*  Wywietlanie caego posortowanego pliku traktowanego jako pojedynczy acuch znakw. */

	StringEnd = (LPTSTR) pRecords + FsLow;
	*StringEnd ='\0';
	if (!NoPrint) _tprintf (_T("%s"), (LPCTSTR) pRecords); 
	free (pRecords); free (ThArg); free (ThreadHandle);
	return 0;

} /* Koniec funkcji _tmain. */

static VOID MergeArrays (LPRECORD, LPRECORD);

DWORD WINAPI ThSort (PTHREADARG pThArg)
{
	DWORD GrpSize = 2, RecsInGrp, MyNumber, TwoToI = 1;
			/* TwoToI = 2**i, gdzie i to etap scalania. */
	LPRECORD First;

	MyNumber = pThArg->iTh;
	First = pThArg->LowRec; 
	RecsInGrp = pThArg->HighRec - First; 
		/* Liczba rekordw w tej grupie. */
		/* GrpSize to liczba pierwotnych grup scalanych
			na danym etapie. */
		
	/* Sortowanie danego fragmentu tablicy. */

	qsort (First, RecsInGrp, RECSIZE, KeyCompare);

	/* Koczenie pracy wtku lub oczekiwanie na powizany wtek. */

	while ((MyNumber % GrpSize) == 0 && RecsInGrp < nRec) {
		/* Scalanie z przyleg posortowan tablic. */
		WaitForSingleObject (ThreadHandle [MyNumber + TwoToI], 100);
		MergeArrays (First, First + RecsInGrp);
		RecsInGrp *= 2;
		GrpSize *= 2;
		TwoToI *=2;
	}
	_endthreadex (0);
	return 0;	/* Blokowanie komunikatu ostrzegawczego. */
}

static VOID MergeArrays (LPRECORD p1, LPRECORD p2)
{
	DWORD iRec = 0, nRecs, i1 = 0, i2 = 0;
	LPRECORD pDest, p1Hold, pDestHold;

	nRecs = p2 - p1;
	pDest = pDestHold = malloc (2 * nRecs * RECSIZE);
	p1Hold = p1;

	while (i1 < nRecs && i2 < nRecs) {
		if (KeyCompare ((LPCTSTR)p1, (LPCTSTR)p2) <= 0) {
			memcpy (pDest, p1, RECSIZE);
			i1++; p1++; pDest++;
		}
		else {
			memcpy (pDest, p2, RECSIZE);
			i2++; p2++; pDest++;
		}
	}
	if (i1 >= nRecs)
		memcpy (pDest, p2, RECSIZE * (nRecs - i2));
	else	memcpy (pDest, p1, RECSIZE * (nRecs - i1));

	memcpy (p1Hold, pDestHold, 2 * nRecs * RECSIZE);
	free (pDestHold);
	return;
}

int KeyCompare (LPCTSTR pRec1, LPCTSTR pRec2)
{
	DWORD i;
	TCHAR b1, b2;
	LPRECORD p1, p2;
	int Result = 0;

	p1 = (LPRECORD)pRec1;
	p2 = (LPRECORD)pRec2;
	for (i = 0; i < KEYLEN && Result == 0; i++) {
		b1 = p1->Key [i];
		b2 = p2->Key [i];
		if (b1 < b2) Result = -1;
		if (b1 > b2) Result = +1;
	}
	return  Result;
}
