/* Rozdzia 7. SortMT. Model zespou roboczego.
	Sortowanie pliku za pomoc wielu wtkw i sortowania przez scalanie.
	sortMT [opcje] liczbaWtkw plik. Model zespou roboczego.  */

/*  Ten program jest oparty na programie sortHP.
	Alokuje blok dla sortowanego pliku, wczytuje ten plik,
	a nastpnie tworzy "liczbaWtkw" wtkw (jeli ta warto to 0, uywa liczby
	procesorw) do sortowania fragmentw pliku. Nastpnie
	scala wyniki w parach. */

/* OGRANICZENIA:
	1.	Liczba wtkw musi by potg liczby 2.
	2.	Liczba 64-bajtowych rekordw musi by wielokrotnoci liczby wtkw.
	wiczenie wymaga usunicia tych ogranicze. */

#include "Everything.h"

#define DATALEN 56  /* Odpowiednia dugo danych z plikw prezydenci.txt i krolowie.txt. */
#define KEYLEN 8
typedef struct _RECORD {
	TCHAR key[KEYLEN];
	TCHAR data[DATALEN];
} RECORD;
#define RECSIZE sizeof (RECORD)
typedef RECORD * LPRECORD;

typedef struct _THREADARG {	/* Argument wtku. */
	DWORD iTh;		/* Numer wtku: 0, 1, 3, ... */
	LPRECORD lowRecord;	/* Najmniejszy rekord. */
	LPRECORD highRecord;	/* Najwikszy rekord. */
} THREADARG, *PTHREADARG;

static DWORD WINAPI SortThread (PTHREADARG pThArg);
static int KeyCompare (LPCTSTR, LPCTSTR);

static DWORD nRec;	/* czna liczba sortowanych rekordw. */
static HANDLE * pThreadHandle;

int _tmain (int argc, LPTSTR argv[])
{
	/* Plik to pierwszy argument. Sortowanie odbywa si w miejscu */
	/* na stertach w pamici. */

	HANDLE hFile, mHandle;
	LPRECORD pRecords = NULL;
	DWORD lowRecordNum, nRecTh,numFiles, iTh;
	LARGE_INTEGER fileSize;
	BOOL noPrint;
	int iFF, iNP;
	PTHREADARG threadArg;
	LPTSTR stringEnd;

	iNP = Options (argc, argv, _T("n"), &noPrint, NULL);
	iFF = iNP + 1;
	numFiles = _ttoi(argv[iNP]);

	if (argc <= iFF)
		ReportError (_T ("Stosowanie: sortMT [opcje] liczbaWatkow pliki"), 1, FALSE);

	/* Otwieranie i odwzorowywanie pliku. */
	hFile = CreateFile (argv[iFF], GENERIC_READ | GENERIC_WRITE,
			0, NULL, OPEN_EXISTING, 0, NULL);
	if (hFile == INVALID_HANDLE_VALUE)
		ReportError (_T ("Nieudane otwieranie pliku wejsciowego."), 2, TRUE);
	// Z przyczyn technicznych trzeba doda bajty na kocu.	
	if (!SetFilePointer(hFile, 2, 0, FILE_END) || !SetEndOfFile(hFile))
		ReportError (_T ("Nieudane okreslanie pozycji."), 3, TRUE);
	
	mHandle = CreateFileMapping(hFile, NULL, PAGE_READWRITE, 0, 0, NULL);
	if (NULL == mHandle)
		ReportError (_T ("Nieudane tworzenie uchwytu odwzorowania dla pliku wejsciowego."), 4, TRUE);
	
	/* Pobieranie rozmiaru pliku. */
	if (!GetFileSizeEx (hFile, &fileSize))
		ReportError (_T ("Blad pobierania rozmiaru pliku."), 5, TRUE);

	nRec = (DWORD)fileSize.QuadPart / RECSIZE;	/* czna liczba rekordw (uwaga na zaoone ograniczenie). */
	nRecTh = nRec / numFiles;	/* Rekordy na wtek. */
	threadArg = malloc (numFiles * sizeof (THREADARG));	/* Tablica argumentw wtku. */ 
	pThreadHandle = malloc (numFiles * sizeof (HANDLE));
	
	/* Odwzorowywanie caego pliku. */
	pRecords = MapViewOfFile(mHandle, FILE_MAP_ALL_ACCESS, 0, 0, 0); 
	if (NULL == pRecords)
		ReportError (_T ("Nieudane odwzorowywanie pliku wejsciowego."), 6, TRUE);
	CloseHandle (mHandle);

	/* Tworzenie wtkw sortujcych. */
	lowRecordNum = 0;
	for (iTh = 0; iTh < numFiles; iTh++) {
		threadArg[iTh].iTh = iTh;
		threadArg[iTh].lowRecord = pRecords + lowRecordNum;
		threadArg[iTh].highRecord = pRecords + (lowRecordNum + nRecTh);
		lowRecordNum += nRecTh;
		pThreadHandle[iTh] = (HANDLE)_beginthreadex (
			NULL, 0, SortThread, &threadArg[iTh], CREATE_SUSPENDED, NULL);
	}

	/* Wznawianie pracy wszystkich pocztkowo zawieszonych wtkw. */

	for (iTh = 0; iTh < numFiles; iTh++)
		ResumeThread (pThreadHandle[iTh]);

	/* Oczekiwanie na zakoczenie pracy przez wtki sortujce przez scalanie. */

	WaitForSingleObject (pThreadHandle[0], INFINITE);
	for (iTh = 0; iTh < numFiles; iTh++)
		CloseHandle (pThreadHandle[iTh]);

	/*  Wywietlanie caego posortowanego pliku traktowanego jak jeden acuch znakw. */

	stringEnd = (LPTSTR) pRecords + nRec*RECSIZE;
	*stringEnd =_T('\0');
	if (!noPrint) {
	    _tprintf (_T("%s"), (LPCTSTR) pRecords); 
	}
	UnmapViewOfFile(pRecords);
	// Przywracanie dugoci pliku.
	if (!SetFilePointer(hFile, -2, 0, FILE_END) || !SetEndOfFile(hFile))
	ReportError (_T("Nieudane przywracanie dlugosci pliku wejsciowego."), 7, TRUE);

	CloseHandle(hFile);
	free (threadArg); free (pThreadHandle);
	return 0;

} /* Koniec funkcji _tmain. */

static VOID MergeArrays (LPRECORD, DWORD);

DWORD WINAPI SortThread (PTHREADARG pThArg)
{
	DWORD groupSize = 2, myNumber, twoToI = 1;
			/* twoToI = 2^i, gdzie i to etap scalania. */
	DWORD_PTR numbersInGroup;
	LPRECORD first;

	myNumber = pThArg->iTh;
	first = pThArg->lowRecord; 
	numbersInGroup = (DWORD)(pThArg->highRecord - first); 

	/* Sortowanie danego fragmentu tablicy. */
	qsort (first, numbersInGroup, RECSIZE, KeyCompare);

	/* Wyjcie z wtku lub oczekiwanie na przylegy wtek. */
	while ((myNumber % groupSize) == 0 && numbersInGroup < nRec) {
				/* Scalanie z przyleg posortowan tablic. */
		WaitForSingleObject (pThreadHandle[myNumber + twoToI], INFINITE);
		MergeArrays (first, numbersInGroup);
		numbersInGroup *= 2;
		groupSize *= 2;
		twoToI *=2;
	}
	return 0;
}

static VOID MergeArrays (LPRECORD p1, DWORD nRecs)
{
	/* Scalanie dwch przylegych tablic (kada ma nRecs rekordw). p1 to pierwszy rekord. */
	DWORD iRec = 0, i1 = 0, i2 = 0;
	LPRECORD pDest, p1Hold, pDestHold, p2 = p1 + nRecs;

	pDest = pDestHold = malloc (2 * nRecs * RECSIZE);
	p1Hold = p1;

	while (i1 < nRecs && i2 < nRecs) {
		if (KeyCompare ((LPCTSTR)p1, (LPCTSTR)p2) <= 0) {
			memcpy (pDest, p1, RECSIZE);
			i1++; p1++; pDest++;
		}
		else {
			memcpy (pDest, p2, RECSIZE);
			i2++; p2++; pDest++;
		}
	}
	if (i1 >= nRecs)
		memcpy (pDest, p2, RECSIZE * (nRecs - i2));
	else	memcpy (pDest, p1, RECSIZE * (nRecs - i1));

	memcpy (p1Hold, pDestHold, 2 * nRecs * RECSIZE);
	free (pDestHold);
	return;
}

int KeyCompare (LPCTSTR pRec1, LPCTSTR pRec2)
{
	DWORD i;
	TCHAR b1, b2;
	LPRECORD p1, p2;
	int Result = 0;

	p1 = (LPRECORD)pRec1;
	p2 = (LPRECORD)pRec2;
	for (i = 0; i < KEYLEN && Result == 0; i++) {
		b1 = p1->key[i];
		b2 = p2->key[i];
		if (b1 < b2) Result = -1;
		if (b1 > b2) Result = +1;
	}
	return  Result;
}
