/* Chapter 7. grepMTx. CELOWO BDNA WERSJA */
/* Rwnolege wykonywanie operacji grep - wersja wielowtkowa. Model wtku gwnego i wtkw roboczych. */

/* grep wzorzec pliki
	Wyszukiwanie wzorca w jednym lub kilku plikach.
	Wyniki s wywietlane w kolejnoci koczenia pracy przez wtki,
	a nie w kolejnoci umieszczania plikw w wierszu polece.
	Ma to przede wszystkim ilustrowa brak determinizmu
	w zakresie koczenia pracy przez wtki. Aby uporzdkowa
	dane wyjciowe, zastosuj technik z rozdzialu 6. */

/* Koniecznie naley zdefiniowa nazw _MT w pliku Environment.h
	lub uy ustawie build...settings...C/C++...CodeGeneration...Multithreaded library. */

#include "Everything.h"

typedef struct {	/* Struktura danych dla wtkw grep. */
	int argc;
	TCHAR targv [4] [MAX_COMMAND_LINE];
} GREP_THREAD_ARG;

typedef GREP_THREAD_ARG *PGR_ARGS;
static DWORD WINAPI ThGrep (PGR_ARGS pArgs);

VOID _tmain (int argc, LPTSTR argv [])

/* Tworzy odrbny WTEK do przeszukiwania kadego pliku z wiersza polece.
	Wywietla wyniki po ich otrzymaniu.
	Kady wtek ma plik tymczasowy na wyniki.
	Jest to zmodyfikowana wersja listingu z rozdziau 6., gdzie wykorzystano procesy. */
{
	PGR_ARGS gArg;		/* Wskazuje tablic argumentw wtku. */ 
	HANDLE * tHandle;	/* Wskazuje tablic uchwytw wtkw. */
	TCHAR CmdLine [MAX_COMMAND_LINE];
	BOOL ok;
	DWORD ThdIdxP, ThId;
	int iThrd, ThdCnt;
	STARTUPINFO StartUp;
	PROCESS_INFORMATION ProcessInfo;

	/* Informacje pocztkowe dla kadego nowego procesu. */

	GetStartupInfo (&StartUp);

	if (argc < 3)
		ReportError (_T ("Brak nazw plikw."), 1, TRUE);
	
	/* Tworzenie odrbnego wtku "grep" dla kadego pliku z wiersza polece.
		Kady wtek otrzymuje te nazw pliku tymczasowego na wyniki.
		Parametr argv[1] to szukany wzorzec. */

	tHandle = malloc ((argc - 2) * sizeof (HANDLE));
	gArg = malloc ((argc - 2) * sizeof (GREP_THREAD_ARG));

	for (iThrd = 0; iThrd < argc - 2; iThrd++) {

			/* Ustawianie: targv[1] na wzorzec
				targv[2] na plik wejciowy
				targv[3] na plik wyjciowy. */

		_tcscpy (gArg [iThrd].targv [1], argv [1]); /* Wzorzec. */
		_tcscpy (gArg [iThrd].targv [2], argv [iThrd + 2]); /* Przeszukiwany plik. */

		if (GetTempFileName	/* Nazwa pliku tymczasowego. */
				(".", "Gre", 0,	gArg [iThrd].targv [3]) == 0)
			ReportError (_T ("Temp file failure."), 3, TRUE);

		/* Plik wyjciowy. */

		gArg [iThrd].argc = 4;

		/* Tworzenie wtku do wykonywania instrukcji z wiersza polece. */

		tHandle [iThrd] = CreateThread (
				NULL, 0, ThGrep, &gArg[iThrd], 0, ThId);

		if (tHandle [iThrd] == 0)
			ReportError (_T ("Blad przy tworzeniu watku."), 4, TRUE);
	}

	/* Wszystkie wtki robocze dziaaj. Naley czeka na ukoczenie
	    kadego z nich i wywietla wyniki. */
	/*  Przekierowywanie danych wyjciowych dla procesu "cat" wywietlajcego wyniki. */

	StartUp.dwFlags = STARTF_USESTDHANDLES;
	StartUp.hStdOutput = GetStdHandle (STD_OUTPUT_HANDLE);
	StartUp.hStdError = GetStdHandle (STD_ERROR_HANDLE);

	ThdCnt = argc - 2;
	while (ThdCnt > 0) {
		ThdIdxP = WaitForMultipleObjects (ThdCnt, tHandle, TRUE, INFINITE);
		iThrd = (int) ThdIdxP - (int) WAIT_OBJECT_0;
		if (iThrd < 0 || iThrd >= ThdCnt)
			ReportError (_T ("Thread wait error."), 5,TRUE);
		CloseHandle (tHandle [iThrd]);
		
		/* Wywietlanie zawartoci pliku (jeli dopasowano wzorzec)
			i oczekiwanie na zakoczenie pracy przez nastpny wtek. */

		if (GetCompressedFileSize (gArg [iThrd].targv [3], NULL) > 2) {
			if (argc > 3) {		/* Wywietlanie nazwy pliku, jeli jest ich kilka. */
				_tprintf (_T ("**Wyniki wyszukiwania - plik: %s\n"),
						gArg [iThrd].targv [2]);
				fflush (stdout);
			}
			_stprintf (CmdLine, _T ("%s%s"), _T ("cat "), 
						gArg [iThrd].targv [3]);

			ok = CreateProcess (NULL, CmdLine, NULL, NULL,
					TRUE, 0, NULL, NULL, &StartUp, &ProcessInfo);

			if (!ok) ReportError (_T ("Blad programu cat."), 6, TRUE);
			WaitForSingleObject (ProcessInfo.hProcess, INFINITE);
			CloseHandle (ProcessInfo.hProcess);
			CloseHandle (ProcessInfo.hThread);
		}

		if (!DeleteFile (gArg [iThrd].targv [3]))
			ReportError (_T ("Nie mozna usunac pliku tymczasowego."), 7, TRUE);

		/* Przenoszenie uchwytu ostatniego wtku na pozycj 
			zajmowan przez wtek, ktry wacie zakoczy prac,
			i zmniejszanie liczby wtkw. To samo naley zrobi dla
			nazw plikw tymczasowych. */

		tHandle [iThrd] = tHandle [ThdCnt - 1];
		_tcscpy (gArg [iThrd].targv [3], gArg [ThdCnt - 1].targv [3]);
		_tcscpy (gArg [iThrd].targv [2], gArg [ThdCnt - 1].targv [2]);
		ThdCnt--;
	}
	free (tHandle);
	free (gArg);
}

/* Poniej znajduje si kod rdowy programu grep. Pominito go w tekcie. */
/* Kod ten ma nastpujca posta:
	static DWORD WINAPI ThGrep (GR_ARGS pArgs)
	{
	}
*/
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

/*	grep w postaci funkcji wykonywanej przez wtek. */
/*	Copyright 1995, Alan R. Feuer. */
/*	Zmodyfikowana wersja: nazwy pliku wejciowego i wyjciowego
    pochodz ze struktury danych z argumentu.
    Funkcja uywa biblioteki jzyka C, dlatego trzeba j wywoa 
	za pomoc funkcji _beginthreadex. */

/*	grep wzorzec pliki
Wyszukuje wzorzec w plikach. Plik jest przegldany wiersz po wierszu.

Dostpne metaznaki:
*	Pasuje do zera lub wicej znakw
?	Pasuje do dokadnie jednego znaku
[...]	Okrela klas znakw i
pasuje do dowolnego znaku z klasy
^	Pasuje do pocztku wiersza
$	Pasuje do koca wiersza

Ponadto obsugiwane s standardowe sekwencje ucieczki z jzyka C:
	\a, \b, \f, \t, \v */

/*	Kody metaznakw ze wzorcw. */

#define ASTRSK		1
#define QM		2
#define BEGCLASS	3
#define ENDCLASS	4
#define ANCHOR		5

FILE * openFile (char *, char *);
void prepSearchString (char *, char *);

BOOL patternMatch (char *,char *);

/* Inne kody i definicje. */

#define EOS '\0'

/* Opcje dopasowywania wzorca. */
static int patternSeen = FALSE;
static BOOL ignoreCase = FALSE;

static DWORD WINAPI ThGrep (PGR_ARGS pArgs)
{
	char *file;
	int i, showName = FALSE, argc;
	char pattern [256];
	char string [2048];
	TCHAR argv [4] [MAX_COMMAND_LINE];
	FILE *fp, *fpout;

	argc = pArgs->argc;
	_tcscpy (argv [1], pArgs->targv [1]);
	_tcscpy (argv [2], pArgs->targv [2]);
	_tcscpy (argv [3], pArgs->targv [3]);
	if (argc < 3 ) {
		puts ("Stosowanie: grep plik_wyjsciowy wzorzec pliki");
		exit(0);
	}

	/* Otwieranie pliku wyjciowego. */

	fpout = openFile (file = argv [argc - 1],"wb");
	if (fpout == NULL) {
		printf ("Nie mozna otworzyc pliku wyjsciowego.");
		exit (1);
	}

	for (i = 1; i < argc - 1; ++i ) {
		if (argv [i] [0] == '-' ) {
			switch (argv [i] [1] ) {
				case 'y':
					ignoreCase = TRUE;
					break;
				}
		} else {
			if (!patternSeen++)
				prepSearchString (argv [i], pattern);
			else if ((fp = openFile (file = argv [i], "rb"))
					!= NULL ) {
				if (!showName && i < argc - 2 ) ++showName;
				while (fgets (string, sizeof (string), fp)
						!= NULL && !feof (fp)) {
					if (ignoreCase) _strlwr (string);
					if (patternMatch (pattern, string))
						if (showName) {
							fputs (file,fpout);
							fputs (string, fpout);
					} else fputs (string, fpout);
				}
				fclose (fp);
				fclose (fpout);
			}
		}
	}
	return 0;
}

static FILE *
openFile (char * file, char * mode)
{
	FILE *fp;

	/* printf ("Otwieranie pliku: %s", file); */

	if ((fp = fopen (file, mode)) == NULL )
		perror (file);
	return (fp);
}

static void
prepSearchString (char *p, char *buf)

/* Kopiowanie szukanego acucha do bufora. */
{
	register int c;
	register int i = 0;

	if (*p == '^' ) {
		buf [i++] = ANCHOR;
		++p;
	}

	for(;;) {
		switch (c = *p++) {
		case EOS: goto Exit;
		case '*': if (i >= 0 && buf [i - 1] != ASTRSK)
				c = ASTRSK; break;
		case '?': c = QM; break;
		case '[': c = BEGCLASS; break;
		case ']': c = ENDCLASS; break;

		case '\\':
			switch (c = *p++) {
			case EOS: goto Exit;
			case 'a': c = '\a'; break;
			case 'b': c = '\b'; break;
			case 'f': c = '\f'; break;
			case 't': c = '\t'; break;
			case 'v': c = '\v'; break;
			case '\\': c = '\\'; break;
			}
			break;
		}

		buf [i++] = (ignoreCase ? tolower (c) : c);
	}

Exit:
	buf [i] = EOS;
}

static BOOL
patternMatch (char *pattern, char *string)

	/* Zwraca TRUE, jeli acuch pasuje do wzorca. */
{
	register char pc, sc;
	char *pat;
	BOOL anchored;

	if (anchored = (*pattern == ANCHOR))
		++pattern;

Top:			
	pat = pattern;

Again:
	pc = *pat;
	sc = *string;

	if (sc == '\n' || sc == EOS ) {
				/* Na kocu wiersza lub tekstu. */
		if (pc == EOS ) goto Success;
		else if (pc == ASTRSK ) {
				/* patternMatch (pat + 1,base, index, end) */
			++pat;
			goto Again;
		} else return (FALSE);
	} else {
		if (pc == sc || pc == QM ) {
					/* patternMatch (pat + 1,string + 1) */
			++pat;
			++string;
			goto Again;
		} else if (pc == EOS) goto Success;
		else if (pc == ASTRSK ) {
			if (patternMatch (pat + 1,string)) goto Success;
			else {
					/* patternMatch (pat, string + 1) */
				++string;
				goto Again;
			}
		} else if (pc == BEGCLASS ) { /* Klasa znakw. */
			BOOL clmatch = FALSE;
			while (*++pat != ENDCLASS ) {
				if (!clmatch && *pat == sc ) clmatch = TRUE;
			}
			if (clmatch) {
				++pat;
				++string;
				goto Again;
			}
		}
	}

	if (anchored) return (FALSE);

	++string;
	goto Top;

Success:
	return (TRUE);
}

	

