/* Chapter 7. grepMT. */
/* Rwnolege wykonywanie operacji grep - wersja wielowtkowa. */

/* grep wzorzec pliki
	Wyszukiwanie wzorca w jednym lub kilku plikach.
	Wyniki s wywietlane w kolejnoci koczenia pracy przez wtki,
	a nie w kolejnoci umieszczania plikw w wierszu polece.
	Ma to przede wszystkim ilustrowa brak determinizmu
	w zakresie koczenia pracy przez wtki. Aby uporzdkowa
	dane wyjciowe, zastosuj technik z rozdzialu 6. */

/* Koniecznie naley zdefiniowa nazw _MT w pliku Environment.h
	lub uy ustawie build...settings...C/C++...CodeGeneration...Multithreaded library. */

#include "Everything.h"

typedef struct {	/* Struktura danych dla wtkw grep. */
	int argc;
	TCHAR targv[4][MAX_COMMAND_LINE];
} GREP_THREAD_ARG;

typedef GREP_THREAD_ARG *PGR_ARGS;
static DWORD WINAPI ThGrep (PGR_ARGS pArgs);

VOID _tmain (int argc, LPTSTR argv[])

/* Tworzy odrbny WTEK do przeszukiwania kadego pliku z wiersza polece.
	Wywietla wyniki po ich otrzymaniu.
	Kady wtek ma plik tymczasowy na wyniki.
	Jest to zmodyfikowana wersja listingu z rozdziau 6., gdzie wykorzystano procesy. */
{
	PGR_ARGS gArg;		/* Wskazuje tablic argumentw wtku. */ 
	HANDLE * tHandle;	/* Wskazuje tablic uchwytw wtkw. */
	TCHAR commandLine[MAX_COMMAND_LINE];
	BOOL ok;
	DWORD threadIndex, exitCode;
	int iThrd, threadCount;
	STARTUPINFO startUp;
	PROCESS_INFORMATION processInfo;

	/* Informacje pocztkowe dla kadego nowego procesu. */

	GetStartupInfo (&startUp);

	if (argc < 3)
		ReportError (_T ("Brak nazw plikow."), 1, TRUE);
	
	/* Tworzenie odrbnego wtku "grep" dla kadego pliku z wiersza polece.
		Kady wtek otrzymuje te nazw pliku tymczasowego na wyniki.
		Parametr argv[1] to szukany wzorzec. */

	tHandle = malloc ((argc - 2) * sizeof (HANDLE));
	gArg = malloc ((argc - 2) * sizeof (GREP_THREAD_ARG));

	for (iThrd = 0; iThrd < argc - 2; iThrd++) {

			/* Ustawianie: targv[1] na wzorzec
				targv[2] na plik wejciowy
				targv[3] na plik wyjciowy. */

		_tcscpy (gArg[iThrd].targv[1], argv[1]); /* Wzorzec. */
		_tcscpy (gArg[iThrd].targv[2], argv[iThrd + 2]); /* Przeszukiwany plik. */

		if (GetTempFileName	/* Nazwa pliku tymczasowego. */
				(".", "Gre", 0,	gArg[iThrd].targv[3]) == 0)
			ReportError (_T ("Blad pliku tymczasowego."), 3, TRUE);

		/* Plik wyjciowy. */

		gArg[iThrd].argc = 4;

		/* Tworzenie wtku do wykonywania instrukcji z wiersza polece. */

		tHandle[iThrd] = (HANDLE)_beginthreadex (
				NULL, 0, ThGrep, &gArg[iThrd], 0, NULL);

		if (tHandle[iThrd] == 0)
			ReportError (_T ("Blad przy tworzeniu watku."), 4, TRUE);
	}

	/* Wszystkie wtki robocze dziaaj. Naley czeka na ukoczenie
	    kadego z nich i wywietla wyniki. */
	/*  Przekierowywanie danych wyjciowych dla procesu "cat" wywietlajcego wyniki. */

	startUp.dwFlags = STARTF_USESTDHANDLES;
	startUp.hStdOutput = GetStdHandle (STD_OUTPUT_HANDLE);
	startUp.hStdError = GetStdHandle (STD_ERROR_HANDLE);

	threadCount = argc - 2;
	while (threadCount > 0) {
		threadIndex = WaitForMultipleObjects (threadCount, tHandle, FALSE, INFINITE);
		iThrd = (int) threadIndex - (int) WAIT_OBJECT_0;
		if (iThrd < 0 || iThrd >= threadCount)
			ReportError (_T ("Blad przy oczekiwaniu na watek."), 5,TRUE);
		GetExitCodeThread (tHandle[iThrd], &exitCode);
		CloseHandle (tHandle[iThrd]);
		
		/* Wywietlanie zawartoci pliku (jeli dopasowano wzorzec)
			i oczekiwanie na zakoczenie pracy przez nastpny wtek. */

		if (exitCode == 0) {
			if (argc > 3) {		/* Wywietlanie nazwy pliku, jeli jest ich kilka. */
				_tprintf (_T ("%s\n"),
						gArg[iThrd].targv[2]);
				fflush (stdout);
			}

			_stprintf (commandLine, _T ("cat \"%s\""), gArg[iThrd].targv[3]);

			ok = CreateProcess (NULL, commandLine, NULL, NULL,
					TRUE, 0, NULL, NULL, &startUp, &processInfo);

			if (!ok) ReportError (_T ("Blad programu cat."), 6, TRUE);
			WaitForSingleObject (processInfo.hProcess, INFINITE);
			CloseHandle (processInfo.hProcess);
			CloseHandle (processInfo.hThread);
		}

		if (!DeleteFile (gArg[iThrd].targv[3]))
			ReportError (_T ("Nie mozna usunac pliku tymczasowego."), 7, TRUE);

		/* Przenoszenie uchwytu ostatniego wtku na pozycj 
			zajmowan przez wtek, ktry wacie zakoczy prac,
			i zmniejszanie liczby wtkw. To samo naley zrobi dla
			nazw plikw tymczasowych. */

		tHandle[iThrd] = tHandle[threadCount - 1];
		_tcscpy (gArg[iThrd].targv[3], gArg[threadCount - 1].targv[3]);
		_tcscpy (gArg[iThrd].targv[2], gArg[threadCount - 1].targv[2]);
		threadCount--;
	}
	free (tHandle);
	free (gArg);
}

/* Poniej znajduje si kod rdowy programu grep. Pominito go w tekcie. */
/* Kod ten ma nastpujca posta:
	static DWORD WINAPI ThGrep (GR_ARGS pArgs)
	{
	}
*/
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

/*	grep w postaci funkcji wykonywanej przez wtek. */
/*	Copyright 1995, Alan R. Feuer. */
/*	Zmodyfikowana wersja: nazwy pliku wejciowego i wyjciowego
    pochodz ze struktury danych z argumentu.
    Funkcja uywa biblioteki jzyka C, dlatego trzeba j wywoa 
	za pomoc funkcji _beginthreadex.
*/

/*	grep wzorzec pliki
Wyszukuje wzorzec w plikach. Plik jest przegldany wiersz po wierszu.

Dostpne metaznaki:
*	Pasuje do zera lub wicej znakw
?	Pasuje do dokadnie jednego znaku
[...]	Okrela klas znakw i
pasuje do dowolnego znaku z klasy
^	Pasuje do pocztku wiersza
$	Pasuje do koca wiersza

Ponadto obsugiwane s standardowe sekwencje ucieczki z jzyka C:
	\a, \b, \f, \t, \v */

/*	Kody metaznakw ze wzorcw. */

#define ASTRSK		1
#define QM		2
#define BEGCLASS	3
#define ENDCLASS	4
#define ANCHOR		5

FILE * openFile (char *, char *);
void prepSearchString (char *, char *);

BOOL patternMatch (char *,char *);

/* Inne kody i definicje. */

#define EOS _T('\0')

/* Opcje dopasowywania wzorca. */

static BOOL ignoreCase = FALSE;

static DWORD WINAPI ThGrep (PGR_ARGS pArgs)
{

	char *file;
	int i, patternSeen = FALSE, showName = FALSE, argc, result = 1;
	char pattern[256];
	char string[2048];
	TCHAR argv[4][MAX_COMMAND_LINE];
	FILE *fp, *fpout;

	argc = pArgs->argc;
	_tcscpy (argv[1], pArgs->targv[1]);
	_tcscpy (argv[2], pArgs->targv[2]);
	_tcscpy (argv[3], pArgs->targv[3]);
	if (argc < 3 ) {
		puts ("Stosowanie: grep plik_wyjsciowy wzorzec pliki");
		return 1;
	}

	/* Otwieranie pliku wyjciowego. */

	fpout = openFile (file = argv[argc - 1],"wb");
	if (fpout == NULL) {
		printf ("Nie mozna otworzyc pliku wyjsciowego.");
		return 1;
	}

	for (i = 1; i < argc - 1; ++i ) {
		if (argv[i][0] == _T('-') ) {
			switch (argv[i][1] ) {
				case _T('y'):
					ignoreCase = TRUE;
					break;
				}
		} else {
			if (!patternSeen++)
				prepSearchString (argv[i], pattern);
			else if ((fp = openFile (file = argv[i], _T("rb")))
					!= NULL ) {
				if (!showName && i < argc - 2 ) ++showName;
				while (fgets (string, sizeof (string), fp)
						!= NULL && !feof (fp)) {
					if (ignoreCase) _strlwr (string);
					if (patternMatch (pattern, string)) {
						result = 0;
						if (showName) {
							fputs (file,fpout);
							fputs (string, fpout);
						} else fputs (string, fpout);
					}
				}
				fclose (fp);
				fclose (fpout);
			}
		}
	}
	return result;
}

static FILE *
openFile (char * file, char * mode)
{
	FILE *fp;

	/* printf ("Otwieranie pliku: %s", file); */

	if ((fp = fopen (file, mode)) == NULL )
		perror (file);
	return (fp);
}

static void
prepSearchString (char *p, char *buf)

/* Kopiowanie szukanego acucha do bufora. */
{
	register int c;
	register int i = 0;

	if (*p == _T('^') ) {
		buf[i++] = ANCHOR;
		++p;
	}

	for(;;) {
		switch (c = *p++) {
		case EOS: goto Exit;
		case _T('*'): if (i >= 0 && buf[i - 1] != ASTRSK)
				c = ASTRSK; break;
		case _T('?'): c = QM; break;
		case _T('['): c = BEGCLASS; break;
		case _T(']'): c = ENDCLASS; break;

		case _T('\\'):
			switch (c = *p++) {
			case EOS: goto Exit;
			case _T('a'): c = _T('\a'); break;
			case _T('b'): c = _T('\b'); break;
			case _T('f'): c = _T('\f'); break;
			case _T('t'): c = _T('\t'); break;
			case _T('v'): c = _T('\v'); break;
			case _T('\\'): c = _T('\\'); break;
			}
			break;
		}

		buf[i++] = (ignoreCase ? tolower (c) : c);
	}

Exit:
	buf[i] = EOS;
}

static BOOL
patternMatch (char *pattern, char *string)

	/* Zwraca TRUE, jeli acuch pasuje do wzorca. */
{
	register char pc, sc;
	char *pat;
	BOOL anchored;

	if (anchored = (*pattern == ANCHOR))
		++pattern;

Top:			
	pat = pattern;

Again:
	pc = *pat;
	sc = *string;

	if (sc == _T('\n') || sc == EOS ) {
				/* Na kocu wiersza lub tekstu. */
		if (pc == EOS ) goto Success;
		else if (pc == ASTRSK ) {
				/* patternMatch (pat + 1,base, index, end) */
			++pat;
			goto Again;
		} else return (FALSE);
	} else {
		if (pc == sc || pc == QM ) {
					/* patternMatch (pat + 1,string + 1) */
			++pat;
			++string;
			goto Again;
		} else if (pc == EOS) goto Success;
		else if (pc == ASTRSK ) {
			if (patternMatch (pat + 1,string)) goto Success;
			else {
					/* patternMatch (pat, string + 1) */
				++string;
				goto Again;
			}
		} else if (pc == BEGCLASS ) { /* Klasa znakw. */
			BOOL clmatch = FALSE;
			while (*++pat != ENDCLASS ) {
				if (!clmatch && *pat == sc ) clmatch = TRUE;
			}
			if (clmatch) {
				++pat;
				++string;
				goto Again;
			}
		}
	}

	if (anchored) return (FALSE);

	++string;
	goto Top;

Success:
	return (TRUE);
}

