/* Rozdzia 6. version. Wywietlanie informacji o wersji systemu. */
#include "Everything.h"

int _tmain (int argc, LPTSTR argv[])
{
	OSVERSIONINFO OSVer;
	SYSTEM_INFO SysInfo;
	DWORD SysAffinMask = 0, ProcAffinMask = 0;
	DWORD sectorsPerCluster, bytesPerSector, numberOfFreeClusters, totalNumberOfClusters;
/* Dla informacji - tak wyglda struktura OSVERSIONINFO.
typedef struct _OSVERSIONINFO{ 
    DWORD dwOSVersionInfoSize; 
    DWORD dwMajorVersion; 
    DWORD dwMinorVersion; 
    DWORD dwBuildNumber; 
    DWORD dwPlatformId; 
    TCHAR szCSDVersion[ 128 ]; 
} OSVERSIONINFO; 
*/ 

	/* Okrelanie informacji o wersji.  */
	OSVer.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);
	if (!GetVersionEx (&OSVer)) 
		_tprintf (_T("Cannot get OS Version info. %d"), GetLastError());

	_tprintf (_T("Glowna wersja:            %d\n"), OSVer.dwMajorVersion);
	_tprintf (_T("Podwersja:                %d\n"), OSVer.dwMinorVersion);
	_tprintf (_T("Nr kompilacji:            %d\n"), OSVer.dwBuildNumber);
	_tprintf (_T("Ident. platformy:         %d\n"), OSVer.dwPlatformId);
	_tprintf (_T("Czy platforma to NT?(0/1) %d\n"), (OSVer.dwPlatformId == VER_PLATFORM_WIN32_NT));
	_tprintf (_T("Service Pack:             %s\n"), OSVer.szCSDVersion);
	_tprintf (_T("\n"));

/* Dla informacji - oto struktura SYSTEM_INFO.
typedef struct _SYSTEM_INFO { // sinf 
    union { 
        DWORD  dwOemId; 
        struct { 
            WORD wProcessorArchitecture; 
            WORD wReserved; 
        }; 
    }; 
    DWORD  dwPageSize; 
    LPVOID lpMinimumApplicationAddress; 
    LPVOID lpMaximumApplicationAddress; 
    DWORD  dwActiveProcessorMask; 
    DWORD  dwNumberOfProcessors; 
    DWORD  dwProcessorType; 
    DWORD  dwAllocationGranularity; 
    WORD  wProcessorLevel; 
    WORD  wProcessorRevision; 
} SYSTEM_INFO; 
*/
	GetSystemInfo (&SysInfo);
	_tprintf (_T("Ident. OEM:          %d\n"), SysInfo.dwOemId);
	_tprintf (_T("Arch. procesora:     %d\n"), SysInfo.wProcessorArchitecture);
	_tprintf (_T("Rozmiar strony:      %x\n"), SysInfo.dwPageSize);
	_tprintf (_T("Min. adr. apl.:      %p\n"), SysInfo.lpMinimumApplicationAddress);
	_tprintf (_T("Maks. adr. apl.:     %p\n"), SysInfo.lpMaximumApplicationAddress);
	_tprintf (_T("Maska procesora:     %x\n"), SysInfo.dwActiveProcessorMask);
	_tprintf (_T("Liczba procesorow:   %d\n"), SysInfo.dwNumberOfProcessors);
	_tprintf (_T("Typ procesora:       %d\n"), SysInfo.dwProcessorType);
	_tprintf (_T("Ziar. przydzialu:    %x\n"), SysInfo.dwAllocationGranularity);
	_tprintf (_T("Poziom procesora:    %d\n"), SysInfo.wProcessorLevel);
	_tprintf (_T("Wersja procesora:    %d\n"), SysInfo.wProcessorRevision);	

	_tprintf (_T("\n"));
	GetProcessAffinityMask (GetCurrentProcess(), (PDWORD_PTR)&ProcAffinMask, (PDWORD_PTR)&SysAffinMask);
	_tprintf (_T("Sys.  maska koligacji  %x\n"), SysAffinMask);
	_tprintf (_T("Proc. maska koligacji  %x\n"), ProcAffinMask);

	/* Pobieranie informacji o uywanym dysku. */
	/* Ostrzeenie: dokumentacja MSND zaleca stosowanie funkcji GetDiskFreeSpaceEx dla dyskw wikszych ni 2GB, co oznacza */
	/* prawie kady dysk twardy. Jednak funkcja ta nie zwraca informacji o klastrach i sektorze. */
	/* Funkcja GetDiskFreeSpace dziaa jednak poprawnie w systemach Vista i Windows 7 dla duych dyskw (najwikszy, 
	   jaki wyprbowaem, mia 640 GB). */
	GetDiskFreeSpace(NULL, &sectorsPerCluster, &bytesPerSector, &numberOfFreeClusters, &totalNumberOfClusters);
	_tprintf (_T("\n"));
	_tprintf (_T("Informacje o uzywanym dysku.\n"));
	_tprintf (_T("Sektory na klaster:      %d.\n"), sectorsPerCluster);
	_tprintf (_T("Bajty na sektor:         %d.\n"), bytesPerSector);
	_tprintf (_T("Liczba wolnych klastrow: %d.\n"), numberOfFreeClusters);
	_tprintf (_T("Laczna liczba klastrow:  %d.\n"), totalNumberOfClusters);

	return 0;
}
