/* Rozdzia 6. timep. Uproszczona wersja bez specjalnych 
	funkcji pomocniczych lub plikw nagwkowych.  */

/* timep: wykonuje instrukcje z wiersza polece i wywietla
	potrzebny na to czas (rzeczywisty, systemowy i uytkownika). */

/* Ten program ilustruje:
	1. Tworzenie procesw.
	2. Pobieranie wiersza polece.
	3. Pobieranie czasw.
	4. Przeksztacanie czasw dla plikw na czasy systemowe.
	5. Wywietlanie czasu systemowego.
		Tylko dla systemu Windows. */

#include "Everything.h"

int _tmain (int argc, LPTSTR argv[])
{
	STARTUPINFO startUp;
	PROCESS_INFORMATION procInfo;
	union {		/* Struktura potrzebna na arytmetyk na czasie dla plikw. */
		LONGLONG li;
		FILETIME ft;
	} createTime, exitTime, elapsedTime;

	FILETIME kernelTime, userTime;
	SYSTEMTIME elTiSys, keTiSys, usTiSys;
	LPTSTR targv = SkipArg (GetCommandLine ());
	OSVERSIONINFO windowsVersion;
	HANDLE hProc;

	/*  Przechodzenie do wiersza polece poza pierwszy ograniczony odstpem element.
		Oglniejsze rozwizanie uwzgldnia znaki tabulacji i nowego wiersza. */
	if (argc <= 1) 
		ReportError (_T("Stosowanie: timep polecenie ..."), 1, FALSE);

	/* Sprawdzanie, czy jest to system Windows 2000 czy NT.  */
	windowsVersion.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);
	if (!GetVersionEx (&windowsVersion)) 
		ReportError (_T("Nie mozna pobrac informacji o systemie operacyjnym. %d"), 2, TRUE);

	if (windowsVersion.dwPlatformId != VER_PLATFORM_WIN32_NT)
		ReportError (_T("Ten program dziala tylko w systemach NT."), 2, FALSE);

	GetStartupInfo (&startUp);

	/* Wykonywanie instrukcji z wiersza polece i oczekiwanie na zakoczenie pracy przez proces. */
	if (!CreateProcess (NULL, targv, NULL, NULL, TRUE,
		NORMAL_PRIORITY_CLASS, NULL, NULL, &startUp, &procInfo)) 
		ReportError (_T ("\nBlad uruchamiania procesu. %d"), 3, TRUE);
	hProc = procInfo.hProcess;
	if (WaitForSingleObject (hProc, INFINITE) != WAIT_OBJECT_0) 
		ReportError (_T("Nieudane oczekiwanie na zakonczenie pracy przez proces. %d"), 5, TRUE);;

	if (!GetProcessTimes (hProc, &createTime.ft,
		&exitTime.ft, &kernelTime, &userTime)) 
			ReportError (_T("Nie mozna pobrac czasu pracy procesu. %d"), 6, TRUE);

	elapsedTime.li = exitTime.li - createTime.li;
	FileTimeToSystemTime (&elapsedTime.ft, &elTiSys);
	FileTimeToSystemTime (&kernelTime, &keTiSys);
	FileTimeToSystemTime (&userTime, &usTiSys);
	_tprintf (_T ("Czas rzeczywisty: %02d:%02d:%02d.%03d\n"),
		elTiSys.wHour, elTiSys.wMinute, elTiSys.wSecond,
		elTiSys.wMilliseconds);
	_tprintf (_T ("Czas uzytkownika: %02d:%02d:%02d.%03d\n"),
		usTiSys.wHour, usTiSys.wMinute, usTiSys.wSecond,
		usTiSys.wMilliseconds);
	_tprintf (_T ("Czas systemowy:  %02d:%02d:%02d.%03d\n"),
		keTiSys.wHour, keTiSys.wMinute, keTiSys.wSecond,
		keTiSys.wMilliseconds);

	CloseHandle (procInfo.hThread); CloseHandle (procInfo.hProcess);
	return 0;
}
