/*	Rozdzia 6. */
/* JobObjectShell.c. Jeden program czcy trzy polecenia do
zarzdzania zadaniami:
	Jobbg	- uruchamia zadanie w tle
	jobs	- wywietla wszystkie zadania dziaajce w tle
	kill	- koczy okrelone zadanie.
			  Dostpna jest opcja do generowania sygnaw sterujcych konsoli.
	Ta implementacja wzbogaca program JobShell o limit czasu dla kadego procesu.
		Wystpuje limit czasu dla kadego procesu (w sekundach) w paramterze argv[1] (jeli jest podany).
		0 lub brak parametru oznacza brak limitu.
*/

#include "Everything.h"
#include "JobManagement.h"

#define MILLION 1000000
static int Jobbg (int, LPTSTR *, LPTSTR);
static int Jobs  (int, LPTSTR *, LPTSTR);
static int Kill  (int, LPTSTR *, LPTSTR);
HANDLE hJobObject = NULL;

JOBOBJECT_BASIC_LIMIT_INFORMATION basicLimits = {0, 0, JOB_OBJECT_LIMIT_PROCESS_TIME};

int _tmain (int argc, LPTSTR argv[])
{
	LARGE_INTEGER processTimeLimit;
	BOOL exitFlag = FALSE;
	TCHAR command[MAX_COMMAND_LINE], *pc;
	DWORD i, localArgc;
	TCHAR argstr[MAX_ARG][MAX_COMMAND_LINE];
	LPTSTR pArgs[MAX_ARG];
	
	/* Tylko systemy NT - z uwagi na blokady plikw. */
	if (!WindowsVersionOK (3, 1)) 
		ReportError (_T("Ten program wymaga systemu Windows NT 3.1 lub nowszego."), 1, FALSE);
	hJobObject = NULL;
	processTimeLimit.QuadPart = 0;
	if (argc >= 2) processTimeLimit.QuadPart = _ttoi(argv[1]);
	basicLimits.PerProcessUserTimeLimit.QuadPart = processTimeLimit.QuadPart * MILLION;

	hJobObject = CreateJobObject(NULL, NULL);
	if (NULL == hJobObject)
		ReportError(_T("Blad tworzenia obiektu zadania."), 1, TRUE);
	if (!SetInformationJobObject(hJobObject, JobObjectBasicLimitInformation, &basicLimits, sizeof(JOBOBJECT_BASIC_LIMIT_INFORMATION)))
		ReportError(_T("Blad ustawiania informacji o obiekcie zadania."), 2, TRUE);

	for (i = 0; i < MAX_ARG; i++)
		pArgs[i] = argstr[i];

	_tprintf (_T("Zarzadzanie zadaniami w systemie Windows za pomoca obiektu zadania.\n"));
	while (!exitFlag) {
		_tprintf (_T("%s"), _T("JM$"));
		_fgetts (command, MAX_COMMAND_LINE, stdin);
		pc = _tcschr (command, _T('\n'));
		*pc = _T('\0');

		GetArgs (command, &localArgc, pArgs);
		CharLower (argstr[0]);

		if (_tcscmp (argstr[0], _T("jobbg")) == 0) {
			Jobbg (localArgc, pArgs, command);
		}
		else if (_tcscmp (argstr[0], _T("jobs")) == 0) {
			Jobs (localArgc, pArgs, command);
		}
		else if (_tcscmp (argstr[0], _T("kill")) == 0) {
			Kill (localArgc, pArgs, command);
		}
		else if (_tcscmp (argstr[0], _T("quit")) == 0) {
			exitFlag = TRUE;
		}
		else _tprintf (_T("Niedozwolone polecenie. Sprobuj ponownie.\n"));
	}

	CloseHandle (hJobObject);

	return 0;
}

/* Jobbg: wykonywanie wiersza polece w tle, umieszczanie danych
	identyfikacyjnych zadania w pliku zada i koczenie pracy.
	Do zarzdzania zadaniami mona uy powizanych polece (jobs, fg, kill i suspend). */

/* jobbg [opcje] wiersz_polece
		-c: udostpnia konsol nowemu procesowi.
		-d: nowy proces jest odczony od konsoli.
	Te dwie opcje wzajemnie si wykluczaj.
	Jeli uytkownik nie ustawi adnej z nich, proces dziaajcy w tle korzysta
	z tej samej konsoli, co program jobbg. */

/* Nowe mechanizmy programu ilustruj:
		1. Tworzenie odczonych procesw i procesw z odrbnymi konsolami.
		2. Przechowywanie listy zada i procesw we wsplnym pliku.
		3. Okrelanie stanu procesu na podstawie ID procesu.*/

/* Standardowe pliki doczane. */
/* - - - - - - - - - - - - - - - - - - - - - - - - - */

int Jobbg (int argc, LPTSTR argv[], LPTSTR command)
{
	/*	Przetwarzanie wiersza polece podobnie jak w programie timep.c. */
	/*	- - - - - - - - - - - - - - - - - - - - - - */
	/*	Wykonywanie wiersza polece (targv) i zapisywanie ID zadania,
		ID procesu oraz uchwytu w pliku zada. */

	DWORD fCreate;
	LONG jobNumber;
	BOOL flags[2];

	STARTUPINFO startUp;
	PROCESS_INFORMATION processInfo;
	LPTSTR targv = SkipArg (command);
	
	GetStartupInfo (&startUp);

		/* Okrelanie opcji. */
	Options (argc, argv, _T ("cd"), &flags[0], &flags[1], NULL);

		/* Pomijanie take pola opcji (jeli je podano). */
		/* Upraszczajce zaoenia: wystpuje tylko jedna z opcji -d lub -c (wykluczaj si wzajemnie),
		   a polecenia nie zaczynaj si od znaku - itd. Czytelnik moe zechcie to poprawi. */
	if (argv[1][0] == _T('-'))
		targv = SkipArg (targv);

	fCreate = flags[0] ? CREATE_NEW_CONSOLE : flags[1] ? DETACHED_PROCESS : 0;

		/* Tworzenie zawieszonego zadania lub wtku.
			Wznawianie po prawidowym zapisaniu zadania. */
	if (!CreateProcess (NULL, targv, NULL, NULL, TRUE,
			fCreate | CREATE_SUSPENDED | CREATE_NEW_PROCESS_GROUP,
			NULL, NULL, &startUp, &processInfo)) {
		ReportError (_T ("Blad uruchamiania procesu."), 0, TRUE);
	}
	if (hJobObject != NULL)
	{
		if (!AssignProcessToJobObject(hJobObject, processInfo.hProcess)) {
			ReportError(_T("Nie mozna dodac procesu do obiektu zadania. Proces zostanie zakonczony."), 0, TRUE);
			TerminateProcess (processInfo.hProcess, 4);
			CloseHandle (processInfo.hThread);
			CloseHandle (processInfo.hProcess);
			return 4;
		}
	}

		/* Tworzenie numeru zadania i wprowadzanie ID procesu oraz uchwytu 
			do "bazy danych" zadania zarzdzanej przez funkcj
			GetJobNumber (jest ona czci biblioteki do zarzdzania zadaniami). */
	
	jobNumber = GetJobNumber (&processInfo, targv);
	if (jobNumber >= 0)
		ResumeThread (processInfo.hThread);
	else {
		TerminateProcess (processInfo.hProcess, 3);
		CloseHandle (processInfo.hThread);
		CloseHandle (processInfo.hProcess);
		ReportError (_T ("Blad: brak miejsca na liscie zadan."), 0, FALSE);
		return 5;
	}

	CloseHandle (processInfo.hThread);
	CloseHandle (processInfo.hProcess);
	_tprintf (_T (" [%d] %d\n"), jobNumber, processInfo.dwProcessId);
	return 0;
}

/* Jobs: wywietla wszystkie dziaajce lub zatrzymane procesy utworzone
	przez uytkownika w ramach zarzdzania zadaniami
	(czyli za pomoc polecenia jobbg).
	Do zarzdzania zadaniami su powizane polecenia (jobbg i kill). */
/* Nowe mechanizmy programu ilustruj:
	1. Okrelanie stanu procesu.
	2. Przechowywanie listy zada i procesw we wsplnym pliku.
	3. Pobieranie informacji o obiekcie zadania.
 */


int Jobs (int argc, LPTSTR argv[], LPTSTR command)
{
	JOBOBJECT_BASIC_ACCOUNTING_INFORMATION basicInfo;

	if (!DisplayJobs ()) return 1;
	/* Wywietlanie informacji o zadaniu. */
	if (!QueryInformationJobObject(hJobObject, JobObjectBasicAccountingInformation, &basicInfo, sizeof(JOBOBJECT_BASIC_ACCOUNTING_INFORMATION), NULL)) {
		ReportError(_T("Blad funkcji QueryInformationJobObject."), 0, TRUE);
		return 0;
	}
	_tprintf (_T("Liczba procesow: %d, Aktywne: %d, Zakonczone: %d.\n"),
		basicInfo.TotalProcesses, basicInfo.ActiveProcesses, basicInfo.TotalTerminatedProcesses);
	_tprintf (_T("Czas uzytkownika dla wszystkich procesow: %d.%03d\n"),
		basicInfo.TotalUserTime.QuadPart / MILLION, (basicInfo.TotalUserTime.QuadPart % MILLION) / 10000);

	return 0;
}

/* kill [opcje] numerZadania
	Koczy proces powizany z zadaniem o okrelonym numerze. */
/* Nowe mechanizmy w tym programie ilustruj:
	1. Korzystanie z funkcji TerminateProcess.
	2. Zdarzenia sterujce konsoli. */

/* Opcje:
	-b  generuje kombinacj Ctrl+Break 
	-c  generuje kombinacj Ctrl+C
		W przeciwnym razie koczy proces. */

/* Struktury danych, kody bdw,
	stae i tak dalej znajduj si w innym pliku. */

int Kill (int argc, LPTSTR argv[], LPTSTR command)
{
	DWORD processId, jobNumber, iJobNo;
	HANDLE hProcess;
	BOOL cntrlC, cntrlB, killed;

	iJobNo = Options (argc, argv, _T ("bc"), &cntrlB, &cntrlC, NULL);
	
	/* Wyszukiwanie ID procesu powizanego z danym zadaniem. */

	jobNumber = _ttoi (argv[iJobNo]);
	processId = FindProcessId (jobNumber);
	if (processId == 0)	{
		ReportError (_T ("Nie znaleziono numeru zadania.\n"), 0, FALSE);
		return 1;
	}
	hProcess = OpenProcess (PROCESS_TERMINATE, FALSE, processId);
	if (hProcess == NULL) {
		ReportError (_T ("Proces zakonczyl juz dzialanie.\n"), 0, FALSE);
		return 2;
	}

	if (cntrlB)
		killed = GenerateConsoleCtrlEvent (CTRL_BREAK_EVENT, processId);
	else if (cntrlC)
		killed = GenerateConsoleCtrlEvent (CTRL_C_EVENT, processId);
	else
		killed = TerminateProcess (hProcess, JM_EXIT_CODE);

	if (!killed) { 
		ReportError (_T ("Nieudane zamykanie procesu."), 0, TRUE);
		return 3;
	}
	
	WaitForSingleObject (hProcess, 5000);
	CloseHandle (hProcess);

	_tprintf (_T ("Zadanie [%d] zakonczylo dzialanie lub uplynal limit czasu.\n"), jobNumber);
	return 0;
}
