/* Funkcje narzdziowe do zarzdzania zadaniami. */
/* Te funkcje ilustruj blokowanie plikw. */
/*  W tej implementacji funkcje s oparte na funkcji LockFileEx
	i nie dziaaj w systemach Windows 9x.
	Uywanie funkcji LockFile dla systemw Windows 9x. Wtedy wszystkie
	blokady s na wyczno. */

#include "Everything.h"
#include "JobManagement.h"

LONG GetJobNumber (PROCESS_INFORMATION *pProcessInfo, LPCTSTR Command)

/* Tworzy numer zadania dla nowego procesu i umieszcza 
   informacje o nowym procesie w bazie danych zadania. */

/* Baza danych zadania jest przechowywana we wspuytkowanym pliku w katalogu C:\temp.
	Jego nazwa to poczenie nazwy uytkownika i czonu ".JobMgt".
	Plik jest tworzony wraz z pierwszym zadaniem i usuwany
	po usuniciu ostatniego zadania.
	Plik ten jest wsplny dla wszystkich funkcji do zarzdzania zadaniami. 
	Zakadamy, e plik jest "may" (< 4 GB). Dla bardzo duych plikw
	program zawiedzie w kilku miejscach. Wystpuje ograniczenie 
	liczby zada (arbitralne, ale sensowne) do 10000 (MAX_JOBS_ALLOWED).
	Zwraca -1 w przypadku bdu. */
{
	HANDLE hJobData, hProcess;
	JM_JOB jobRecord;
	DWORD jobNumber = 0, nXfer, exitCode;
	LARGE_INTEGER fileSize, fileSizePlus;
	TCHAR jobMgtFileName[MAX_PATH];
	OVERLAPPED regionStart;
	
	if (!GetJobMgtFileName (jobMgtFileName)) return -1;
	hJobData = CreateFile (jobMgtFileName, GENERIC_READ | GENERIC_WRITE,
			FILE_SHARE_READ | FILE_SHARE_WRITE,
			NULL, OPEN_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);
	if (hJobData == INVALID_HANDLE_VALUE) {
		ReportError (_T ("Niepowodzenie przy otwieraniu bazy danych zadania."), 0, TRUE);
		return -1;
	}

	/*  Blokowanie caego pliku i jednego potencjalnego 
        nowego rekordu do dostpu wycznego z uwagi na tworzenie
        nowego wpisu. Warto zauway, e konieczne (i moliwe!) jest
	    blokowanie obszaru poza kocem pliku. Zapobiega to jednoczesnym
		prbom dodania nowego rekordu na koniec pliku. */

	regionStart.Offset = 0;
	regionStart.OffsetHigh = 0;
	regionStart.hEvent = (HANDLE)0;
	GetFileSizeEx (hJobData, &fileSize);
	fileSizePlus.QuadPart = fileSize.QuadPart + SJM_JOB; 
	LockFileEx (hJobData, LOCKFILE_EXCLUSIVE_LOCK,
		0, fileSizePlus.LowPart, fileSizePlus.HighPart, &regionStart);

	__try { /* Gwarantowanie, e obszar nie jest zablokowany. */
	/* Wczytywanie rekordw w celu znalezienia pustego miejsca (odpowiadajcego numerowi zadania).
		Rozszerzanie pliku w celu utworzenia w razie potrzeby nowego numeru zadania. */
	/*	Zobacz komentarze w tekcie i wiczenie 6.8 dotyczce usterki (i poprawki)
		zwizanej z powtrnym wykorzystaniem ID procesu. */

	while (jobNumber < MAX_JOBS_ALLOWED &&
		ReadFile (hJobData, &jobRecord, SJM_JOB, &nXfer, NULL) && (nXfer > 0)) {
		if (jobRecord.ProcessId == 0) break;

		/* Tego slotu mona uy take wtedy, jeli odpowiednie zadania si zakoczyo. */

		hProcess = OpenProcess (PROCESS_ALL_ACCESS, FALSE, jobRecord.ProcessId);
		if (hProcess == NULL) break;
		if (GetExitCodeProcess (hProcess, &exitCode)
			&& CloseHandle (hProcess) && (exitCode != STILL_ACTIVE))
			break;

		jobNumber++;
	}

	/* Albo znaleziono pusty slot, albo program doszed do koca pliku
		i musi utworzy nowy, albo przekroczy maksymaln liczb zada. */
	if (jobNumber >= MAX_JOBS_ALLOWED) return -1;

	if (nXfer != 0)		/* To nie koniec pliku. Zachowywanie rekordu. */
		/* Wygodniejsza jest funkcja SetFilePoiner ni SetFilePointerEx, poniewa program
           przenosi dane niedaleko od biecje pozycji. */
		SetFilePointer (hJobData, -(LONG)SJM_JOB, NULL, FILE_CURRENT);
					/* Wprowadzenie numeru nowego zadania. */
	jobRecord.ProcessId = pProcessInfo->dwProcessId;
	_tcsnccpy_s (jobRecord.CommandLine, sizeof(jobRecord.CommandLine), Command, MAX_PATH);
	WriteFile (hJobData, &jobRecord, SJM_JOB, &nXfer, NULL);
	}

	__finally {		/* Zwalnianie blokady pliku. */
		UnlockFileEx (hJobData, 0, fileSizePlus.LowPart, fileSizePlus.HighPart, &regionStart);
		CloseHandle (hJobData);
	}
	return jobNumber + 1;
}

BOOL DisplayJobs (void)

/* Przegldanie pliku z baz danych i informowanie o stanie wszystkich zada.
	Usuwanie wszystkich zada, ktre ju nie istniej w systemie. */
{
	HANDLE hJobData, hProcess;
	JM_JOB jobRecord;
	DWORD jobNumber = 0, nXfer, exitCode;
	TCHAR jobMgtFileName[MAX_PATH];
	OVERLAPPED regionStart;
	
	if (GetJobMgtFileName (jobMgtFileName) < 0)
		return FALSE;
	hJobData = CreateFile (jobMgtFileName, GENERIC_READ | GENERIC_WRITE,
		FILE_SHARE_READ | FILE_SHARE_WRITE,
		NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
	if (hJobData == INVALID_HANDLE_VALUE)
		return FALSE;

	/* Wczytywanie rekordw i informowanie o kadym zadaniu. */
	/*  Najpierw naley utworzy blokad na wyczno do caego pliku,
		poniewa program modyfikuje wpisy. */
	regionStart.Offset = 0;
	regionStart.OffsetHigh = 0;
	regionStart.hEvent = (HANDLE)0;
	LockFileEx (hJobData, LOCKFILE_EXCLUSIVE_LOCK, 0, 0, 0, &regionStart);

	__try {
	while (ReadFile (hJobData, &jobRecord, SJM_JOB, &nXfer, NULL) && (nXfer > 0)) {
		jobNumber++; /* Zmienna jobNumber nie wykracza poza warto MAX_JOBS_ALLOWED, poniewa
					    program nie moe wyduy pliku do tego rozmiaru. */
		if (jobRecord.ProcessId == 0) continue;
					/* Pobieranie stanu procesu. */
		hProcess = OpenProcess (PROCESS_ALL_ACCESS, FALSE, jobRecord.ProcessId);
		if (hProcess != NULL) {
			GetExitCodeProcess (hProcess, &exitCode);
			CloseHandle (hProcess);
		}
					/* Wywietlanie stanu zadania. */
		_tprintf (_T (" [%d] "), jobNumber);
		if (hProcess == NULL)
			_tprintf (_T (" Zakonczono"));
		else if (exitCode != STILL_ACTIVE)
			_tprintf (_T ("+ Zakonczono"));
		else _tprintf (_T ("      "));
					/* Wywietlanie polecenia. */
		_tprintf (_T (" %s\n"), jobRecord.CommandLine);

		/* Usuwanie procesw, ktre ju nie znajduj si w systemie. */

		if (hProcess == NULL) { /* Zapisywanie jednego rekordu. */
			/* Wygodniejsza jest funkcja SetFilePoiner ni SetFilePointerEx, poniewa
    			program przenosi dane niedaleko od biecej pozycji. */
			SetFilePointer (hJobData, -(LONG)nXfer, NULL, FILE_CURRENT);
					/* Ustawianie numeru zadania na 0. */
			jobRecord.ProcessId = 0;
			if (!WriteFile (hJobData, &jobRecord, SJM_JOB, &nXfer, NULL))
				ReportError (_T ("Blad zapisu."), 1, TRUE);
		}
	}  /* Koniec ptli while. */
	}  /* Koniec bloku try.   */
	
	__finally {		/* Zwalnianie blokady pliku. */
		UnlockFileEx (hJobData, 0, 0, 0, &regionStart);
		CloseHandle (hProcess);
	}

	CloseHandle (hJobData);
	return TRUE;
}

DWORD FindProcessId (DWORD jobNumber)

/* Pobieranie ID procesu dla zadania o okrelonym numerze. */
{
	HANDLE hJobData;
	JM_JOB jobRecord;
	DWORD nXfer, fileSizeLow;
	TCHAR jobMgtFileName[MAX_PATH+1];
	OVERLAPPED regionStart;
	LARGE_INTEGER fileSize;

	GetJobMgtFileName (jobMgtFileName);
	hJobData = CreateFile (jobMgtFileName, GENERIC_READ,
			FILE_SHARE_READ | FILE_SHARE_WRITE,
			NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
	if (hJobData == INVALID_HANDLE_VALUE) return 0;
	/* Ustawia pozycj na biecy rekord, ale nie poza kocem pliku. */
	/* W ramach odmiany uyto funkcji GetFileSize do zilustrowania jej dziaania. */
	if (!GetFileSizeEx (hJobData, &fileSize) ||
		(fileSize.HighPart != 0 || SJM_JOB * (jobNumber - 1) > fileSize.LowPart 
		 || fileSize.LowPart > SJM_JOB * MAX_JOBS_ALLOWED))
			return 0;
	fileSizeLow = fileSize.LowPart;
	/* Funkcja SetFilePoiner jest wygodniejsza ni SetFilePointerEx, poniewa wiadomo, e
	   plik jest "krtki" ( < 4 GB). */
	SetFilePointer (hJobData, SJM_JOB * (jobNumber - 1), NULL, FILE_BEGIN);
	
	/* Zajmowanie blokady rekordu w trybie wspuytkowania. */
	
	regionStart.Offset = SJM_JOB * (jobNumber - 1);
	regionStart.OffsetHigh = 0; /* Zakadamy, e jest to "krtki" plik. */
	regionStart.hEvent = (HANDLE)0;
	LockFileEx (hJobData, 0, 0, SJM_JOB, 0, &regionStart);
	
	if (!ReadFile (hJobData, &jobRecord, SJM_JOB, &nXfer, NULL))
		ReportError (_T ("Blad pliku z danymi."), 0, TRUE);

	UnlockFileEx (hJobData, 0, SJM_JOB, 0, &regionStart);
	CloseHandle (hJobData);

	return jobRecord.ProcessId;
}

BOOL GetJobMgtFileName (LPTSTR jobMgtFileName)

/* Tworzenie nazwy pliku do zarzdzania zadaniami. */
{
	TCHAR UserName[MAX_PATH], TempPath[MAX_PATH];
	DWORD UNSize = MAX_PATH, TPSize = MAX_PATH;

 	if (!GetUserName (UserName, &UNSize))
		return FALSE;
	if (GetTempPath (TPSize, TempPath) > TPSize)
		return FALSE;
	_stprintf_s (jobMgtFileName, MAX_PATH, _T ("%s%s%s"), TempPath, UserName, _T (".JobMgt"));
	return TRUE;
}
