/* Chapter 6. grepMP. */
/* Wieloprocesowa wersja polecenia grep. */
/* grep wzorzec pliki
	Wyszukuje wzorzec w jednym lub kilku plikach.
	Wywietla peny wiersz, w ktrym znajduje si wzorzec.
	Jeli w wierszu polece podano kilka plikw, naley
	wywietli take nazw pliku. Nie przyjmuje opcji. */

/* Ten program ilustruje:
	1. 	Tworzenie procesw.
	2. 	Ustawianie standardowego wejcia-wyjcia dla procesu podrzdnego za pomoc struktury pocztkowej procesu.
	3. 	Informowanie procesu podrzdnego o tym, e uchwyty plikw z procesu nadrzdnego mona dziedziczy.
	4. 	Synchronizowanie z zakoczenie pracy procesu przy uyciu funkcji WaitForMultipleObjects
		i WaitForSingleObject.
	5.	Generowanie i uywanie plikw tymczasowych na dane wyjciowe z kadego procesu. */

#include "Everything.h"

int _tmain (int argc, LPTSTR argv[])

/*	Tworzenie odrbnego procesu do przeszukiwania kadego pliku podanego
	w wierszu polece. Kady proces otrzymuje plik tymczasowy na wyniki  
	w biecym katalogu. */
{
	HANDLE hTempFile;
	SECURITY_ATTRIBUTES stdOutSA = /* Atrybuty bezpieczestwa dla dziedziczonych uchwytw. */
			{sizeof (SECURITY_ATTRIBUTES), NULL, TRUE};
	TCHAR commandLine[MAX_PATH + 100];
	STARTUPINFO startUpSearch, startUp;
	PROCESS_INFORMATION processInfo;
	DWORD exitCode, dwCreationFlags = 0;
	int iProc;
	HANDLE *hProc;  /* Wskanik do tablicy uchwytw procesu. */
	typedef struct {TCHAR tempFile[MAX_PATH];} PROCFILE;
	PROCFILE *procFile; /* Wskanik do tablicy nazw plikw tymczasowych. */
#ifdef UNICODE
    dwCreationFlags = CREATE_UNICODE_ENVIRONMENT;
#endif


	if (argc < 3)
		ReportError (_T ("Stosowanie: grepMP wzorzec pliki."), 1, FALSE);

	/* Informacje pocztkowe dla kadego wyszukujcego procesu podrzdnego,
		a take dla procesw podrzdnych wywietlajcych wyniki. */

	GetStartupInfo (&startUpSearch);
	GetStartupInfo (&startUp);

	/* Alokowanie pamici na tablic ze strukturami danych procesu.
		Kada struktura obejmuje uchwyt procesu i nazw pliku tymczasowego. */

	procFile = malloc ((argc - 2) * sizeof (PROCFILE));
	hProc = malloc ((argc - 2) * sizeof (HANDLE));

	/* Tworzenie odrbnego procesu "grep" dla kadego pliku podanego w
		wierszu polece. Kady proces otrzymuje te nazw pliku tymczasowego 
		na wyniki. Uchwyt jest przekazywany za pomoc 
		struktury STARTUPINFO. Parametr argv[1] zawiera szukany wzorzec. */

	for (iProc = 0; iProc < argc - 2; iProc++) {

		/* Tworzenie wiersza polece w postaci: grep argv[1] argv[iProc + 2] */
		/* Umoliwia stosowanie odstpw w nazwach plikw. */
		_stprintf (commandLine, _T ("grep \"%s\" \"%s\""), argv[1], argv[iProc + 2]);

		/* Tworzenie nazwy pliku tymczasowego dla standardowego wyjcia. */

		if (GetTempFileName (_T ("."), _T ("gtm"), 0, procFile[iProc].tempFile) == 0)
			ReportError (_T ("Blad pliku tymczasowego."), 2, TRUE);

		/* Ustawianie standardowego wyjcia dla procesu wyszukujcego. */

		hTempFile = /* Ten uchwyt umoliwia dziedziczenie. */
			CreateFile (procFile[iProc].tempFile,
				/** GENERIC_READ | dostp do odczytu nie jest potrzebny. **/ GENERIC_WRITE,
				FILE_SHARE_READ | FILE_SHARE_WRITE, &stdOutSA,
				CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);
		if (hTempFile == INVALID_HANDLE_VALUE)
			ReportError (_T ("Nie mozna otworzyc pliku tymczasowego."), 3, TRUE);

		/* Informuje, e standardowe wejcie nowego procesu 
			pochodzi z uchwytw plikw tymczasowych. */

		startUpSearch.dwFlags = STARTF_USESTDHANDLES;
		startUpSearch.hStdOutput = hTempFile;
		startUpSearch.hStdError = hTempFile;
		startUpSearch.hStdInput = GetStdHandle (STD_INPUT_HANDLE);
		/* Tworzenie procesu do wykonywania wiersza polece. */

		if (!CreateProcess (NULL, commandLine, NULL, NULL,
				TRUE, dwCreationFlags, NULL, NULL, &startUpSearch, &processInfo))
			ReportError (_T ("Blad tworzenia procesu."), 4, TRUE);
		/* Zamykanie niepotrzebnych uchwytw. */
		CloseHandle (hTempFile); CloseHandle (processInfo.hThread);

		/* Zapisywanie uchwytu procesu. */

		hProc[iProc] = processInfo.hProcess;
	}

	/* Wszystkie procesy dziaaj. Oczekiwanie na ich zakoczenie i wywietlanie
		wynikw wedug nazw plikw z wiersza polece. */
	for (iProc = 0; iProc < argc-2; iProc += MAXIMUM_WAIT_OBJECTS)
		WaitForMultipleObjects (min(MAXIMUM_WAIT_OBJECTS, argc - 2 - iProc), 
				&hProc[iProc], TRUE, INFINITE);

	/* Pliki z wynikami s wysyane do standardowego wyjcia za pomoc programu "cat".
		Usuwanie kadego pliku tymczasowego po zakoczeniu pracy. */

	for (iProc = 0; iProc < argc - 2; iProc++) { 
		if (GetExitCodeProcess (hProc[iProc], &exitCode) && exitCode == 0) {
			/* Wykryto wzorzec - wywietlanie wynikw. */
			/* Wywietlanie nazwy pliku, jeli przeszukiwanych jest wicej plikw. */
			if (argc > 3) _tprintf (_T("%s:\n"), argv[iProc+2]);
			_stprintf (commandLine, _T ("cat \"%s\""), procFile[iProc].tempFile);
			if (!CreateProcess (NULL, commandLine, NULL, NULL,
					TRUE, dwCreationFlags, NULL, NULL, &startUp, &processInfo))
				ReportError (_T ("Blad programu cat."), 0, TRUE);
			else { 
				WaitForSingleObject (processInfo.hProcess, INFINITE);
				CloseHandle (processInfo.hProcess);
				CloseHandle (processInfo.hThread);
			}
		}

		CloseHandle (hProc[iProc]);
		if (!DeleteFile (procFile[iProc].tempFile))
			ReportError (_T ("Nie mozna usunac pliku tymczasowego."), 6, TRUE);
	}
	free (procFile); free (hProc);
	return 0;
}

