/****	Copyright 1995, Alan R. Feuer	****/
/**** BEZ OBSUGI KODOWANIA UNICODE ****/
/* grep wzorzec pliki
Wyszukuje wzorzec w plikach. Plik jest przegldany wiersz po wierszu.

Dostpne metaznaki:
*	Pasuje do zera lub wicej znakw
?	Pasuje do dokadnie jednego znaku
[...]	Okrela klas znakw i
pasuje do dowolnego znaku z klasy
^	Pasuje do pocztku wiersza
$	Pasuje do koca wiersza

Ponadto obsugiwane s standardowe sekwencje ucieczki z jzyka C:
\a, \b, \f, \t, \v
*/

#include <windows.h>
#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <stdlib.h>

/* Kody metaznakw. */
#define STAR        1
#define QM          2
#define BEGCLASS    3
#define ENDCLASS    4
#define ANCHOR      5

/* Inne kody i definicje. */
#define EOS '\0'

/* Opcje wzorca. */
BOOL ignoreCase = FALSE;

FILE * openFile (char * file, char * mode) {
	FILE *fp;
	if ((fp = fopen (file,mode)) == NULL)
		perror (file);
	return(fp);
}

void
prepSearchString (char *p, char *buf) {
	/* Kopiowanie szukanego acucha znakw do bufora. */
	register int c;
	register int i = 0;

	if (*p=='^') {
		buf [i++] = ANCHOR;
		++p;
	}

	for (;;) {
		switch (c=*p++) {
		case EOS: goto Exit;
		case '*': if (i >= 0 && buf [i - 1] != STAR ) c = STAR; break;
		case '?': c = QM; break;
		case '[': c = BEGCLASS; break;
		case ']': c = ENDCLASS; break;

		case '\\':
			switch( c = *p++ ) {
		case EOS: goto Exit;
		case 'a': c = '\a'; break;
		case 'b': c = '\b'; break;
		case 'f': c = '\f'; break;
		case 't': c = '\t'; break;
		case 'v': c = '\v'; break;
		case '\\': c = '\\'; break;
			}
			break;
		}

		buf [i++] = (ignoreCase ? tolower (c) : c);
	}

Exit:
	buf [i] = EOS;
}

BOOL
patternMatch (char *pattern, char *string)
/* Zwraca TRUE, jeli acuch pasuje do wzorca. */
{
	register char pc, sc;
	char *pat;
	BOOL anchored;

	if (anchored = (*pattern == ANCHOR))
		++pattern;

Top:		
	pat = pattern;

Again:
	pc = *pat;
	sc = *string;

	if (sc == '\n' || sc == EOS ) {
		/* Na kocu wiersza lub tekstu. */
		if (pc==EOS) goto Success;
		else if (pc==STAR) {
			/* patternMatch (pat + 1, base, index, end) */
			++pat;
			goto Again;
		} else return (FALSE);
	} else {
		if (pc == sc || pc == QM) {
			/* patternMatch (pat + 1, string + 1) */
			++pat;
			++string;
			goto Again;
		} else if (pc == EOS) goto Success;
		else if (pc == STAR) {
			if (patternMatch (pat + 1, string)) goto Success;
			else { /* patternMatch (pat, string + 1) */
				++string;
				goto Again;
			}
		} else if(pc == BEGCLASS) { /* Klasa znakw. */
			BOOL clmatch = FALSE;
			while (*++pat != ENDCLASS) {
				if (!clmatch && *pat == sc) clmatch = TRUE;
			}
			if(clmatch) {
				++pat;
				++string;
				goto Again;
			}
		}
	}

	if (anchored) return(FALSE);

	++string;
	goto Top;

Success:
	return (TRUE);
}

void main (int argc, char **argv)

/* Ta wersja jest zmodyfikowana i uywa wycznie stdout.
   W wierszu polece naley poda tylko wzorzec. */
{
	int i, patternSeen = FALSE, showName = FALSE, result = 1, iFile;
	char pattern [256];
	char string [2048];
	FILE *fp;

	for (iFile = 2; iFile < argc; iFile++)
	{
		fp = openFile (argv [iFile], "r"); /* Plik wejciowy. */
		if (fp == NULL)	{
			perror ("Nieudane otwieranie pliku.\n");
			fputs ("", stdout);
			fputc ('\0', stdout);
			exit (1);
		}

		if (argc < 1) {
			puts ("Stosowanie: grep wzorzec pliki");
			exit (2);
		}

		for (i = 1; i < argc + 1; ++i) {
			if (i < argc && argv [i] [0] == '-') {
				switch (argv [i] [1]) {
				case 'y':
					ignoreCase = TRUE;
					break;
				}
			} else {
				if (!patternSeen++)
					prepSearchString (argv [i], pattern);
				else if(/*(fp=openFile(file=argv[i],"rb"))!=NULL*/ TRUE) {
					if (!showName && i < argc - 1 ) ++showName;
					while (fgets (string, sizeof (string), fp) != NULL
						&& !feof (fp)) {
							if (ignoreCase) _strlwr (string);
							if (patternMatch (pattern, string)) {
								result = 0;
								if (showName) {
									fputs (string, stdout);
								}
								else fputs (string,stdout);
							}
					}
				}
			}
		}
		fputc ('\n', stdout);
		fclose (fp);
	}
	exit(result);
}

