/* Rozdzia 6. catHA. */
/* cat pliki WartoUchwytu */

/* Ten program ilustruje:
	1.	Korzystanie z funkcji ReportError.
	2.	Korzystanie z funkcji CreateFile, ReadFile, WriteFile i CloseHandle w systemach Win32.
	3.	Ptle do przetwarzania plikw sekwencyjnych.
	4.	Korzystanie z uchwytw przekazywanych jako argument wiersza polece. */

#include "Environment.h"
#include <windows.h>
#include <tchar.h>
#include "support.h"
#include <stdio.h>

#define BUF_SIZE 0x200

static VOID CatFile (HANDLE, HANDLE);
int _tmain (int argc, LPTSTR argv [])
{
	HANDLE hInFile, hOut;

	_tprintf (_T("W programie catHA. %s %s\n"), argv [1], argv [2]);

	hInFile = CreateFile (argv [1], GENERIC_READ, 0, NULL, OPEN_EXISTING,
			FILE_ATTRIBUTE_NORMAL, NULL);
	if (hInFile == INVALID_HANDLE_VALUE)
			/* Upraszczajce zaoenie: otwieranie koczy si niepowodzeniem tylko wtedy,
				jeli plik nie istnieje. */
		ReportError (_T("\nBlad programu catHA: plik nie istnieje."), 0, TRUE);

	/* Uchwyt wyjciowy jest pobierany z wiersza polece. */

	hOut = (HANDLE) (_ttoi (argv [2]));

	CatFile (hInFile, hOut);
	
	CloseHandle (hOut);
	return 0;
}

static VOID CatFile (HANDLE hInFile, HANDLE hOutFile)
{
	DWORD nIn, nOut;
	BYTE Buffer [BUF_SIZE];

	while (ReadFile (hInFile, Buffer, BUF_SIZE, &nIn, NULL)
			&& (nIn == BUF_SIZE)
			&& WriteFile (hOutFile, Buffer, nIn, &nOut, NULL)) ;
					/* Zapis ostatniego bufora. */ ;
		WriteFile (hOutFile, Buffer, nIn, &nOut, NULL);

	WriteFile (hOutFile, CRLF, lstrlen (CRLF) * TSIZE, &nOut, NULL);

	return;
}
