/* Rozdzia 5. cci_fMMDll.c. */
/* Program cci_fMM.c z rozdziau 5. przeksztacony na bibliotek DLL. */

#include "Everything.h"
/* Poniszy wiersz [__declspec (dllexport)] to jedyna zmiana w porwnaniu z programem cci_f.c. */
/* Oglnie naley uy jednej funkcji i zmiennej preprocesora */
/* do okrelenia, czy funkcja ta jest eksportowana. */

__declspec (dllexport)
BOOL __cdecl cci_f (LPCTSTR fIn, LPCTSTR fOut, DWORD shift)

/* Funkcja stosujca szyfr Cezara:
*		fIn:		cieka do pliku rdowego
*		fOut:		cieka do pliku docelowego
*		shift:		przesunicie liczbowe */
{
	BOOL Complete = FALSE;
	__try {
		HANDLE hIn, hOut;
		HANDLE hInMap, hOutMap;
		LPTSTR pIn, pInFile, pOut, pOutFile;
		LARGE_INTEGER FSize;

		/* Otwieranie pliku wejciowego. */
		hIn = CreateFile (fIn, GENERIC_READ, 0, NULL,
			OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
		if (hIn == INVALID_HANDLE_VALUE) 
			ReportException (_T ("Nieudane otwarcie pliku wejsciowego."), 1);

		/* Pobieranie rozmiaru pliku wejciowego. */
		if (!GetFileSizeEx (hIn, &FSize))
			ReportException (_T ("Nieudane pobieranie rozmiaru pliku."), 4);
		if (FSize.HighPart > 0 && sizeof(SIZE_T) == 4)
			ReportException (_T ("Plik za duzy dla systemu Win32."), 4);

		/* Tworzenie obiektu odwzorowania pliku dla pliku wejciowego. 
		   Naley wykorzysta rozmiar pliku. */
		hInMap = CreateFileMapping (hIn, NULL, PAGE_READONLY, 0, 0, NULL);
		if (hInMap == INVALID_HANDLE_VALUE)
			ReportException (_T ("Nieudane tworzenie odwzorowania wejsciowego."), 2);

		/* Odwzorowywanie pliku wejciowego. */
		pInFile = MapViewOfFile (hInMap, FILE_MAP_READ, 0, 0, 0);
		if (pInFile == NULL)
			ReportException (_T ("Nieudane odwzorowywanie pliku wejsciowego."), 3);

		/*  Tworzenie lub otwieranie pliku wyjciowego. */
		/* Plik wyjciowy MUSI zapewnia dostp do odczytu i zapisu, aby odwzorowywanie si powiodo. */
		hOut = CreateFile (fOut, GENERIC_READ | GENERIC_WRITE,
			0, NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);
		if (hOut == INVALID_HANDLE_VALUE) {
			Complete = TRUE; /* Nie naley usuwa istniejcego pliku. */
			ReportException (_T ("FNieudane otwieranie pliku wyjciowego."), 5);
		}

		/* Odwzorowywanie pliku wyjciowego. Funkcja CreateFileMapping wyduy
		   plik, jeli jest on krtszy ni odwzorowanie. */

		hOutMap = CreateFileMapping (hOut, NULL, PAGE_READWRITE, FSize.HighPart, FSize.LowPart, NULL);
		if (hOutMap == NULL)
			ReportException (_T ("Nieudane tworzenie odwzorowania wyjsciowego."), 7);
		pOutFile = MapViewOfFile (hOutMap, FILE_MAP_WRITE, 0, 0, (SIZE_T)FSize.QuadPart);
		if (pOutFile == NULL)
			ReportException (_T ("Nieudane odwzorowywanie pliku wyjsciowego."), 8);

		/* Przenoszenie w pamici pliku wejciowego do wyjciowego. */
		__try {
			pIn = pInFile;
			pOut = pOutFile;
			while (pIn < pInFile + FSize.QuadPart) {
				*pOut = (BYTE)((*pIn + shift) % 256);
				pIn++; pOut++;
				Complete = TRUE;
			}
		}
		__except(GetExceptionCode() == EXCEPTION_IN_PAGE_ERROR ? EXCEPTION_EXECUTE_HANDLER : EXCEPTION_CONTINUE_SEARCH)
		{
			Complete = FALSE;
		}

		/* Zamknicie wszystkich widokw i uchwytw. */

		UnmapViewOfFile (pOutFile); UnmapViewOfFile (pInFile);
		CloseHandle (hOutMap); CloseHandle (hInMap);
		CloseHandle (hIn); CloseHandle (hOut);
		return Complete;
	}

	__except (EXCEPTION_EXECUTE_HANDLER) {
		/* Usuwanie pliku wyjciowego, jeli operacja zakoczya si niepowodzeniem. */
		if (!Complete)
			DeleteFile (fOut);
		return FALSE;
	}
}




