/* Rozdzia 5.
Program cci_fMM.c: oparta na odwzorowywaniu w pamici implementacja 
prostej funkcji do stosowania szyfru Cezara. */

#include "Everything.h"

BOOL cci_f (LPCTSTR fIn, LPCTSTR fOut, DWORD shift)

/* Funkcja stosujca szyfr Cezara:
*		fIn:		cieka do pliku rdowego
*		fOut:		cieka do pliku docelowego
*		shift:		przesunicie liczbowe */
{
	BOOL complete = FALSE;
	HANDLE hIn = INVALID_HANDLE_VALUE, hOut = INVALID_HANDLE_VALUE;
	HANDLE hInMap = NULL, hOutMap = NULL;
	LPTSTR pIn = NULL, pInFile = NULL, pOut = NULL, pOutFile = NULL;
	__try {
		LARGE_INTEGER fileSize;

		/* Otwieranie pliku wejciowego. */
		hIn = CreateFile (fIn, GENERIC_READ, 0, NULL,
			OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
		if (hIn == INVALID_HANDLE_VALUE) 
			ReportException (_T ("Nieudane otwarcie pliku wejsciowego."), 1);

		/* Pobieranie rozmiaru pliku wejciowego. */
		if (!GetFileSizeEx (hIn, &fileSize))
			ReportException (_T ("Nieudane pobieranie rozmiaru pliku."), 4);
		/* Jest to konieczny, ale NIEWYSTARCZAJCY test moliwoci odwzorowania w systemach 32-bitowych.
		 * Zobacz te dugi komentarz kilka wierszy dalej. */
		if (fileSize.HighPart > 0 && sizeof(SIZE_T) == 4)
			ReportException (_T ("Plik za duzy dla systemu Win32."), 4);

		/* Tworzenie obiektu odwzorowania pliku dla pliku wejciowego. 
		   Naley wykorzysta rozmiar pliku. */
		hInMap = CreateFileMapping (hIn, NULL, PAGE_READONLY, 0, 0, NULL);
		if (hInMap == INVALID_HANDLE_VALUE)
			ReportException (_T ("Nieudane tworzenie odwzorowania wejsciowego."), 2);

		/* Odwzorowywanie pliku wejciowego. */
		/* Komentarz: dla duych plikw moe si nie powie - zwaszcza w systemach 32-bitowych,
		 * gdzie mona korzysta z najwyej 3 gigabajtw (oczywicie w praktyce jest jej duo mniej,
		 * a trzeba odwzorowa dwa pliki). 
		 * Ten program odwzorowuje pliki wejciowy i wyjciowy w caoci.
		 * Mona rozbudowa program przed odwzorowywanie po jednym bloku, podobnie
		 * jak uywane s bloki w implementacjach opartych na funkcjach ReadFile/WriteFile. Umoliwia
		 * to obsug bardzo duych plikw w systemach 32-bitowych. Pozostawiam to jako
		 * wiczenie dla Czytelnika. 
		 */
		pInFile = MapViewOfFile (hInMap, FILE_MAP_READ, 0, 0, 0);
		if (pInFile == NULL)
			ReportException (_T ("Nieudane odwzorowywanie pliku wejsciowego."), 3);

		/*  Tworzenie lub otwieranie pliku wyjciowego. */
		/*  Plik wyjciowy MUSI zapewnia dostp do odczytu i zapisu, aby odwzorowywanie si powiodo. */
		hOut = CreateFile (fOut, GENERIC_READ | GENERIC_WRITE,
			0, NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);
		if (hOut == INVALID_HANDLE_VALUE) {
			complete = TRUE; /* Nie naley usuwa istniejcego pliku. */
			ReportException (_T ("Nieudane otwieranie pliku wyjciowego."), 5);
		}

		/* Odwzorowywanie pliku wyjciowego. Funkcja CreateFileMapping wyduy
		   plik, jeli jest on krtszy ni odwzorowanie. */

		hOutMap = CreateFileMapping (hOut, NULL, PAGE_READWRITE, fileSize.HighPart, fileSize.LowPart, NULL);
		if (hOutMap == NULL)
			ReportException (_T ("Nieudane tworzenie odwzorowania wyjsciowego."), 7);
		pOutFile = MapViewOfFile (hOutMap, FILE_MAP_WRITE, 0, 0, (SIZE_T)fileSize.QuadPart);
		if (pOutFile == NULL)
			ReportException (_T ("Nieudane odwzorowywanie pliku wyjsciowego."), 8);

		/* Przenoszenie w pamici pliku wejciowego do wyjciowego. */
		__try
		{
			pIn = pInFile;
			pOut = pOutFile;
			while (pIn < pInFile + fileSize.QuadPart) {
				*pOut = (BYTE)((*pIn + shift) % 256);
				pIn++; pOut++;
			}
			complete = TRUE;
		}
		__except(GetExceptionCode() == EXCEPTION_IN_PAGE_ERROR ? EXCEPTION_EXECUTE_HANDLER : EXCEPTION_CONTINUE_SEARCH)
		{
			complete = FALSE;
			ReportException(_T("Blad krytyczny przy dostepie do odwzorowanego pliku."), 9);
		}

		/* Zamknicie wszystkich widokw i uchwytw. */
		UnmapViewOfFile (pOutFile); UnmapViewOfFile (pInFile);
		CloseHandle (hOutMap); CloseHandle (hInMap);
		CloseHandle (hIn); CloseHandle (hOut);
		return complete;
	}

	__except (EXCEPTION_EXECUTE_HANDLER) {
		if (pOutFile != NULL) UnmapViewOfFile (pOutFile); if (pInFile != NULL) UnmapViewOfFile (pInFile);
		if (hOutMap != NULL) CloseHandle (hOutMap); if (hInMap != NULL) CloseHandle (hInMap);
		if (hIn != INVALID_HANDLE_VALUE) CloseHandle (hIn); if (hOut != INVALID_HANDLE_VALUE) CloseHandle (hOut);

		/* Usuwanie pliku wyjciowego, jeli operacja zakoczya si niepowodzeniem. */
		if (!complete)
			DeleteFile (fOut);
		return FALSE;
	}
}
