/* Rozdzia 5. cci_fDll.c. */
/* Jest to program cci_f.c z rozdziau 2. przeksztacony na bibliotek DLL. */
#include "Everything.h"

#define BUF_SIZE 256

/* Poniszy wiersz [__declspec (dllexport)] to jedyna zmiana w porwnaniu z programem cci_f.c. */
/* Oglnie naley uy jednej funkcji i zmiennej preprocesora */
/* do okrelenia, czy funkcja ta jest eksportowana. */

__declspec (dllexport)
BOOL __cdecl cci_f (LPCTSTR fIn, LPCTSTR fOut, DWORD shift)
/* Funkcja stosujca szyfr Cezara - prosta implementacja:
*		fIn:		cieka do pliku rdowego
*		fOut:		cieka do pliku docelowego
*		shift:		przesunicie liczbowe
*	Dziaanie oparto na funkcji CopyFile. */
{
	HANDLE hIn, hOut;
	DWORD nIn, nOut, iCopy;
	CHAR aBuffer [BUF_SIZE], ccBuffer [BUF_SIZE];
	BOOL WriteOK = TRUE;

	hIn = CreateFile (fIn, GENERIC_READ, 0, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
	if (hIn == INVALID_HANDLE_VALUE) return FALSE;

	hOut = CreateFile (fOut, GENERIC_WRITE, 0, NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);
	if (hOut == INVALID_HANDLE_VALUE) return FALSE;

	__try
	{
		while (WriteOK && ReadFile (hIn, aBuffer, BUF_SIZE, &nIn, NULL) && nIn > 0) {
			for (iCopy = 0; iCopy < nIn; iCopy++)
				ccBuffer[iCopy] = (BYTE)(aBuffer[iCopy] + shift) % 256;
			WriteOK = WriteFile (hOut, ccBuffer, nIn, &nOut, NULL);
		}
	}
	__except(GetExceptionCode() == EXCEPTION_IN_PAGE_ERROR ? EXCEPTION_EXECUTE_HANDLER : EXCEPTION_CONTINUE_SEARCH)
	{
		WriteOK = FALSE;
	}

	CloseHandle (hIn);
	CloseHandle (hOut);

	return WriteOK;
}
