/* Rozdzia 5. cci - wersja z doczaniem w czasie wykonywania programu. Szyfr Cezara. */
/* cciEL przesunicie plik1 plik2 BibliotekaDLL
	Biblioteka DLL jest wczytywana, aby udostpni funkcj cci_f. */

/* Ten program ilustruje:
	1. Doczanie bibliotek DLL w czasie wykonywania programu. */

#include "Everything.h"

int _tmain (int argc, LPTSTR argv[])
{
	BOOL (__cdecl *cci_f) (LPCTSTR, LPCTSTR, DWORD);
	HMODULE hDLL;
	FARPROC pcci;
	TCHAR YNResp[5] = YES;

	if (argc < 5)
		ReportError (_T("Stosowanie: cciEL przesuniecie plik1 plik2 BibliotekaDLL"), 1, FALSE);

	/* Wczytywanie funkcji szyfrujcej. */
	hDLL = LoadLibrary (argv[4]);
	if (hDLL == NULL)
		ReportError (_T("Nieudane wczytywanie biblioteki DLL."), 4, TRUE);

	/*  Pobieranie adresu punktu wejcia. */
	pcci = GetProcAddress (hDLL, _T("cci_f"));
	if (pcci == NULL)
		ReportError (_T ("Nie mozna znalezc punktu wejscia."), 5, TRUE);
	cci_f = (BOOL (__cdecl *)(LPCTSTR, LPCTSTR, DWORD)) pcci;

	/*  Wywoywanie funkcji. */
 
	if (!cci_f (argv[2], argv[3], _ttoi(argv[1]) ) ) {
		FreeLibrary (hDLL);
		ReportError (_T ("Blad w funkcji cci."), 6, TRUE);
	}
	FreeLibrary (hDLL);
	return 0;
}
