/* Rozdzia 5. Polecenie sortMM. Wersja z odwzorowywaniem w pamici. */

/*  sortMM [opcje] [plik]
Sortuje jeden plik. Rozszerzenie o obsug wielu plikw jest proste, ale pominito je w tym miejscu.
Ta wersja tworzy plik indeksu i sama w sobie nie sortuje pliku.

Opcje:
-r	sortowanie w odwrotnej kolejnoci.
-I	korzystanie z istniejcego pliku indeksu do wygenerowania posortowanego pliku.

Ta prosta implementacja sortuje na podstawie pierwszego pola.
Pole z kluczem obejmuje osiem znakw i rozpoczyna si od pozycji 0. */

/* Ten program ilustruje:
1.	Odwzorowywanie plikw w pamici.
2.	Korzystanie z funkcji do przetwarzania acuchw znakw w pamici dla pliku odwzorowanego w pamici.
3.	Wskaniki z baz. */

/* Technika:
1.	Odwzorowywanie pliku wejciowego (pliku do posortowania).
2.	Standardowe przetwarzanie znakw, przegldanie pliku wejciowego,
    umieszczanie kadego klucza (maj one stay rozmiar) w rekordzie w pliku indeksu
    (pliku wejciowym o przyrostku .idx).
    Plik indeksu jest tworzony za pomoc operacji wejcia-wyjcia. Pniej plik zostanie odwzorowany.
3.	Umieszczanie pozycji pocztkowej rekordu w rekordzie w pliku indeksu.
    Jest to wskanik z baz do odwzorowanego pliku wejciowego.
4.	Odwzorowywanie pliku indeksu.
5.	Uywanie funkcji qsort z biblioteki jzyka C do sortowania pliku indeksu
    (zawiera on rekordy o staej dugoci skadajce si z klucza i wskanikw z baz).
6.	Przegldanie posortowanego pliku indeksu i umieszczanie rekordw pliku wejciowego w odpowiedniej kolejnoci.
7.	Przy ustawionej opcji -I mona pomin kroki 2., 3., i 5.
    Warto zauway, e technika ta wymaga wskanikw z baz. */

#include "Everything.h"

int KeyCompare (LPCTSTR, LPCTSTR);
VOID CreateIndexFile (LARGE_INSTEGER, LPCTSTR, LPTSTR);
DWORD_PTR kStart = 0, kSize = 8; 	/* Pozycja pocztkowa i rozmiar (TCHAR) klucza. */
BOOL reverse;

int _tmain (int argc, LPTSTR argv [])
{
	/* Plik to pierwszy argument. Sortowanie odbywa si w miejscu. */
	/* Sortowanie odbywa si za pomoc odwzorowywania plikw w pamici. */

	HANDLE hInFile, hInMap;	/* Uchwyty pliku wejciowego. */
	HANDLE hXFile, hXMap;	/* Uchwyty pliku indeksu. */
	HANDLE hStdOut = GetStdHandle (STD_OUTPUT_HANDLE);
	BOOL idxExists, noPrint;
	DWORD indexSize, rXSize, iKey, nWrite;
	LARGE_INTEGER inputSize;
	LPTSTR pInFile = NULL;
	LPBYTE pXFile = NULL, pX; 
	TCHAR __based (pInFile) *pIn, indexFileName[MAX_PATH+1], ChNewLine = _T('\n');
	int FlIdx;

	/* Wykrywanie opcji. */
	FlIdx = Options (argc, argv, _T ("rIn"), &reverse, &idxExists, &noPrint, NULL);
	if (FlIdx >= argc)
		ReportError (_T ("Brak nazwy pliku w wierszu polecen."), 1, FALSE);

	/* Krok 1. Otwieranie i odwzorowywanie pliku wejciowego. */
	hInFile = CreateFile (argv[FlIdx], GENERIC_READ | GENERIC_WRITE,
		0, NULL, OPEN_EXISTING, 0, NULL);
	if (hInFile == INVALID_HANDLE_VALUE)
		ReportError (_T ("Nieudane otwieranie pliku wejsciowego."), 2, TRUE);

	/* Odwzorowywanie obiektu odwzorowania pliku. Wykorzystanie rozmiaru pliku. */
	hInMap = CreateFileMapping (hInFile, NULL, PAGE_READWRITE, 0, 0, NULL);
	if (hInMap == NULL)
		ReportError (_T ("Nieudane tworzenie odwzorowania pliku wejsciowego."), 3, TRUE);
	pInFile = MapViewOfFile (hInMap, FILE_MAP_ALL_ACCESS, 0, 0, 0);
	if (pInFile == NULL)
		ReportError (_T ("Nieudane odwzorowywanie pliku wejsciowego."), 4, TRUE);

	if (!GetFileSizeEx (hInFile, &inputSize))
		ReportError (_T("Nieudane pobieranie rozmiaru pliku."), 5, TRUE);

	/* Tworzenie nazwy pliku indeksu. */
	_stprintf_s (indexFileName, MAX_PATH, _T("%s.idx"), argv [FlIdx]);

	/* Kroki 2. i 3. (jeli to konieczne). */
	if (!idxExists)
		CreateIndexFile (inputSize, indexFileName, pInFile);

	/* Krok 4. Odwzorowanie pliku indeksu. */
	hXFile = CreateFile (indexFileName, GENERIC_READ | GENERIC_WRITE,
		0, NULL, OPEN_EXISTING, 0, NULL);
	if (hXFile == INVALID_HANDLE_VALUE)
		ReportError (_T ("Nieudane otwieranie istniejacego pliku indeksu."), 6, TRUE);

	/* Odwzorowywanie obiektu odwzorowania pliku. Wykorzystanie rozmiaru pliku. */
	hXMap = CreateFileMapping (hXFile, NULL, PAGE_READWRITE, 0, 0, NULL);
	if (hXMap == NULL)
		ReportError (_T ("Nieudane tworzenie odwzorowania pliku indeksu."), 7, TRUE);
	pXFile = MapViewOfFile (hXMap, FILE_MAP_ALL_ACCESS, 0, 0, 0);
	if (pXFile == NULL)
		ReportError (_T ("Nieudane odwzorowywanie pliku indeksu."), 8, TRUE);
	indexSize = GetFileSize (hXFile, NULL); /* Zakadamy, e plik indeksu nie jest "bardzo duy". */
	/* Rozmiar rekordw indeksu - klucz plus wskanik. */
	rXSize = kSize * TSIZE + sizeof (LPTSTR);

	__try
	{
		/* Krok 5. Sortowanie pliku indeksu za pomoc funkcji qsort. */
		if (!idxExists)
			qsort (pXFile, indexSize / rXSize, rXSize, KeyCompare);

		/* Krok 6. Wywietlanie posortowanego pliku wejciowego. */
		/* Wskazywanie pierwszego wskanika w pliku indeksu. */
		pX = pXFile + rXSize - sizeof (LPTSTR);
		if (!noPrint) {
			for (iKey = 0; iKey < indexSize / rXSize; iKey++) {		
				WriteFile (hStdOut, &ChNewLine, TSIZE, &nWrite, NULL);

				/*	Rzutowanie wartoci pX jest wane, poniewa jest to wskanik do znaku,
				a potrzebne s cztero- lub omiobajtowe wskaniki z baz. */
				pIn = (TCHAR __based (pInFile)*) *(DWORD *)pX;
				while ((SIZE_T)pIn < (SIZE_T)inputSize.QuadPart && (*pIn != CR || *(pIn + 1) != LF)) {
					WriteFile (hStdOut, pIn, TSIZE, &nWrite, NULL);
					pIn++;
				}
				pX += rXSize; /* Przechodzenie do nastpnego wskanika w pliku indeksu. */
			}
			WriteFile (hStdOut, &ChNewLine, TSIZE, &nWrite, NULL);
		}
	}
	__except(GetExceptionCode() == EXCEPTION_IN_PAGE_ERROR ? EXCEPTION_EXECUTE_HANDLER : EXCEPTION_CONTINUE_SEARCH)
	{
		ReportError(_T("Blad krytyczny przy dostepie do odwzorowanego pliku."), 9, TRUE);
	}

	/* Gotowe. Zwalnianie wszystkich uchwytw i odwzorowa. */
	UnmapViewOfFile (pInFile);
	CloseHandle (hInMap); CloseHandle (hInFile);
	UnmapViewOfFile (pXFile);
	CloseHandle (hXMap); CloseHandle (hXFile);
	return 0;
}

VOID CreateIndexFile (LARGE_INTEGER inputSize, LPCTSTR indexFileName, LPTSTR pInFile)

/* Wykonywanie krokw 2. i 3., jak zdefiniowano to w opisie programu. */
/* Te etapy zostan pominite, jeli opcje powoduj uycie istniejcego pliku indeksu. */
{
	HANDLE hXFile;
	TCHAR __based (pInFile) *pInScan = 0;
	DWORD nWrite;

	/* Krok 2. Tworzenie pliku indeksu.
	   Nie jeszcze odwzorowywa pliku, poniewa jego dugo jest nieznana. */
	hXFile = CreateFile (indexFileName, GENERIC_READ | GENERIC_WRITE,
		FILE_SHARE_READ, NULL, CREATE_ALWAYS, 0, NULL);
	if (hXFile == INVALID_HANDLE_VALUE)
		ReportError (_T ("Nieudane tworzenie pliku indeksu."), 10, TRUE);

	/* Krok 3. Przegldanie kompletnego pliku i zapisywanie kluczy oraz wskanikw do
	   rekordw do pliku z kluczami. */
	while ((DWORD_PTR) pInScan < inputSize.QuadPart) {
		WriteFile (hXFile, pInScan + kStart, kSize * TSIZE, &nWrite, NULL);
		WriteFile (hXFile, &pInScan, sizeof (LPTSTR), &nWrite, NULL);
		while ((DWORD) (DWORD_PTR)pInScan < inputSize.QuadPart - sizeof(TCHAR) && 
				((*pInScan != CR) || (*(pInScan + 1) != LF))) {
			pInScan++; /* Przejcie do koca wiersza. */
		}
		pInScan += 2; /* Przejcie poza znaki CR, LF. */
	}
	CloseHandle (hXFile);
	return;
}

int KeyCompare (LPCTSTR pKey1, LPCTSTR pKey2)

/* Porwnywanie dwc rekordw ze znakami uniwersalnymi.
   Pozycja i dugo klucza to zmienne globalne. */
{
	DWORD i;
	TCHAR t1, t2;
	int Result = 0;
	for (i = kStart; i < kSize + kStart && Result == 0; i++) {
		t1 = *pKey1;
		t2 = *pKey2;
		if (t1 < t2)
			Result = -1;
		if (t1 > t2) 
			Result = +1;
		pKey1++;
		pKey2++;
	}
	return reverse ? -Result : Result;
}
