/* Rozdzia 5. SortHP. Sortowanie pliku za pomoc stert.
	sortHP pliki */

/* Ten program ilustruje:
	1.	Wykorzystanie algorytmw opartych na pamici (qsort).
	2.	Wykorzystanie stert do alokowania i usuwania struktur.
	3.	Wywietlanie posortowanego pliku jako jednego acucha znakw.
	4.	Blok try-except do wykonywania operacji porzdkowych
		przy normalnym koczeniu pracy lub po wystpieniu wyjtku. */

/*  OGRANICZENIE: plik nie jest "bardzo duy" (ma mniej ni 4 gigabajty). */

#include "Everything.h"	/* Definicje struktury rekordu z sortowanego pliku. */
#define DATALEN 56	/* Prawidowa dugo dla plikw prezydenci.txt i krolowie.txt. */
#define KEYLEN 8

typedef struct _RECORD {
	TCHAR Key [KEYLEN];
	TCHAR Data [DATALEN];
} RECORD;

#define RECSIZE sizeof (RECORD)
typedef RECORD * LPRECORD;

int KeyCompare (LPCTSTR, LPCTSTR);

int _tmain (int argc, LPTSTR argv [])
{
	/* Plik to pierwszy argument. Sortowanie odbywa si w miejscu. */
	/* Sortowanie odbywa si na stertach w pamici. */

	HANDLE hFile = INVALID_HANDLE_VALUE;
	HANDLE hStdOut = GetStdHandle (STD_OUTPUT_HANDLE);
	HANDLE SortHeap = NULL;
	LPBYTE pRecords = NULL;
	DWORD Result = 2, fsLow, nRead;
	LARGE_INTEGER fileSize;
	BOOL NoPrint;
	int iFirstFile, iF;

	iFirstFile = Options (argc, argv, _T ("n"), &NoPrint, NULL);

	if (argc <= iFirstFile)
		ReportError (_T ("Stosowanie: sortHP [opcje] pliki"), 1, FALSE);
		
 for (iF = iFirstFile; iF < argc; iF++)
__try {  /* Blok try-except. */
			/* Otwieranie pliku (uywanie tymczasowej kopii). */
	hFile = CreateFile (argv [iF], GENERIC_READ | GENERIC_WRITE,
			0, NULL, OPEN_EXISTING, 0, NULL);
	if (hFile == INVALID_HANDLE_VALUE)
		ReportException (_T ("Nieudane otwieranie pliku wejsciowego."), 2);
			/* Pobieranie rozmiaru pliku. */
	if (!GetFileSizeEx (hFile, &fileSize))
		ReportException (_T ("Blad pobierania rozmiaru pliku."), 3);
	fsLow = fileSize.LowPart;
	if (fileSize.HighPart != 0)
		ReportException (_T ("Plika ma wiecej niz 4 gigabajty i nie mozna go przetworzyc."), 3);
	/* Alokowanie bufora na kompletny plik
				zakoczony znakiem pustym i z wolnym miejscem. */
	SortHeap = HeapCreate (HEAP_GENERATE_EXCEPTIONS | HEAP_NO_SERIALIZE,
			2 * fsLow, 0);
	pRecords = HeapAlloc (SortHeap, HEAP_GENERATE_EXCEPTIONS | HEAP_NO_SERIALIZE, 
			fsLow + sizeof (TCHAR));
				/* Wczytywanie caego pliku. */
	if (!ReadFile (hFile, pRecords, fsLow, &nRead, NULL))
		ReportException (_T ("Blad odczytu sortowanego pliku."), 4);
	CloseHandle (hFile);
		/* Sortowanie pliku.
				Sortowanie za pomoc biblioteki jzyka C - w odwzorowanej pamici. */
	qsort (pRecords, fsLow/RECSIZE, RECSIZE, KeyCompare);
			/* Wywietlanie caego posortowanego pliku. 
			   Naley traktowa go jako pojedynczy acuch znakw. */
	*(pRecords + fsLow) = _T('\0');
	if (!NoPrint)
		PrintMsg (hStdOut, pRecords);
	HeapDestroy (SortHeap);
	SortHeap = NULL;

  }  /* Koniec wewntrznego bloku try-except. */

  __except (EXCEPTION_EXECUTE_HANDLER) {
	/* Przechwytywanie wyjtku. Okrela dowolny bd.
		   Jest to standardowe koczenie pracy. Usuwanie pliku tymczasowego
		   i zwalnianie wszystkich zasobw. */

	if (SortHeap != NULL)
		HeapDestroy (SortHeap);
	return 0;
  }
  return 0;

} /* Koniec procedury _tmain. */

int KeyCompare (LPCTSTR pRec1, LPCTSTR pRec2)
{
	DWORD i;
	TCHAR b1, b2;
	LPRECORD p1, p2;
	int Result = 0;

	p1 = (LPRECORD) pRec1;
	p2 = (LPRECORD) pRec2;
	for (i = 0; i < KEYLEN && Result == 0; i++) {
		b1 = p1->Key [i];
		b2 = p2->Key [i];
		if (b1 < b2)
			Result = -1;
		if (b1 > b2)
			Result = +1;
	}
	return Result;
}
