/* Rozdzia 5. sortFL. Sortowanie plikw z wykorzystanie odwzorowywania w pamici.
sortFL plik */

/* Ten program ilustruje:
1.	Korzystanie z algorytmu opartego na pamici (qsort) i pliku odwzorowanego w pamici.
2.	Wywietlanie odwzorowanego pliku jako jednego acucha znakw.
3.	Blok try-except do wykonywania operacji porzdkujcych (tu jest to usuwanie pliku tymczasowego)
    przy standardowym koczeniu pracy lub po wystpieniu wyjtku. */

#include "Everything.h"

/* Definicje struktury rekordu z sortowanego pliku. */

#define DATALEN 56
#define KEY_SIZE 8

typedef struct _RECORD {
	TCHAR key[KEY_SIZE];
	TCHAR data[DATALEN];
} RECORD;

#define RECSIZE sizeof (RECORD)
typedef RECORD * LPRECORD;
int KeyCompare (LPCTSTR, LPCTSTR);

int _tmain (int argc, LPTSTR argv[])
{
	/* Plik to pierwszy argument. Sortowanie odbywa si w miejscu. */
	/* Przy sortowaniu wykorzystano odwzorowywanie plikw w pamici. */

	HANDLE hFile = INVALID_HANDLE_VALUE, hMap = NULL;
	HANDLE hStdOut = GetStdHandle (STD_OUTPUT_HANDLE);
	LPVOID pFile = NULL;
	DWORD result = 2;
	TCHAR tempFile[MAX_PATH];
	LPTSTR pTFile;
	LARGE_INTEGER fileSize;

	BOOL NoPrint;
	int iFirstFile;

	iFirstFile = Options (argc, argv, _T ("n"), &NoPrint, NULL);

	if (argc <= iFirstFile)
		ReportError (_T ("Stosowanie: sortFL [opcje] pliki"), 1, FALSE);

	__try {	/* try-except */
		/* Kopiowanie pliku wejciowego do tymczasowego pliku wyjciowego, ktry zostanie posortowany.
		Nie naley zmienia pliku wejciowego. */
		_stprintf_s (tempFile, MAX_PATH, _T ("%s.tmp"), argv[iFirstFile]);
		CopyFile (argv[iFirstFile], tempFile, TRUE);

		result = 1; 	/* Plik tymczasowy jest nowy i naley go usun. */
		/* Otwieranie pliku (korzystanie z tymczasowej kopii). */
		hFile = CreateFile (tempFile, GENERIC_READ
			| GENERIC_WRITE, 0, NULL, OPEN_EXISTING, 0, NULL);
		if (hFile ==INVALID_HANDLE_VALUE)
			ReportException (_T ("Nieudana proba otwarcia pliku."), 2);

		/* Pobieranie rozmiaru pliku.
		Jeli plik jest zbyt duy, naley wykry to w czasie odwzorowywania go. */
		if (!GetFileSizeEx (hFile, &fileSize))
			ReportException (_T ("Nieudane wywolanie funkcji GetFileSizeEx."), 2);

		if (fileSize.QuadPart == 0) { /* Nie ma danych do sortowania. */
			CloseHandle (hFile);
			return 0;	/* Mona wywietli tu komunikat. */
		}
		/* Tworzenie obiektu odwzorowania pliku.
		Naley wykorzysta rozmiar pliku, ale doda miejsce na znak pusty. */

		fileSize.QuadPart += 2;
		if (fileSize.HighPart > 0 && sizeof(SIZE_T) == 4)
			ReportException (_T ("Plik jest za duy dla systemu Win32."), 4);

		hMap = CreateFileMapping (hFile, NULL, PAGE_READWRITE, fileSize.HighPart, fileSize.LowPart, NULL);
		if (hMap == NULL)
			ReportException (_T ("Nieudane tworzenie odwzorowania pliku."), 3);

		pFile = MapViewOfFile (hMap, FILE_MAP_ALL_ACCESS, 0, 0, 0);
		
		if (pFile == NULL) 
			ReportException (_T ("Nieudane wywolanie funkcji MapView."), 4);

		/* Teraz mona posortowa plik.
		Sortowanie za pomoc biblioteki jzyka C - w odwzorowanej pamici. */
		__try {
			qsort (pFile, (SIZE_T)fileSize.QuadPart / RECSIZE, RECSIZE, KeyCompare);

			/* Wywietlanie caego posortowanego pliku. 
			   Naley traktowa go jako pojedynczy acuch znakw. */
			pTFile = (LPTSTR) pFile;

			if (!NoPrint)
				while (pTFile < (LPTSTR) pFile + fileSize.QuadPart)
			{
				_tprintf (_T("%s\n"), pTFile);
				pTFile = pTFile+sizeof (RECORD);
			}
		}
		__except(GetExceptionCode() == EXCEPTION_IN_PAGE_ERROR ? EXCEPTION_EXECUTE_HANDLER : EXCEPTION_CONTINUE_SEARCH)
		{
			ReportError(_T("Blad krytyczny przy dostepie do odwzorowanego pliku."), 9, TRUE);
		}

		/* Informuje o udanym zakoczeniu. */
		result = 0; 			 
		ReportException (EMPTY, 5); /* Wymusza wyjtek w celu wykonania operacji porzdkowych. */
		return 0;
	} /* Koniec wewntrznego bloku try-except. */

	__except (EXCEPTION_EXECUTE_HANDLER) {

		/* Przechwytywanie wyjtku. Okrela dowolny bd.
		   Jest to standardowe koczenie pracy. Usuwanie pliku tymczasowego
		   i zwalnianie wszystkich zasobw. */

		if (pFile != NULL)
			UnmapViewOfFile (pFile);
		if (hMap != NULL)
			CloseHandle (hMap);
		if (hFile != INVALID_HANDLE_VALUE)
			CloseHandle (hFile);
		if (result != 2)
			DeleteFile (tempFile);
		return result;
	}
} /* Koniec procedury _tmain */

/*  KOD OD TEGO MIEJSCA NIE JEST UMIESZCZONY W TEKCIE. */

int KeyCompare (LPCTSTR pKey1, LPCTSTR pKey2)

/* Porwnywanie dwch rekordw znakw uniwersalnych.
   Pozycja i dugo klucza to zmienne globalne. */
{
	return _tcsncmp (pKey1, pKey2, KEY_SIZE);
}

