/* Rozdzia 5. Polecenie sortBT. Wersja z drzewem binarnym. */

/* sort pliki
	Sortuje jeden lub kilka plikw.
	Ta prosta implementacja sortuje tylko na podstawie pierwszego pola.
	Zaoono, e dugo pola z kluczem jest staa i wynosi 8 znakw.
	Pole z danymi zawiera acuchy znakw o zmiennej dugoci. */

/* Ten program ilustruje:
	1.	Wiele niezalenych stert - jedn na wzy drzewa sortowania, a inne
		na rekordy.
	2.	Uywanie funkcji HeapDestroy do zwolnienia caej struktury danych w jednej operacji.
	3.	Ustrukturyzowana obsuga wyjtkw pozwala przechwyci bdy alokacji pamici. */

/* Technika:
	1.	Skanowanie pliku wejciowego i umieszczanie kadego klucza (o staym rozmiarze)
		w binarnym drzewie wyszukiwania, a kadego rekordu - na stercie.
	2. 	Przechodzenie po drzewie wyszukiwania i wywietlanie rekordw w odpowiedniej kolejnoci.
	3. 	Usuwanie sterty i powtarzanie operacji dla nastpnego pliku. */

#include "Everything.h"

#define KEY_SIZE 8

	/* Definicja struktury na wzy drzewa. */

typedef struct _TREENODE {
	struct _TREENODE *Left, *Right;
	TCHAR key[KEY_SIZE];
	LPTSTR pData;
} TREENODE, *LPTNODE, **LPPTNODE;

#define NODE_SIZE sizeof (TREENODE)
#define NODE_HEAP_ISIZE 0x8000
#define DATA_HEAP_ISIZE 0x8000
#define MAX_DATA_LEN 0x1000
#define TKEY_SIZE KEY_SIZE * sizeof (TCHAR)
#define STATUS_FILE_ERROR 0xE0000001    // Wyjtek klienta.

LPTNODE FillTree (HANDLE, HANDLE, HANDLE);
BOOL Scan (LPTNODE);
int KeyCompare (LPCTSTR, LPCTSTR), iFile; /* Na potrzeby dostpu w procedurze obsugi wyjtkw. */
BOOL InsertTree (LPPTNODE, LPTNODE);

int _tmain (int argc, LPTSTR argv[])
{
	HANDLE hIn = INVALID_HANDLE_VALUE, hNode = NULL, hData = NULL;
	LPTNODE pRoot;
	BOOL noPrint;
	CHAR errorMessage[256];
	int iFirstFile = Options (argc, argv, _T ("n"), &noPrint, NULL);

	if (argc <= iFirstFile)
		ReportError (_T ("Stosowanie: sortBT [opcje] pliki"), 1, FALSE);
					/* Przetwarza pliki podane w wierszu polece. */
	for (iFile = iFirstFile; iFile < argc; iFile++) __try {
					/* Otwieranie pliku wejciowego. */
		hIn = CreateFile (argv[iFile], GENERIC_READ, 0, NULL, OPEN_EXISTING, 0, NULL);
		if (hIn == INVALID_HANDLE_VALUE)
			RaiseException (STATUS_FILE_ERROR, 0, 0, NULL);
		
		__try {
			/* Alokowanie dwch rozszerzalnych stert. */
			hNode = HeapCreate ( 
				HEAP_GENERATE_EXCEPTIONS | HEAP_NO_SERIALIZE, NODE_HEAP_ISIZE, 0);
			hData = HeapCreate (
				HEAP_GENERATE_EXCEPTIONS | HEAP_NO_SERIALIZE, DATA_HEAP_ISIZE, 0);
		
			/* Przetwarzanie pliku wejciowego i tworzenie drzewa. */
			pRoot = FillTree (hIn, hNode, hData);

			/* Wywietlanie drzewa wedug kluczy. */
			if (!noPrint) {
				_tprintf (_T ("Posortowany plik: %s\n"), argv[iFile]);
				Scan (pRoot);
			} 

		} __finally { /* Uchwyty stert i pliku zawsze s zamykane. */
			/* Usuwanie dwch stert i struktur danych. */
			if (hNode != NULL) HeapDestroy (hNode);
			if (hNode != NULL) HeapDestroy (hData);
			hNode = NULL; hData = NULL;
			if (hIn != INVALID_HANDLE_VALUE) CloseHandle (hIn);
			hIn = INVALID_HANDLE_VALUE;
		}

	} /* Koniec gwnej ptli do przetwarzania pliku i bloku try. */
	/* Obsuga oczekiwanych wyjtkw  bdw przetwarzania pliku lub wyczerpania pamici. */
	__except ( (GetExceptionCode() == STATUS_FILE_ERROR || GetExceptionCode() == STATUS_NO_MEMORY)
				? EXCEPTION_EXECUTE_HANDLER : EXCEPTION_CONTINUE_SEARCH)
	{
		_stprintf (errorMessage, _T("\n%s %s"), _T("Program sortBT. Blad w pliku:"), argv[iFile]);
		ReportError (errorMessage, 0, TRUE);
	}
	return 0;
}

LPTNODE FillTree (HANDLE hIn, HANDLE hNode, HANDLE hData)

/* Skanowanie pliku wejciowego i tworzenie binarnego drzewa wyszukiwania na
	stercie hNode ze wskanikami do sterty hData. */
/* Wykorzystanie procedury obsugi wyjtkw z programu wywoujcego. */
{
	LPTNODE pRoot = NULL, pNode;
	DWORD nRead, i;
	BOOL atCR;
	TCHAR dataHold[MAX_DATA_LEN];
	LPTSTR pString;
					
	while (TRUE) {
		pNode = HeapAlloc (hNode, HEAP_ZERO_MEMORY, NODE_SIZE);
		pNode->pData = NULL;
		(pNode->Left) = pNode->Right = NULL;
					/* Wczytywanie klucza. */
		if (!ReadFile (hIn, pNode->key, TKEY_SIZE,
				&nRead, NULL) || nRead != TKEY_SIZE)
					/* Zakadamy, e bd oznacza koniec pliku. Wszystkie rekordy musz mie odpowiedni rozmiar. */
			return pRoot;	/* Wczytywanie danych do czasu dojcia do koca pliku. */
		atCR = FALSE; 		/* Ostatnim znakiem nie jest CR. */

		for (i = 0; i < MAX_DATA_LEN; i++) {
			ReadFile (hIn, &dataHold[i], TSIZE, &nRead, NULL);
			if (atCR && dataHold[i] == LF) break;
			atCR = (dataHold[i] == CR);
		}
		dataHold[i - 1] = _T('\0');

		/* Tablica dataHold przechowuje dane bez klucza.
			Naley poczy klucze i dane. */

		pString = HeapAlloc (hData, HEAP_ZERO_MEMORY,
				(SIZE_T)(KEY_SIZE + _tcslen (dataHold) + 1) * TSIZE);
		memcpy (pString, pNode->key, TKEY_SIZE);
		pString[KEY_SIZE] = _T('\0');
		_tcscat (pString, dataHold);
		pNode->pData = pString;
				/* Wstawianie nowego wza do drzewa wyszukiwania. */
		InsertTree (&pRoot, pNode);

	} /* Koniec ptli while (TRUE). */
	return NULL; /* Niepowodzenie. */
}

BOOL InsertTree (LPPTNODE ppRoot, LPTNODE pNode)

/* Wstawianie nowego wza (pNode) do binarnego drzewa wyszukiwania (pRoot). */
{
	if (*ppRoot == NULL) {
		*ppRoot = pNode;
		return TRUE;
	}
	if (KeyCompare (pNode->key, (*ppRoot)->key) < 0)
		InsertTree (&((*ppRoot)->Left), pNode);
	else
		InsertTree (&((*ppRoot)->Right), pNode);
	return TRUE;
}

int KeyCompare (LPCTSTR pKey1, LPCTSTR pKey2)

/* Porwnywanie dwch rekordw ze znakami uniwersalnymi.
	Pozycja klucza i dugo to zmienne globalne. */
{
	return _tcsncmp (pKey1, pKey2, KEY_SIZE);
}

static BOOL Scan (LPTNODE pNode)

/* Przegldanie i wywietlanie zawartoci drzewa binarnego. */
{
	if (pNode == NULL)
		return TRUE;
	Scan (pNode->Left);
	_tprintf (_T ("%s\n"), pNode->pData);
	Scan (pNode->Right);
	return TRUE;
}
