// recordAccessMM.cpp : definiuje punkt wejcia na potrzeby aplikacji konsolowej.
//
//  Copyright 2004-2009, JMH Associates, Inc.
//
/*	Oparte na programie recordAccessMM z rozdziau 3. z trzeciego wydania ksiki - wersja z odwzorowywaniem w pamici. */
/*	Demonstruje proste zarzdzanie rekordami w pliku.
	Plik zawiera dowoln liczb rekordw (liczba ta jest okrelona
	w wierszu polece). Kady rekord obejmuje acuch znakw o ograniczonej dugoci,
	czas utworzenia i ostatniej aktualizacji oraz liczb aktualizacji.
	Plik ma 8-bajtowy nagwek z czn liczb miejsc na rekordy
	i czn liczb niepustych rekordw.
	Uytkownik moe interaktywnie tworzy, aktualizowa i modyfikowa
	rekordy.
	Stosowanie: recordAccessMM NazwaPliku [LiczbaRekordw [prompt]]
	Jeli nie podano parametru liczbaRekordw, plik NazwaPliku musi ju istnie. 
		Jeeli liczbaRekordw > 0, plik NazwaPliku jest odtwarzany (istniejcy plik zostaje usunity),
		   a program koczy dziaanie po utworzeniu pustego pliku.
		Jeli okrelony jest parametr prompt, interakcja z uytkownikiem jest blokowana. Jest to przydatne, jeli
		   polecenia wejciowe s przekierowywane z pliku, jak ma to miejsce w testach wydajnoci
		  [na przykad w pliku RecordAccessTIME.bat].

		Jeli liczba rekordw jest dua, zalecany jest plik rzadki.
		Uyte tu techniki mona te wykorzysta, jeli do okrelania lokalizacji 
		rekordu suy funkcja haszujca (jest to proste wzbogacenie programu). */

/* Ten program ilustruje:
		1. Bezporedni dostp do pliku.
		2. Arytmetyk na wartociach typu LARGE_INTEGER i stosowanie 64-bitowych pozycji w pliku. 
		3. Aktualizowanie rekordw w miejscu.
		4. Inicjowanie pliku wartoci 0 (nie zadziaa w systemach Windows 9x
			ani w systemie plikw FAT). 
*/
#include "Everything.h"

#define STRING_SIZE 256
typedef struct _record { /* Struktura rekordw pliku. */
	DWORD			referenceCount;  /* 0 oznacza pusty rekord. */
	SYSTEMTIME		recordCreationTime;
	SYSTEMTIME		recordLastRefernceTime;
	SYSTEMTIME		recordUpdateTime;
	TCHAR			dataString[STRING_SIZE];
} record;
typedef struct _header { /* Nagwek pliku. */
	DWORD			numRecords;
	DWORD			numNonEmptyrecords;
} header;

int _tmain (int argc, LPTSTR argv [])
{
	HANDLE hFile;
	HANDLE hFileMap = INVALID_HANDLE_VALUE;
	char * pInFile = NULL;
	LARGE_INTEGER curPtr;
	DWORD openOption, nXfer, recNumber;
	record record;
	TCHAR String[STRING_SIZE], command, extra[2];
	OVERLAPPED ov = {0, 0, 0, 0, NULL}, ovZero = {0, 0, 0, 0, NULL};
	header header = {0, 0}; 
	SYSTEMTIME currentTime;
	BOOLEAN headerChange, recordChange;
    long recordSize = sizeof(record);
	long headerSize = sizeof(header);
	int prompt = (argc <= 3) ? 1 : 0;

	// Ten fragment jest przydatny do przypomnienia, czy program zbudowano dla rodowiska 32- czy 64-bitowego.
	// _tprintf (_T("Rozmiar wskaznika: %d. Rozmiar typu LARGE_INTEGER: %d.\n"), sizeof(pInFile), sizeof(curPtr));

	if (argc < 2) {
		_tprintf (_T("Rozmiar rekordu = %d.\n"), recordSize);
		ReportError (_T("Stosowanie: recordAccessMM Plik [LiczbaRekordow [prompt]]"), 1, FALSE);
	}

	openOption = ((argc > 2 && _ttoi(argv[2]) <= 0) || argc <= 2) ? OPEN_EXISTING : CREATE_ALWAYS;
	hFile = CreateFile (argv [1], GENERIC_READ | GENERIC_WRITE,
		0, NULL, openOption, FILE_ATTRIBUTE_NORMAL, NULL);
	if (hFile == INVALID_HANDLE_VALUE)
		ReportError (_T("Blad programu RecordAccess: nie mozna otworzyc istniejacego pliku."), 2, TRUE);

	if (argc >= 3 && _ttoi(argv[2]) > 0)  { /* Zapis nagwka. */
#if 0
/* Po pierwsze, jeli to moliwe, naley utworzy plik rzadki - jest to zalecane dla duych plikw. */
	/*      Zadanie - spraw, aby rozwizanie to dziaao poprawnie. Moesz te utworzy plik rzadki */
	/*		metodami administracyjnymi. Ten kod pochodzi z kilku przykadw Microsoftu i */
	/*      nie dziaa w systemie XP Home Edition (nie obsuguje on plikw rzadkich). */

		DWORD FsFlags = 0;
		if (!GetVolumeInformation (_T("C:\\")), NULL, 0, NULL, NULL, &FsFlags , NULL, 0))
			ReportError (_T("Blad programu RecordAccess: funkcja GetVolumeInformation."), 3, TRUE);
		if (FsFlags & FILE_SUPPORTS_SPARSE_FILES) {
			if ((FsFlags & FILE_SUPPORTS_SPARSE_FILES) &&
				!DeviceIoControl (hFile, FSCTL_SET_SPARSE, NULL, 0, NULL, 0, &nXfer, NULL)) 
				ReportError (_T("Blad programu RecordAccess: tworzenie nowego rzadkiego pliku."), 0, TRUE);
		} 
		_tprintf (_T("Czy plik jest rzadki? %x\n"), 
			GetFileAttributes(argv[1]) & FILE_ATTRIBUTE_SPARSE_FILE);
#endif
		header.numRecords = _ttoi(argv[2]);
		if (!WriteFile(hFile, &header, headerSize, &nXfer, &ovZero))
			ReportError (_T("Blad programu RecordAccess: zapis naglowka."), 4, TRUE);
		
		curPtr.QuadPart = (LONGLONG)recordSize * _ttoi(argv[2]) + headerSize;
		if (!SetFilePointerEx (hFile, curPtr, NULL, FILE_BEGIN))
			ReportError (_T("Blad programu RecordAccess: ustawianie wskaznika."), 4, TRUE);
		if (!SetEndOfFile(hFile))
			ReportError (_T("Blad programu RecordAccess: ustawianie konca pliku."), 5, TRUE);
		if (prompt) _tprintf (_T("Utworzono pusty plik na %d rekordow.\n"), header.numRecords);

#if 0  // Nie jest to potrzebne. Plik jest rzadki, We don't need this; the file is sparse, co prowadzi do wyzerowania.
        /* Odwzorowywanie pliku. */
	    /* Tworzenie obiektu odwzorowania pliku dla pliku wejciowego. Wykorzystanie rozmiaru pliku. */
	    hFileMap = CreateFileMapping (hFile, NULL, PAGE_READWRITE, 0, 0, NULL);
	    if (hFileMap == INVALID_HANDLE_VALUE)
		    ReportException (_T("Nieudane tworzenie odwzorowania."), 2);

    	pInFile = (char *)MapViewOfFile (hFileMap, FILE_MAP_ALL_ACCESS, 0, 0, 0);
	    if (pInFile == NULL)
		    ReportException (_T("Nieudane odwzorowywanie pliku wejsciowego."), 3);
        memset(pInFile+headerSize, 0, header.numRecords * recordSize ); 
        
		UnmapViewOfFile(pInFile);
        CloseHandle(hFileMap);
#endif

	    CloseHandle(hFile);
	    return 0;
    }

	/* Odczyt nagwka w celu okrelenia liczby rekordw i liczby niepustych rekordw. */
	if (!ReadFile(hFile, &header, headerSize, &nXfer, &ovZero))
		ReportError (_T("Blad programu RecordAccess: odczyt naglowka."), 6, TRUE);
	if (prompt) _tprintf (_T("Plik %s zawiera %d niepustych rekordow o rozmiarze %d.\n Laczna pojemnosc: %d\n"),
		argv[1], header.numNonEmptyrecords, recordSize, header.numRecords);

    /* Odwzorowywanie pliku. */
	/* Tworzenie obiektu odwzorowania pliku dla pliku wejciowego. Wykorzystanie rozmiaru pliku. */
	hFileMap = CreateFileMapping (hFile, NULL, PAGE_READWRITE, 0, 0, NULL);
	if (hFileMap == INVALID_HANDLE_VALUE)
		ReportException (_T("Nieudane tworzenie odwzorowania."), 2);
	pInFile = (char *)MapViewOfFile (hFileMap, FILE_MAP_ALL_ACCESS, 0, 0, 0);
	if (pInFile == NULL)
		ReportException (_T("Nieudane odwzorowywanie pliku wejsciowego."), 3);


	/* Pytanie uytkownika o odczyt lub zapis rekordu o danym numerze. */
	while (TRUE) {
		headerChange = FALSE; recordChange = FALSE;
		if (prompt) _tprintf (_T("Wpisz: w(czytaj)/z(apisz)/u(sun)/ko(niec) numer rekordu\n"));
		_tscanf (_T("%1c%d%1c"), &command, &recNumber, &extra);
		if (command == _T('k')) break;
		if (recNumber >= header.numRecords) { 
			if (prompt) _tprintf (_T("Numer rekordu jest za duzy. Sprobuj ponownie.\n"));
			continue;
		}
		curPtr.QuadPart = (LONGLONG)recNumber * recordSize + headerSize;

		if (prompt) _tprintf (_T("Polecenie: %c: "), command, _T(" Rerkod numer: %d.\n"), recNumber);
        
		// Wczytywanie zawartoci rekordu.
		memcpy (&record, pInFile+curPtr.QuadPart, recordSize);

		GetSystemTime (&currentTime); /* Use to update record time fields */
		record.recordLastRefernceTime = currentTime;
		if (command == _T('w') || command == _T('u')) { /* Report record contents, if any */
			if (prompt) _tprintf (_T("O rekordzie numer: %d.\n"), recNumber);
			if (record.referenceCount == 0) {
				if (prompt) _tprintf (_T("Rekord numer %d jest pusty.\n"), recNumber);
				continue;
			} else {
				if (prompt) _tprintf (_T("Rekord numer %d. Liczba odwolan: %d \n"), 
					recNumber, record.referenceCount);
				if (prompt) _tprintf (_T("Dane: %s\n"), record.dataString);
				/* wiczenie: dodaj wywietlanie czasw. Zobacz na przykad program ls.c. */
				recordChange = TRUE;
			}
			if (command == _T('u')) { /* Delete the record */
				/* Challenge: In a sparse file, implement this with the
				   FSCTL_SET_ZERO_DATA flag on DeviceIoControl() */
				if (prompt) _tprintf (_T("About to delete this record.\n"));
				record.referenceCount = 0;
				header.numNonEmptyrecords--;
				headerChange = TRUE;
				recordChange = TRUE;
			}
		} else if (command == _T('z')) { /* Zapis rekordu (take za pierwszym razem). */
			if (prompt) _tprintf (_T("Wpisz nowy lancuch danych dla rekordu.\n"));
			_fgetts (String, sizeof(String), stdin); // Nie naley uywa _getts (grozi przepenieniem bufora).
			String[_tcslen(String)-1] = _T('\0'); // Usuwanie znaku nowego wiersza.
			if (record.referenceCount == 0) {
				record.recordCreationTime = currentTime;
				header.numNonEmptyrecords++;
				headerChange = TRUE;
			}
			record.recordUpdateTime = currentTime;
			record.referenceCount++;
			_tcsncpy_s (record.dataString, sizeof(record.dataString), String, STRING_SIZE-1);
			recordChange = TRUE;
			if (prompt) _tprintf (_T("Zapisano rekord numer: %d.\n"), recNumber);
			if (prompt) _tprintf (_T("Dane: %s.\n"), String);
		} else {
			if (prompt) _tprintf (_T("Polecenia to w, z i u. Sprobuj ponownie.\n"));
		}
		/* Aktualizowanie rekordu "w miejscu" przy zmianie jego zawartoci. */
		if (recordChange) {
			memcpy (pInFile+curPtr.QuadPart, &record, recordSize );//    !WriteFile (hFile, &record, sizeof (record), &nXfer, &ov))
			if (prompt) _tprintf (_T("Zaktualizowano rekord numer: %d w lokalizacji %ud. Liczba odwolan: %d\n"), recNumber, curPtr.QuadPart, record.referenceCount);
		}
		/* Aktualizowanie w razie potrzeby liczby niepustych rekordw. */
		if (headerChange) {
			memcpy (pInFile, &header, headerSize);
			if (prompt) _tprintf (_T("Zaktualizowano naglowek. Liczba niepustych rekordow = %d.\n"), header.numNonEmptyrecords);
		}
	}

	if (prompt) _tprintf (_T("Liczba niepustych rekordow wynosi: %d\n"), header.numNonEmptyrecords);
	if (!ReadFile(hFile, &header, headerSize, &nXfer, &ovZero))
		ReportError (_T("Blad programu RecordAccess: odczyt naglowka."), 10, TRUE);
	if (prompt) _tprintf (_T("Plik %s zawiera %d niepustych rekordow.\nPojemnosc: %d\n"),
		argv[1], header.numNonEmptyrecords, header.numRecords);

	if (NULL != pInFile) UnmapViewOfFile(pInFile);
	if (INVALID_HANDLE_VALUE != hFileMap) CloseHandle (hFileMap);
	CloseHandle (hFile);
	return 0;
}
