/* Clear.c  Program testowy. */
/* Czyci pami uywan w testach wydajnoci. */
/* Alokowanie bloku ze starty procesu.
	Naley podwoi rozmiar bloku przy powodzeniu i zmniejszy o poow przy niepowodzeniu. */

#include "Everything.h"

#define IBLOCK_SIZE 0x10000	/* Pocztkowy blok. */

int _tmain (int argc, LPTSTR argv [])
{
	HANDLE hHeap;
	LPVOID p;
	DWORD BlockSize = IBLOCK_SIZE, Total = 0, Number = 0;
	BOOL exit = FALSE;
	
	/* Pobieranie rozszerzalnej sterty.  */

	hHeap = HeapCreate (HEAP_GENERATE_EXCEPTIONS, 0X1000000, 0);

	while (BlockSize > 0) {
		__try {
			p = HeapAlloc (hHeap, 
			HEAP_NO_SERIALIZE | HEAP_ZERO_MEMORY | HEAP_GENERATE_EXCEPTIONS,
			BlockSize);
		}
		__except (EXCEPTION_EXECUTE_HANDLER) {
			p = NULL;
		}
		if (p == NULL) {
//			_tprintf (_T ("\nBlad.  Rozmiar bloku = %x"), BlockSize);
			BlockSize /= 2; /* Bd. Zmniejszanie rozmiaru bloku o poow. */
		}
		else { /* Powodzenie. Podwajanie rozmiaru bloku. */
//			_tprintf (_T ("\nPowodzenie. Rozmiar bloku = %x"), BlockSize);
			Number++;
			Total += BlockSize;
			BlockSize *= 2;
		}
	}

//	_tprintf (_T ("\nLaczna liczba alokacji = %x. Laczna liczba bajtow = %x"),
//			Number, Total);
	HeapDestroy (hHeap);
	return 0;
}
