/* Clear.c. Program testowy. */
/* Czyci pami uywan w testach wydajnoci. */
/* Alokowanie bloku ze starty procesu.
	Naley podwoi rozmiar bloku przy powodzeniu i zmniejszy o poow przy niepowodzeniu. */
/* Przestarzae wersje: ten program obejmuje dodatkowy kod, aby mg dziaa 
   w systemach Windows 9x (95, 98 i Me). */
/* 17 maja 2010. Dziaanie w systemach 64-bitowych jest niestabilne. */

#include "Everything.h"

#define IBLOCK_SIZE 0x10000000	/* Pocztkowy blok. */

static void clear95(void);

int _tmain (int argc, LPTSTR argv [])
{
	HANDLE hHeap;
	LPVOID p;
	DWORD blockSize = IBLOCK_SIZE;
	BOOL exit = FALSE;
	OSVERSIONINFO OSVer;
	BOOL Is2000NT;
	LONG64 totalAllocated = 0, numberAllocated = 0;

	/* Okrela, czy system to Windows 2000/NT.  */
	OSVer.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);
	if (!GetVersionEx (&OSVer)) 
		ReportError (_T("Nie mozna pobrac informacji o wersji systemu. %d"), 2, TRUE);

	Is2000NT = (OSVer.dwPlatformId == VER_PLATFORM_WIN32_NT);

	if (!Is2000NT) { /* Systemy Windows 95/98 trzeba traktowa inaczej. PRZESTARZAE - zobacz komentarze. */
		clear95();
		return 0;
	}
	/* Pobieranie rozszerzalnej sterty.  */
	hHeap = HeapCreate (0, 0, 0);

	while (blockSize > 0) {
		{
			p = HeapAlloc (hHeap, HEAP_NO_SERIALIZE | HEAP_ZERO_MEMORY, blockSize);
		}
		if (p == NULL) {
//			 _tprintf (_T ("\nBlad.   Rozmiar bloku = %u, liczba zaalokowanych blokow = %u, zaalokowane bajty = %u."), blockSize, numberAllocated, totalAllocated);
			blockSize = blockSize / 2; /* Bd. Zmniejszanie rozmiaru bloku o poow. */
		}
		else { /* Powodzenie. Podwajanie rozmiaru bloku. */
//			 _tprintf (_T ("\nPowodzenie.  Rozmiar bloku = %u, liczba zaalokowanych blokow = %u, zaalokowane bajty = %u."), blockSize, numberAllocated, totalAllocated);
			numberAllocated++;
			totalAllocated += blockSize;
			if (blockSize < 0x80000000) blockSize *= 2;
		}
	}

	_tprintf (_T ("\nLaczna liczba alokacji = %u. zaalokowane bajty = %u"),
			numberAllocated, totalAllocated);
	HeapDestroy (hHeap);
	return 0;
}

static void clear95(void)
/* Clear95. Program testowy. PRZESTARZAY. */
/*	Czyci pami uywan w testach wydajnoci.
	Ta wersja jest przeznaczona dla systemw Windows 95/98, poniewa wczeniejszy kod zajmuje
	przestrze na dysku, ktra jest zwalniana dopiero kilka sekund po zakoczeniu pracy programu.
	W tym czasie inne programy mog zawie z uwagi na brak miejsca na dysku.
	Wersja dla systemw Windows 9x nie jest tak agresywna - jedynie alokuje tyle
	blokw o staym rozmiarze, jak to moliwe, natomiast wersja dla systemw 2000/NT prbuje
	zaalokowa kady moliwy bajt. */
{

	HANDLE Heap;
	LPVOID p;
	DWORD AllocCount, HeapSize;
	BOOL exit = FALSE;
	MEMORYSTATUS MemStat;

	GlobalMemoryStatus(&MemStat);
	HeapSize = (DWORD)(MemStat.dwTotalPhys * .75);
	// _tprintf (_T("Clear95. Przestarzaly. Ilosc pamieci. %8x\n"), HeapSize);
	
		/* Tworzenie nierozszerzalnej sterty. */
	Heap = HeapCreate (HEAP_NO_SERIALIZE, HeapSize, HeapSize);
	if (Heap == NULL)
		ReportError (_T("Clear95. Przestarzaly. Nieudane tworzenie sterty."), 1, TRUE);
		/* Alokowanie elementw i niepowodzenie po wyczerpaniu pamici. */


	AllocCount = 0;
	
	__try {	/* try-finally */
	__try {	/* try-except */

	while (!exit) {
		p = HeapAlloc (Heap, HEAP_ZERO_MEMORY | HEAP_GENERATE_EXCEPTIONS,
				IBLOCK_SIZE);
		if (p == NULL) { /* Program nigdy nie powinien dotrze do tego miejsca, poniewa generowane s wyjtki. */
			exit = TRUE;
			ReportError (_T ("Clear95. Przestarzaly. Blad funkcji HeapAlloc."), 0, TRUE);
		}
		AllocCount++;
	}
	} /* Koniec bloku try-except. */

	__except (EXCEPTION_EXECUTE_HANDLER) {
		// _tprintf (_T ("Clear95. Przestarzaly. Wyjatek alokacji pamieci.\n"));
		if (!HeapDestroy (Heap))
			ReportError (_T ("Clear95. Przestarzaly. Blad usuwania sterty."), 0, TRUE);
	}
	} /* Koniec bloku try-finally. */

	__finally {
		// _tprintf (_T ("Clear95. Przestarzaly. Blok finally. AllocCount = %x\n"), AllocCount);
	}


	return;
}

