/* Rozdzia 4. Polecenie toupper.   */

/* 
	Przeksztacanie jednego lub kilku plikw przez zmian wszystkich liter na due.
	Plik wyjciowy ma t sam nazw, co wejciowy, ale
	z dodanym przedrostkiem UC_.  */

/* Ten program ilustruje:
	1.	Obsug wyjtkw w celu przywrcenia programu po wyjtkach i bdach czasu  
		wykonania zgaszanych za pomoc funkcji RaiseException).
	2.	Procedury obsugi zakoczenia.
	3.	Upraszczanie logiki programu za pomoc procedur obsugi. */

/* Technika:
	1.	Ptla przetwarza po jednym pliku.
	2.	Naley wczyta cay plik do pamici, alokujc najpierw pami i plik wyjciowy.
		NIE NALEY NADPISYWA ISTNIEJCEGO PLIKU.
	3. 	Przeksztacanie danych w pamici.
	4. 	Zapis przeksztaconych danych do pliku wyjciowego.
	5.  Zwalnianie pamici i zamykanie uchwytw plikw w kadej iteracji ptli. */

#include "Everything.h"

int _tmain (int argc, LPTSTR argv [])
{
	HANDLE hIn, hOut;
	DWORD FileSize, nXfer, iFile, j;
	CHAR OutFileName[256] = "", *pBuffer = NULL;
	OVERLAPPED ov = { 0, 0, 0, 0, NULL};

	if (argc <= 1)
		ReportError (_T ("Stosowanie: toupper pliki"), 1, FALSE);
					/* Przetwarzanie wszystkich plikw podanych w wierszu polece. */
	for (iFile = 1; iFile < argc; iFile++) __try { /* Blok wyjtku. */
		/*	Wszystkie uchwyty plikw s uniewanione, pBuffer == NULL, a zmienna 
			outFileName jest pusta. Gwarantuj to procedury obsugi. */
		_stprintf (OutFileName, "UC_%s", argv[iFile]);
		__try { /* Wewntrzny blok try-finally. */
			/* Tworzenie nazwy pliku wyjciowego i samego pliku (jeli plik istnieje, 
			   operacja koczy si niepowodzeniem). */
			hIn  = CreateFile (argv [iFile], GENERIC_READ, 0, NULL, OPEN_EXISTING, 0, NULL);
			if (hIn == INVALID_HANDLE_VALUE) ReportException (argv[iFile], 1);
			FileSize = GetFileSize (hIn, NULL); /* Zakadamy, e plik jest "may". */
			hOut = CreateFile (OutFileName, GENERIC_READ | GENERIC_WRITE, 0, NULL, 
				CREATE_NEW, 0, NULL);
			if (hOut == INVALID_HANDLE_VALUE) ReportException (OutFileName, 1);;
			/* Alokowanie pamici na zawarto pliku. */
			pBuffer = malloc (FileSize); 
			if (pBuffer == NULL) ReportException (_T("Blad alokacji pamieci."), 1);;

			/* Blokowanie obu plikw, aby zagwarantowa, e dane wyjciowe poprawnie */
			/* odzwierciedlaj w tym miejscu dane wejciowe. */
			/* Wczytywanie danych, przeksztacanie ich i zapisywanie do pliku wyjciowego. */
			/* Zwalnianie wszystkich zasobw po zakoczeniu i przetwarzanie nastpnego pliku. */
			/* Uytkownicy systemw Windows 9x powinni zmodyfikowa blokady. */
			if (!LockFileEx (hIn,  LOCKFILE_FAIL_IMMEDIATELY, 0, 0, 0, &ov))
				ReportException (_T("Blad blokowania pliku wejsciowego."), 1);
			if (!LockFileEx (hOut, LOCKFILE_FAIL_IMMEDIATELY, 0, FileSize, 0, &ov))
				ReportException (_T("Blad blokowania pliku wyjsciowego."), 1);

			if (!ReadFile (hIn, pBuffer, FileSize, &nXfer, NULL))
				ReportException (_T("Blad funkcji ReadFile."), 1);
			for (j = 0; j < FileSize; j++) /* Przeksztacanie danych. */
				if (isalpha(pBuffer[j])) pBuffer[j] = toupper(pBuffer[j]);
			if (!WriteFile (hOut, pBuffer, FileSize, &nXfer, NULL))
				ReportException (_T("Blad funkcji WriteFile."), 1);

		} __finally { /* Uchwyty plikw zawsze s zamykane, */
			/* pami  zwalniana, a uchwyty i wskanik  ponownie inicjowane. */
			if (pBuffer != NULL) free (pBuffer); pBuffer = NULL;
			if (hIn  != INVALID_HANDLE_VALUE) {
				CloseHandle (hIn);
				UnlockFileEx (hIn, 0, FileSize, 0, &ov);
			}
			if (hOut != INVALID_HANDLE_VALUE) {
				CloseHandle (hOut);
				UnlockFileEx (hOut, 0, FileSize, 0, &ov);
				hOut = INVALID_HANDLE_VALUE;
			}
			_tcscpy (OutFileName, _T(""));
		}
	} /* Koniec gwnej ptli przetwarzania plikw i bloku try. */
	/* Ta procedura obsugi wyjtkw dotyczy ciaa ptli. */

	__except (EXCEPTION_EXECUTE_HANDLER) {
		_tprintf (_T("Blad przetwarzania pliku %s\n"), argv[iFile]);
		DeleteFile (OutFileName);
	}
	_tprintf (_T("Przeksztalcono wszystkie pliki (oprocz wymienionych wyjatkow).\n"));
	return 0;
}

