/* Rozdzia 4. Polecenie toupper.   */

/* 
	Przeksztacanie jednego lub kilku plikw przez zmian wszystkich liter na due.
	Plik wyjciowy ma t sam nazw, co wejciowy, ale
	z dodanym przedrostkiem UC_. */

/* Ten program ilustruje:
	1.	Obsug wyjtkw w celu przywrcenia programu po wyjtkach i bdach czasu  
		wykonania zgaszanych za pomoc funkcji RaiseException).
	2.	Procedury obsugi zakoczenia.
	3.	Upraszczanie logiki programu za pomoc procedur obsugi. */

/* Technika:
	1.	Ptla przetwarza po jednym pliku.
	2.	Naley wczyta cay plik do pamici, alokujc najpierw pami i plik wyjciowy.
		NIE NALEY NADPISYWA ISTNIEJCEGO PLIKU.
	3. 	Przeksztacanie danych w pamici.
	4. 	Zapis przeksztaconych danych do pliku wyjciowego.
	5.  Zwalnianie pamici i zamykanie uchwytw plikw w kadej iteracji ptli. */

#include "Everything.h"

int _tmain (int argc, LPTSTR argv [])
{
	HANDLE hIn = INVALID_HANDLE_VALUE, hOut = INVALID_HANDLE_VALUE;
	DWORD nXfer, iFile, j;
	TCHAR outFileName[256] = _T(""), *pBuffer = NULL;
	OVERLAPPED ov = { 0, 0, 0, 0, NULL};
	LARGE_INTEGER fSize;

	if (!WindowsVersionOK (3, 1)) 
		ReportError (_T("Ten program wymaga systemu Windows NT 3.1 lub nowszego ze wzgledu na funkcje LockFileEx."),
		               1, FALSE);

	if (argc <= 1)
		ReportError (_T ("Stosowanie: toupper pliki"), 1, FALSE);
					/* Przetwarzanie wszystkich plikw podanych w wierszu polece. */
	for (iFile = 1; iFile < (unsigned int)argc; iFile++) __try { /* Blok wyjtku. */
		/*	Wszystkie uchwyty plikw s uniewanione, pBuffer == NULL, a zmienna 
			outFileName jest pusta. Gwarantuj to procedury obsugi. */
		if (_tcslen(argv[iFile]) > 250)
			ReportException(_T("Nazwa pliku jest zbyt dluga."), 1);
		_stprintf (outFileName, _T("UC_%s"), argv[iFile]);
		__try { /* Wewntrzny blok try-finally. */
			/* Tworzenie nazwy pliku wyjciowego i samego pliku (jeli plik istnieje, 
			   operacja koczy si niepowodzeniem). */
			/* Plik mog wspuytkowa inne procesy lub wtki. */
			hIn  = CreateFile (argv [iFile], GENERIC_READ, 
				0, NULL, OPEN_EXISTING, 0, NULL);
			if (hIn == INVALID_HANDLE_VALUE) ReportException (argv[iFile], 1);
			if (!GetFileSizeEx (hIn, &fSize) || fSize.HighPart > 0)
				ReportException(_T("Plik jest za duzy."), 1);
			hOut = CreateFile (outFileName, GENERIC_READ | GENERIC_WRITE, 
				0, NULL, CREATE_NEW, 0, NULL);
			if (hOut == INVALID_HANDLE_VALUE) ReportException (outFileName, 1);;
			/* Alokowanie pamici na zawarto pliku. */
			pBuffer = malloc (fSize.LowPart); 
			if (pBuffer == NULL) ReportException (_T("Blad alokacji pamieci."), 1);;

			/* Wczytywanie danych, przeksztacanie ich i zapisywanie do pliku wyjciowego. */
			/* Zwalnianie wszystkich zasobw po zakoczeniu zadania; przetwarzanie nastpnego pliku. */
			/* Pliki nie s blokowane, poniew s otwierane z parametrem 0 dla trybu
			 *     wspuytkowania. Jednak w oglniejszych sytuacjach proces
			 *     moe dziedziczy uchwyt pliku lub wtek moe uzyska dostp  
			 *     do uchwytu. Moliwe te, e programista chce otworzy plik
			 *     w trybie wspuytkowania. */

			if (!ReadFile (hIn, pBuffer, fSize.LowPart, &nXfer, NULL) || (nXfer != fSize.LowPart))
				ReportException (_T("Blad funkcji ReadFile."), 1);
			for (j = 0; j < fSize.LowPart; j++) /* Przeksztacanie danych. */
				if (isalpha(pBuffer[j])) pBuffer[j] = toupper(pBuffer[j]);
			if (!WriteFile (hOut, pBuffer, fSize.LowPart, &nXfer, NULL) || (nXfer != fSize.LowPart))
				ReportException (_T("Blad funkcji WriteFile."), 1);

		} __finally { /* Uchwyty plikw zawsze s zamykane, */
			/* pami  zwalniana, a uchwyty i wskanik  ponownie inicjowane. */
			if (pBuffer != NULL) free (pBuffer); pBuffer = NULL;
			if (hIn  != INVALID_HANDLE_VALUE) {
				CloseHandle (hIn);
				hIn  = INVALID_HANDLE_VALUE;
			}
			if (hOut != INVALID_HANDLE_VALUE) {
				CloseHandle (hOut);
				hOut = INVALID_HANDLE_VALUE;
			}
			_tcscpy (outFileName, _T(""));
		}
	} /* Koniec gwnej ptli przetwarzania plikw i bloku try. */
	/* Ta procedura obsugi wyjtkw dotyczy ciaa ptli. */

	__except (EXCEPTION_EXECUTE_HANDLER) {
		_tprintf (_T("Blad przetwarzania pliku %s\n"), argv[iFile]);
		DeleteFile (outFileName);
	}
	_tprintf (_T("Przeksztalcono wszystkie pliki (oprocz wymienionych wyjatkow).\n"));
	return 0;
}
