/* Rozdzia 4.  Excption.c
	Celowe generowanie wyjtkw i reagowanie na nie. */

#include "Everything.h"
#include <float.h>

DWORD Filter (LPEXCEPTION_POINTERS, LPDWORD);
double x = 1.0, y = 0.0;
int _tmain (int argc, LPTSTR argv [])
{
	DWORD eCategory, i = 0, ix, iy = 0;
	LPDWORD pNull = NULL;
	BOOL done = FALSE;
	DWORD fpOld, fpNew, fpOldDummy;
	//__try { /* Blok try-finally. */
						/* Zapisywanie dawnej maski kontrolnej. */
	_controlfp_s (&fpOld, 0, 0);
						/* Wcza wyjtki zmiennoprzecinkowe. */
	fpNew = fpOld & ~(EM_OVERFLOW | EM_UNDERFLOW | EM_INEXACT
			| EM_ZERODIVIDE | EM_DENORMAL | EM_INVALID);
						/* Ustawianie nowej maski kontrolnej. */
	_controlfp_s (&fpOldDummy, fpNew, MCW_EM);
	while (!done) __try {
		_tprintf (_T("Podaj rodzaj wyjatku:\n"));
		_tprintf (_T(" 1: Pam, 2: Calk, 3: Zmien, 4: Uzyt, 5: __leave 6: return\n"));
		_tscanf_s (_T("%d"), &i);
		__try { /* Blok try-except. */
			switch (i) {
			case 1: /* Odwoanie do pamici. */
				ix = *pNull;
				*pNull = 5;
				break;
			case 2: /* Arytmetyka cakowitoliczbowa. */
				ix = ix / iy;
				break;
			case 3: /* Wyjtek zmiennoprzecinkowy. */
				x = x / y;
				_tprintf (_T("x = %20e\n"), x);
				break;
			case 4: /* Wyjtek wygenerowany przez uytkownika. */
				ReportException (_T("Zglaszanie wyjatku uzytkownika.\n"), 1);
				break;
			case 5: /* Uyj instrukcji _leave, aby zakoczy dziaanie. */
				done = TRUE;
				__leave;
			case 6: /* Uyj instrukcji _leave, aby zakoczy dziaanie. */
				return 1;
			default: done = TRUE;
			}
		} /* Koniec wewntrznego bloku __try. */

		__except (Filter (GetExceptionInformation (), &eCategory)){
			switch (eCategory) {
			case 0:	_tprintf (_T("Nieznany wyjatek.\n"));
				break;
			case 1:	_tprintf (_T("Wyjatek przy odwolaniu do pamieci.\n"));
				break;
			case 2:	_tprintf (_T("Wyjatek calkowitoliczbowy.\n"));
				break;
			case 3:	
	 			_tprintf (_T("Wyjatek zmiennoprzecinkowy.\n"));
				break;
			case 10: _tprintf (_T("Wyjatek uzytkownika.\n"));
				break; 
			default: _tprintf (_T("Nieznany wyjatek.\n"));
				break;
			}
			_tprintf (_T("Koniec procedury.\n"));
		} /* Koniec wewntrznego bloku __try __except. */


	
	//} /* Koniec ptli do generowania wyjtkw. */

	//return; /* Powoduje awaryjne zakoczenie pracy. */

	} /* Koniec zewntrznego bloku __try __finally */
	__finally {
		BOOL AbTerm; /* Przywracanie dawnej maski. */
		_controlfp_s (&fpOldDummy, fpOld, MCW_EM);
		AbTerm = AbnormalTermination();
		_tprintf (_T("Zakonczenie awaryjne?: %d\n"), !AbTerm);
 	}
	return 0;
}

static DWORD Filter (LPEXCEPTION_POINTERS pExP, LPDWORD eCategory)

/*	Okrelanie kategorii wyjtku i decydowanie, czy kontynuowa dziaanie, czy
	uruchomi procedur obsugi, czy szuka procedury obsugi, ktra potrafi
	przetworzy wyjtek tego typu. Kategoria wyjtku jest wana tylko dla
	procedury obsugi wyjtkw. */
{
	DWORD exCode;
	DWORD_PTR readWrite, virtAddr;
	exCode = pExP->ExceptionRecord->ExceptionCode;
	_tprintf (_T("Funkcja Filter. exCode: %x\n"), exCode);
	if ((0x20000000 & exCode) != 0) {
				/* Wyjtek uytkownika. */
		*eCategory = 10;
		return EXCEPTION_EXECUTE_HANDLER;
	}

	switch (exCode) {
		case EXCEPTION_ACCESS_VIOLATION:
				/* Okrelanie, czy operacja to odczyt, zapis czy wykonywanie. Okrelanie
					adresu wirtualnego. */
			readWrite =
				(DWORD)(pExP->ExceptionRecord->ExceptionInformation [0]);
			virtAddr =
				(DWORD)(pExP->ExceptionRecord->ExceptionInformation [1]);
			_tprintf
				(_T("Naruszenie dostepu. Odczyt/Zapis/Wykonanie: %d. Adres: %x\n"),
				readWrite, virtAddr);
			*eCategory = 1;
			return EXCEPTION_EXECUTE_HANDLER;
		case EXCEPTION_ARRAY_BOUNDS_EXCEEDED:
			*eCategory = 1;
			return EXCEPTION_EXECUTE_HANDLER;
					/* Wyjtek cakowitoliczbowy. Wstrzymanie wykonywania. */
		case EXCEPTION_INT_DIVIDE_BY_ZERO:
		case EXCEPTION_INT_OVERFLOW:
			*eCategory = 2;
			return EXCEPTION_EXECUTE_HANDLER;
					/* Wyjtek zmiennoprzecinkowy. Prba kontynuowania wykonywania. */
					/* Zwraca maksymaln warto zmiennoprzecinkow. */
		case EXCEPTION_FLT_DIVIDE_BY_ZERO:
		case EXCEPTION_FLT_OVERFLOW:
			_tprintf (_T("Wyjatek zmiennoprzecinkowy  dlugi wynik.\n"));
			*eCategory = 3;
			_clearfp();
			return EXCEPTION_EXECUTE_HANDLER;
		case EXCEPTION_FLT_DENORMAL_OPERAND:
		case EXCEPTION_FLT_INEXACT_RESULT:
		case EXCEPTION_FLT_INVALID_OPERATION:
		case EXCEPTION_FLT_STACK_CHECK:
			_tprintf (_T("Wyjatek zmiennoprzecinkowy - nieznany wynik.\n"));
			*eCategory = 3;
			return EXCEPTION_CONTINUE_EXECUTION;
					/* Zwraca minimaln warto zmiennoprzecinkow. */
		case EXCEPTION_FLT_UNDERFLOW:
			_tprintf (_T("Wyjatek zmiennoprzecinkowy - maly wynik.\n"));
			*eCategory = 3;
			return EXCEPTION_CONTINUE_EXECUTION;
		case EXCEPTION_DATATYPE_MISALIGNMENT:
			*eCategory = 4;
			return EXCEPTION_CONTINUE_SEARCH;
		case STATUS_NONCONTINUABLE_EXCEPTION:
			*eCategory = 5;
			return EXCEPTION_EXECUTE_HANDLER;
		case EXCEPTION_ILLEGAL_INSTRUCTION:
		case EXCEPTION_PRIV_INSTRUCTION:
			*eCategory = 6;
			return EXCEPTION_EXECUTE_HANDLER;
		case STATUS_NO_MEMORY:
			*eCategory = 7;
			return EXCEPTION_EXECUTE_HANDLER;
		default:
			*eCategory = 0;
			return EXCEPTION_CONTINUE_SEARCH;
	}
}
