/* Rozdzia 4. CNTRLC.C */
/* Przechwytywanie kombinacji Cntrl+C. */

#include "Everything.h"

static BOOL WINAPI Handler(DWORD cntrlEvent);
static BOOL exitFlag = FALSE;

int _tmain(int argc, LPTSTR argv[])

/* Okresowe generowanie dwiku do czasu otrzymania dania zakoczenia. */
{
		/* Dodawanie procedury obsugi zdarzenia. */
	if (!SetConsoleCtrlHandler(Handler, TRUE))
		ReportError(_T("Blad ustawiania procedury obslugi zdarzenia."), 1, TRUE);
	
	while (!exitFlag) { /* Ta flaga jest wykrywana bezporednio po dwiku, a przed wyjciem z procedury obsugi. */
		Sleep(4750); /* Generowanie dwiku co pi sekund. Dwik trwa przez 250 milisekund. */
		Beep(1000 /* Czstotliwo. */, 250 /* Czas trwania. */);
	}
	_tprintf(_T("Zatrzymywanie programu glownego zgodnie z poleceniem.\n"));
	return 0;
}	

BOOL WINAPI Handler(DWORD cntrlEvent)
{
	switch (cntrlEvent) { 
		/* Czas zgoszenia okrela, czy pojawi si drugi komunikat. */
		case CTRL_C_EVENT:
			_tprintf(_T("Procedura obslugi otrzymala sygnal Ctrl-C. Zamkniecie za nie wiecej niz piec sekund.\n"));
			exitFlag = TRUE;
			Sleep(4000); /* Aby uzyska inny efekt, naley zmniejszy t warto. */
			_tprintf(_T("Zamkniecie za nie wiecej niz sekunde.\n"));
			return TRUE; /* TRUE oznacza, e sygna obsuono. */
		case CTRL_CLOSE_EVENT:
			_tprintf(_T("Zdarzenie close. Koniec za nie wiecej niz piec sekund.\n"));
			exitFlag = TRUE;
			Sleep(4000); /* Aby uzyska inny efekt, naley zmniejszy t warto. */
			_tprintf(_T("Zamkniecie metody za nie wiecej niz sekunde.\n"));
			return TRUE; /* Sprbuj zwrci warto FALSE. Czy co si zmienio? */
		default:
			_tprintf(_T("Zdarzenie: %d. Koniec za nie wiecej niz piec sekund.\n"), cntrlEvent);
			exitFlag = TRUE;
			Sleep(4000); /* Aby uzyska inny efekt, naley zmniejszy t warto. */
			_tprintf(_T("Zamkniecie metody za nie wiecej niz sekunde.\n"));
			return TRUE; /* TRUE oznacza, e sygna obsuono. */
	}
}
