/* Rozdzia 3. Polecenie do wywietlania plikw w systemie Windows - lsW. */
/* lsW[opcje][pliki]
	Wywietlanie atrybutw jednego lub kilku plikw.
	Opcje:
		-R	rekurencja
		-l	wywietlanie dugiej listy (rozmiar i czas modyfikacji)
			W zalenoci od funkcji ProcessItem program wywietla te
			waciciela i uprawnienia (zobacz rozdzia o zabezpieczeniach). */

/* Ten program ilustruje:
		1.	Uchwyty wyszukiwania i przechodzenie po katalogu.
		2.	Atrybuty pliku - w tym czas.
		3.	Stosowanie funkcji do obsugi uniwersalnych acuch do wywietlania informacji o plikach. */

/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
/* POCZTEK STANDARDOWEGO KODU */

#include "Everything.h"

BOOL TraverseDirectory(LPTSTR, LPTSTR, DWORD, LPBOOL);
DWORD FileType(LPWIN32_FIND_DATA);
BOOL ProcessItem(LPWIN32_FIND_DATA, DWORD, LPBOOL);

int _tmain(int argc, LPTSTR argv[])
{
	BOOL flags[MAX_OPTIONS], ok = TRUE;
	TCHAR searchPattern[MAX_PATH + 1], currPath[MAX_PATH_LONG+1], parentPath[MAX_PATH_LONG+1];
	LPTSTR pSlash, pSearchPattern;
	int i, fileIndex;
	DWORD pathLength;

	fileIndex = Options(argc, argv, _T("Rl"), &flags[0], &flags[1], NULL);

	/* "Przetwarzanie" wzorca wyszukiwania na dwie czci: katalog nadrzdny i
		nazw pliku lub wyraenie wieloznaczne. Nazwa pliku to najduszy
		przyrostek bez ukonika.
		Katalog nadrzdny to przedrostek z ukonikiem.
		Operacja  ta jest wykonywana dla wszystkich wzorcw wyszukiwania z wiersza polece.
		Jeli uytkownik nie poda pliku, program uywa symbolu * jako wzorca wyszukiwania. */

	pathLength = GetCurrentDirectory(MAX_PATH_LONG, currPath); 
	if (pathLength == 0 || pathLength >= MAX_PATH_LONG) { /* pathLength >= MAX_PATH_LONG (32780) powinna by niemoliwa. */
		ReportError(_T("Blad funkcji GetCurrentDirectory."), 1, TRUE);
	}

	if (argc < fileIndex + 1) 
		ok = TraverseDirectory(currPath, _T("*"), MAX_OPTIONS, flags);
	else for (i = fileIndex; i < argc; i++) {
		if (_tcslen(argv[i]) >= MAX_PATH) {
			ReportError(_T("Argument w wierszu polecen jest dluzszy niz maksimum obslugiwane przez program."), 2, FALSE);
		}
		_tcscpy(searchPattern, argv[i]);
		_tcscpy(parentPath, argv[i]);

		/* Wyszukiwanie ukonika pierwszego od prawej (jeli taki istnieje).
			Ustawianie cieki i uywanie reszty jako nazwy pliku. */
		pSlash = _tstrrchr(parentPath, _T('\\')); 
		if (pSlash != NULL) {
			*pSlash = _T('\0');
			_tcscat(parentPath, _T("\\"));         
			SetCurrentDirectory(parentPath); 
			pSlash = _tstrrchr(searchPattern, _T('\\'));  
			pSearchPattern = pSlash + 1;
		} else pSearchPattern = searchPattern;
		ok = TraverseDirectory(parentPath, pSearchPattern, MAX_OPTIONS, flags) && ok;
		SetCurrentDirectory(currPath);	 /*Przywracanie katalogu roboczego. */
	}

	return ok ? 0 : 1;
}

static BOOL TraverseDirectory(LPTSTR parentPath, LPTSTR searchPattern, DWORD numFlags, LPBOOL flags)

/* Przechodzenie po katalogu i wykonywanie specyficznych dla implementacji opercji dla kadej
	napotkanej nazwy. Operacja w tej wersji to "wywietlanie (opcjonalnie z atrybutami). */
/* searchPattern: wzgldna lub absolutna cieka searchPattern do przejcia w ciece parentPath.  */
/* Pocztkowo biecy katalog to parentPath zakoczony znakiem \. */
{
	HANDLE searchHandle;
	WIN32_FIND_DATA findData;
	BOOL recursive = flags[0];
	DWORD fType, iPass, lenParentPath;

	/* Otwieranie uchwytu przeszukiwania katalogu i pobieranie
		nazwy pierwszego pliku zgodnego ze ciek.
		Dwa przebiegi - pierwszy przetwarza pliki,
		a drugi - katalogi. */

	if ( _tcslen(searchPattern) == 0 ) 
	{
		_tcscat(searchPattern, _T("*"));
	}

	/* Otwieranie uchwytu przeszukiwania katalogu i pobieranie pierwszej nazwy
		pliku zgodnej ze ciek. Dwa przebiegi - pierwszy przetwarza pliki,
		a drugi - katalogi. */

	for (iPass = 1; iPass <= 2; iPass++) {
		searchHandle = FindFirstFile(searchPattern, &findData);
		if (searchHandle == INVALID_HANDLE_VALUE) {
			ReportError(_T("Blad otwierania uchwytu przeszukiwania."), 0, TRUE);
			return FALSE;
		}

		/* Przegldanie katalogu i jego podkatalogw pod ktem plikw zgodnych ze wzorcem. */
		do {

		/* Dla kadego znalezionego pliku naley pobra typ. W przebiegu pierwszym wywietlane 
		    s wszystkie dane. W przebiegu drugim program wywietla nazw katalogu i rekurencyjnie
			przetwarza zawarto podkatalogu (jeli uyto opcji rekurencji). */
			fType = FileType(&findData);
			if (iPass == 1) /* ProcessItem wywietla atrybuty. */
				ProcessItem(&findData, MAX_OPTIONS, flags);

			lenParentPath = (DWORD)_tcslen(parentPath);
			/* Przechodzenie po podkatalogu w drugim przebiegu. */
			if (fType == TYPE_DIR && iPass == 2 && recursive) {
				_tprintf(_T("\n%s\\%s:"), parentPath, findData.cFileName);
				SetCurrentDirectory(findData.cFileName);
				if (_tcslen(parentPath) + _tcslen(findData.cFileName) >= MAX_PATH_LONG-1) {
					ReportError(_T("Nazwa jest za dluga."), 10, FALSE);
				}
				_tcscat (parentPath, findData.cFileName);
				_tcscat (parentPath, _T("\\"));
				TraverseDirectory(parentPath, _T("*"), numFlags, flags);
				/* Przywracanie cieki do katalogu nadrzdnego. */
				parentPath[lenParentPath] = _T('\0');
				SetCurrentDirectory(parentPath); /* SetCurrentDirectory(_T("..")); take zadziaa. */
			}

			/* Pobieranie nazwy nastpnego pliku lub katalogu. */

		} while (FindNextFile(searchHandle, &findData));

		FindClose(searchHandle);
	}
	return TRUE;
}

static DWORD FileType(LPWIN32_FIND_DATA pFileData)

/* Zwracany jest typ pliku ze struktury do wyszukiwania danych.
	Obsugiwane typy:
		TYPE_FILE:	Plik
		TYPE_DIR:	Katalog inny ni . lub ..
		TYPE_DOT:	Katalog . lub ..  */
{
	BOOL isDir;
	DWORD fType;
	fType = TYPE_FILE;
	isDir =(pFileData->dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) != 0;
	if (isDir)
		if (lstrcmp(pFileData->cFileName, _T(".")) == 0
				|| lstrcmp(pFileData->cFileName, _T("..")) == 0)
			fType = TYPE_DOT;
		else fType = TYPE_DIR;
	return fType;
}
/*  KONIEC STANDARDOWEGO KODU */
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

static BOOL ProcessItem(LPWIN32_FIND_DATA pFileData, DWORD numFlags, LPBOOL flags)

/* Funkcja do przetwarzania pliku lub katalogu (tu przetwarzanie polega na 
    wywietlaniu atrybutw). Ta implementacja pokazuje tylko wywietla
	tylko istotn cz dugoci pliku. */
{
	const TCHAR fileTypeChar[] = {_T(' '), _T('d')};
	DWORD fType = FileType(pFileData);
	BOOL longList = flags[1];
	SYSTEMTIME lastWrite;

	if (fType != TYPE_FILE && fType != TYPE_DIR) return FALSE;

	_tprintf(_T("\n"));
	if (longList) {
		_tprintf(_T("%c"), fileTypeChar[fType - 1]);
		_tprintf(_T("%10d"), pFileData->nFileSizeLow);
		FileTimeToSystemTime(&(pFileData->ftLastWriteTime), &lastWrite);
		_tprintf(_T("	%02d/%02d/%04d %02d:%02d:%02d"),
				lastWrite.wMonth, lastWrite.wDay,
				lastWrite.wYear, lastWrite.wHour,
				lastWrite.wMinute, lastWrite.wSecond);
	}
	_tprintf(_T(" %s"), pFileData->cFileName);
	return TRUE;
}
