/*  Testowanie blokowania. Rozdzia 3. */
#include "Everything.h"

/*  Stosowanie: TestLock NazwaPliku tryb
Tryb: 1 - zajmowanie blokady na wspuytkowanie i utrzymywanie jej do czasu otrzymania dania jej zwolnienia
      2 - zajmowanie blokady na wyczno i utrzymywanie jej do czasu otrzymania dania jej zwolnienia
      3 - prba odczytu pliku i ponawianie jej na danie
	  4 - prba zapisu danych do pliku i ponawianie jej na danie */

/*	Ten bardzo prosty program zbudowano, aby zilustrowa logik blokowania plikw
	opisan w tabelach.
	Potrzebne s dwie konsole, a w kadej z nich naley uruchomi program TestLock.exe
	w rnym trybie. Najpierw utwrz may plik na potrzeyb testw. 
	Zamy, e jego nazwa to "lock.txt".
	W konsoli 1 mona wykona instrukcj:
		TestLock lock.txt 1
	aby utworzy blokad na wspuytkowanie. Sprbuj w konsoli 2 wykona kolejno instrukcje:
		TestLock lock.txt 2     nie mona utworzy blokady na wyczno przy aktywnej blokadzie na wspuytkowanie
		TestLock lock.txt 1     mona utworzy drug blokad na wspuytkowanie
		TestLock lock.txt 4     nie mona zapisa danych przy blokadzie na wspuytkowanie
		TestLock lock.txt 3     mona wczytywa dane przy blokadzie na wspuytkowanie.
*/

int _tmain (int argc, LPTSTR argv[])

{
	HANDLE fh;
	TCHAR String[] = _T("Hello, world."), Buffer[8] = _T("12345678"), c;
	int command;
	OVERLAPPED ov = {0, 0, 0, 0, NULL};
	DWORD nRead = 0, nWrite = 0;

	if (!WindowsVersionOK (3, 1)) 
		ReportError (_T("Ten program wymaga systemu Windows NT 3.1 lub nowszego."), 1, FALSE);

	if (argc < 3) ReportError (_T("Brak nazwy pliku i polecenia."), 1, FALSE);

	command = _ttoi(argv[2]);

	fh = CreateFile (argv[1], GENERIC_READ | GENERIC_WRITE, 
		FILE_SHARE_READ | FILE_SHARE_WRITE, NULL, OPEN_EXISTING,
		0, NULL);
	if (fh == INVALID_HANDLE_VALUE)
		ReportError (_T("Nie mozna otworzyc pliku."), 2, TRUE);

	switch (command) {
		case 1:	/* Zajmowanie blokady na wspuytkowanie i utrzymywanie jej do czasu otrzymania dania jej zwolnienia. */
				if (!LockFileEx (fh, LOCKFILE_FAIL_IMMEDIATELY, 
					0, 32, 0, &ov))
					ReportError (_T("Nieudane tworzenie blokady na wspoluzytkowanie."), 3, TRUE);
				_tprintf (_T("\nWpisz dowolny znak, aby zwolnic blokade na wspoluzytkowanie."));
				_tscanf (_T("%c"), &c);
				if (!UnlockFileEx (fh, 0, 32, 0, &ov))
					ReportError (_T("Nieudane zwolnienie blokady na wspoluzytkowanie."), 3, TRUE);
				_tprintf (_T("\nZwolniono blokade."));

				break;
		
		case 2:	/* Zajmowanie blokady na wyczno i utrzymywanie jej do czasu otrzymania dania jej zwolnienia. */
				if (!LockFileEx (fh, LOCKFILE_EXCLUSIVE_LOCK | LOCKFILE_FAIL_IMMEDIATELY,
					0, 32, 0, &ov))
					ReportError (_T("Nieudane tworzenie blokady na wylacznosc."), 3, TRUE);
				_tprintf (_T("\nWpisz dowolny znak, aby zwolnic blokade na wylacznosc."));
				_tscanf (_T("%c"), &c);
				if (!UnlockFileEx (fh, 0, 32, 0, &ov))
					ReportError (_T("Nieudane zwolnienie blokady na wylacznosc."), 3, TRUE);
				_tprintf (_T("\nZwolniono blokade."));

				break;

		case 3:	/* Odczyt rekordu. */
				if (!ReadFile (fh, Buffer, sizeof(Buffer), &nRead, NULL))
					ReportError (_T("Nieudany odczty pliku."), 0, TRUE);
				else _tprintf (_T("\nOdczyt zakonczony powodzeniem: %c %c"), Buffer[0], Buffer[1]);
				break;

		case 4: /* Write a record */
				if (!WriteFile (fh, String, sizeof(TCHAR) * (DWORD)(_tcslen(String) + 1), &nWrite, NULL))
						ReportError (_T("Nieudany zapis pliku."), 0, TRUE);
				else _tprintf (_T("\nZapis zakonczony powodzeniem."));
				break;
				
		default:
				break;
	}

	return 0;
}
